/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.opentracing;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapExtractAdapter;
import io.opentracing.tag.Tags;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.tracing.AbstractTracingProvider;
import org.apache.cxf.tracing.opentracing.TraceScope;

public abstract class AbstractOpenTracingProvider
extends AbstractTracingProvider {
    protected static final Logger LOG = LogUtils.getL7dLogger(AbstractOpenTracingProvider.class);
    protected static final String TRACE_SPAN = "org.apache.cxf.tracing.opentracing.span";
    protected final Tracer tracer;

    protected AbstractOpenTracingProvider(Tracer tracer) {
        this.tracer = tracer;
    }

    protected AbstractTracingProvider.TraceScopeHolder<TraceScope> startTraceSpan(Map<String, List<String>> requestHeaders, URI uri, String method) {
        SpanContext parent = this.tracer.extract(Format.Builtin.HTTP_HEADERS, (Object)new TextMapExtractAdapter(requestHeaders.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, this::getFirstValueOrEmpty))));
        Scope scope = null;
        scope = parent == null ? this.tracer.buildSpan(this.buildSpanDescription(uri.getPath(), method)).startActive(false) : this.tracer.buildSpan(this.buildSpanDescription(uri.getPath(), method)).asChildOf(parent).startActive(false);
        scope.span().setTag(Tags.HTTP_METHOD.getKey(), method);
        scope.span().setTag(Tags.HTTP_URL.getKey(), uri.toString());
        Span span = null;
        if (this.isAsyncResponse()) {
            span = scope.span();
            this.propagateContinuationSpan(span);
            scope.close();
        }
        return new AbstractTracingProvider.TraceScopeHolder((Object)new TraceScope(span, scope), span != null);
    }

    protected void stopTraceSpan(Map<String, List<String>> requestHeaders, Map<String, List<Object>> responseHeaders, int responseStatus, AbstractTracingProvider.TraceScopeHolder<TraceScope> holder) {
        if (holder == null) {
            return;
        }
        TraceScope traceScope = (TraceScope)holder.getScope();
        if (traceScope != null) {
            Span span = traceScope.getSpan();
            Scope scope = traceScope.getScope();
            if (holder.isDetached()) {
                scope = this.tracer.scopeManager().activate(span, false);
            }
            scope.span().setTag(Tags.HTTP_STATUS.getKey(), (Number)responseStatus);
            scope.span().finish();
            scope.close();
        }
    }

    protected boolean isAsyncResponse() {
        return !PhaseInterceptorChain.getCurrentMessage().getExchange().isSynchronous();
    }

    private void propagateContinuationSpan(Span continuation) {
        PhaseInterceptorChain.getCurrentMessage().put(Span.class, (Object)continuation);
    }

    private String getFirstValueOrEmpty(Map.Entry<String, List<String>> entry) {
        List<String> values = entry.getValue();
        if (values == null || values.isEmpty()) {
            return "";
        }
        String value = values.get(0);
        return value != null ? value : "";
    }
}

