/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.opentracing;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import java.util.concurrent.Callable;
import org.apache.cxf.tracing.Traceable;
import org.apache.cxf.tracing.TracerContext;
import org.apache.cxf.tracing.opentracing.ScopedSpan;

public class OpenTracingContext
implements TracerContext {
    private final Tracer tracer;
    private final Span continuation;

    public OpenTracingContext(Tracer tracer) {
        this(tracer, null);
    }

    public OpenTracingContext(Tracer tracer, Span continuation) {
        this.tracer = tracer;
        this.continuation = continuation;
    }

    public Scope startSpan(String description) {
        return this.newOrChildSpan(description, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T continueSpan(Traceable<T> traceable) throws Exception {
        Scope scope = null;
        if (this.tracer.activeSpan() == null && this.continuation != null) {
            scope = this.tracer.scopeManager().activate(this.continuation);
        }
        try {
            Object object = traceable.call((TracerContext)new OpenTracingContext(this.tracer));
            return (T)object;
        }
        finally {
            if (this.continuation != null && scope != null) {
                scope.close();
            }
        }
    }

    public <T> Callable<T> wrap(String description, final Traceable<T> traceable) {
        Callable callable = new Callable<T>(){

            @Override
            public T call() throws Exception {
                return traceable.call((TracerContext)new OpenTracingContext(OpenTracingContext.this.tracer));
            }
        };
        Span parent = this.tracer.activeSpan();
        return () -> {
            try (Scope scope = this.newOrChildSpan(description, parent);){
                Object v = callable.call();
                return v;
            }
        };
    }

    public void annotate(String key, String value) {
        Span current = this.tracer.activeSpan();
        if (current != null) {
            current.setTag(key, value);
        }
    }

    public void timeline(String message) {
        Span current = this.tracer.activeSpan();
        if (current != null) {
            current.log(message);
        }
    }

    public <T> T unwrap(Class<T> clazz) {
        if (Tracer.class.equals(clazz)) {
            return (T)this.tracer;
        }
        throw new IllegalArgumentException("The class is '" + String.valueOf(clazz) + "'not supported and cannot be unwrapped");
    }

    private Scope newOrChildSpan(String description, Span parent) {
        Span span = parent == null ? this.tracer.buildSpan(description).start() : this.tracer.buildSpan(description).asChildOf(parent).start();
        return new ScopedSpan(span, this.tracer.scopeManager().activate(span));
    }
}

