/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.interceptor;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.XMLEvent;
import org.apache.cxf.Bus;
import org.apache.cxf.annotations.SchemaValidation;
import org.apache.cxf.binding.soap.Soap11;
import org.apache.cxf.binding.soap.Soap12;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.SoapVersionFactory;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.headers.Header;
import org.apache.cxf.headers.HeaderManager;
import org.apache.cxf.headers.HeaderProcessor;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.ServiceUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.staxutils.PartialXMLStreamReader;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ReadHeadersInterceptor
extends AbstractSoapInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(ReadHeadersInterceptor.class);
    private Bus bus;
    private SoapVersion version;

    public ReadHeadersInterceptor(Bus b) {
        super("read");
        this.bus = b;
    }

    public ReadHeadersInterceptor(Bus b, SoapVersion v) {
        super("read");
        this.version = v;
        this.bus = b;
    }

    public ReadHeadersInterceptor(Bus b, String phase) {
        super(phase);
        this.bus = b;
    }

    public static SoapVersion readVersion(XMLStreamReader xmlReader, SoapMessage message) {
        String ns = xmlReader.getNamespaceURI();
        String lcname = xmlReader.getLocalName();
        if (ns == null || "".equals(ns)) {
            throw new SoapFault(new org.apache.cxf.common.i18n.Message("NO_NAMESPACE", LOG, new Object[]{lcname}), Soap11.getInstance().getVersionMismatch());
        }
        SoapVersion soapVersion = SoapVersionFactory.getInstance().getSoapVersion(ns);
        if (soapVersion == null) {
            throw new SoapFault(new org.apache.cxf.common.i18n.Message("INVALID_VERSION", LOG, new Object[]{ns, lcname}), Soap11.getInstance().getVersionMismatch());
        }
        if (!"Envelope".equals(lcname)) {
            throw new SoapFault(new org.apache.cxf.common.i18n.Message("INVALID_ENVELOPE", LOG, new Object[]{lcname}), soapVersion.getSender());
        }
        message.setVersion(soapVersion);
        return soapVersion;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleMessage(SoapMessage message) {
        if (this.isGET((Message)message)) {
            LOG.fine("ReadHeadersInterceptor skipped in HTTP GET method");
            return;
        }
        String verb = (String)message.get("org.apache.cxf.request.method");
        if (verb != null && !"POST".equals(verb)) {
            Fault formula405 = new Fault("HTTP verb was not GET or POST", LOG);
            formula405.setStatusCode(405);
            throw formula405;
        }
        XMLStreamReader xmlReader = (XMLStreamReader)message.getContent(XMLStreamReader.class);
        boolean closeNeeded = false;
        if (xmlReader == null) {
            InputStream in = (InputStream)message.getContent(InputStream.class);
            if (in == null) {
                throw new RuntimeException("Can't find input stream in message");
            }
            xmlReader = StaxUtils.createXMLStreamReader((InputStream)in);
            closeNeeded = true;
        }
        try {
            if (xmlReader.getEventType() == 1 || xmlReader.nextTag() == 1) {
                SoapVersion soapVersion = ReadHeadersInterceptor.readVersion(xmlReader, message);
                if (soapVersion == Soap12.getInstance() && this.version == Soap11.getInstance()) {
                    message.setVersion(this.version);
                    throw new SoapFault(new org.apache.cxf.common.i18n.Message("INVALID_11_VERSION", LOG, new Object[0]), this.version.getVersionMismatch());
                }
                PartialXMLStreamReader filteredReader = new PartialXMLStreamReader(xmlReader, message.getVersion().getBody());
                Node nd = (Node)message.getContent(Node.class);
                W3CDOMStreamWriter writer = (W3CDOMStreamWriter)message.get(W3CDOMStreamWriter.class);
                Document doc = null;
                if (writer != null) {
                    StaxUtils.copy((XMLStreamReader)filteredReader, (XMLStreamWriter)writer);
                    doc = writer.getDocument();
                } else if (nd instanceof Document) {
                    doc = (Document)nd;
                    StaxUtils.readDocElements((Document)doc, (Node)doc, (XMLStreamReader)filteredReader, (boolean)false, (boolean)false);
                } else {
                    HeadersProcessor processor = new HeadersProcessor(soapVersion);
                    doc = processor.process((XMLStreamReader)filteredReader);
                    if (doc != null) {
                        message.setContent(Node.class, doc);
                    }
                }
                if (doc != null) {
                    Element element = doc.getDocumentElement();
                    QName header = soapVersion.getHeader();
                    List elemList = DOMUtils.findAllElementsByTagNameNS((Element)element, (String)header.getNamespaceURI(), (String)header.getLocalPart());
                    for (Element elem : elemList) {
                        Element hel = DOMUtils.getFirstElement((Node)elem);
                        while (hel != null) {
                            Object obj;
                            if (elem.hasAttributes()) {
                                NamedNodeMap nnp = elem.getAttributes();
                                for (int ct = 0; ct < nnp.getLength(); ++ct) {
                                    Node headerAttrNode;
                                    Node attr = nnp.item(ct);
                                    Node node = headerAttrNode = hel.hasAttributes() ? hel.getAttributes().getNamedItemNS(attr.getNamespaceURI(), attr.getLocalName()) : null;
                                    if (headerAttrNode != null) continue;
                                    Attr attribute = hel.getOwnerDocument().createAttributeNS(attr.getNamespaceURI(), attr.getNodeName());
                                    attribute.setNodeValue(attr.getNodeValue());
                                    hel.setAttributeNodeNS(attribute);
                                }
                            }
                            HeaderProcessor p = this.bus == null ? null : ((HeaderManager)this.bus.getExtension(HeaderManager.class)).getHeaderProcessor(hel.getNamespaceURI());
                            DataBinding dataBinding = null;
                            if (p == null || p.getDataBinding() == null) {
                                obj = hel;
                            } else {
                                dataBinding = p.getDataBinding();
                                obj = dataBinding.createReader(Node.class).read((Object)hel);
                            }
                            SoapHeader shead = new SoapHeader(new QName(hel.getNamespaceURI(), hel.getLocalName()), obj, dataBinding);
                            String mu = hel.getAttributeNS(soapVersion.getNamespace(), soapVersion.getAttrNameMustUnderstand());
                            String act = hel.getAttributeNS(soapVersion.getNamespace(), soapVersion.getAttrNameRole());
                            if (!StringUtils.isEmpty((String)act)) {
                                shead.setActor(act);
                            }
                            shead.setMustUnderstand(Boolean.valueOf(mu) != false || "1".equals(mu));
                            shead.setDirection(Header.Direction.DIRECTION_IN);
                            message.getHeaders().add(shead);
                            hel = DOMUtils.getNextElement((Element)hel);
                        }
                    }
                }
                if (ServiceUtils.isSchemaValidationEnabled((SchemaValidation.SchemaValidationType)SchemaValidation.SchemaValidationType.IN, (Message)message)) {
                    message.getInterceptorChain().add((Interceptor)new CheckClosingTagsInterceptor());
                }
            }
            if (!closeNeeded) return;
        }
        catch (XMLStreamException e) {
            try {
                throw new SoapFault(new org.apache.cxf.common.i18n.Message("XML_STREAM_EXC", LOG, new Object[]{e.getMessage()}), (Throwable)e, message.getVersion().getSender());
            }
            catch (Throwable throwable) {
                if (!closeNeeded) throw throwable;
                try {
                    StaxUtils.close((XMLStreamReader)xmlReader);
                    throw throwable;
                }
                catch (XMLStreamException e2) {
                    throw new SoapFault(new org.apache.cxf.common.i18n.Message("XML_STREAM_EXC", LOG, new Object[]{e2.getMessage()}), (Throwable)e2, message.getVersion().getSender());
                }
            }
        }
        try {
            StaxUtils.close((XMLStreamReader)xmlReader);
            return;
        }
        catch (XMLStreamException e) {
            throw new SoapFault(new org.apache.cxf.common.i18n.Message("XML_STREAM_EXC", LOG, new Object[]{e.getMessage()}), (Throwable)e, message.getVersion().getSender());
        }
    }

    private static class HeadersProcessor {
        private static final XMLEventFactory FACTORY = XMLEventFactory.newInstance();
        private final QName soapVersionHeader;
        private final List<XMLEvent> events = new ArrayList<XMLEvent>(8);
        private StaxUtils.StreamToDOMContext context;
        private Document doc;
        private Node parent;

        public HeadersProcessor(SoapVersion version) {
            this.soapVersionHeader = version.getHeader();
        }

        public Document process(XMLStreamReader reader) throws XMLStreamException {
            int read = 0;
            int event = reader.getEventType();
            while (reader.hasNext()) {
                switch (event) {
                    case 1: {
                        int i;
                        ++read;
                        this.addEvent(FACTORY.createStartElement(new QName(reader.getNamespaceURI(), reader.getLocalName(), reader.getPrefix()), null, null));
                        for (i = 0; i < reader.getNamespaceCount(); ++i) {
                            this.addEvent(FACTORY.createNamespace(reader.getNamespacePrefix(i), reader.getNamespaceURI(i)));
                        }
                        for (i = 0; i < reader.getAttributeCount(); ++i) {
                            this.addEvent(FACTORY.createAttribute(reader.getAttributePrefix(i), reader.getAttributeNamespace(i), reader.getAttributeLocalName(i), reader.getAttributeValue(i)));
                        }
                        if (this.doc == null) break;
                        StaxUtils.readDocElements((Document)this.doc, (Node)this.parent, (XMLStreamReader)reader, (StaxUtils.StreamToDOMContext)this.context);
                        break;
                    }
                    case 2: {
                        if (read > 0) {
                            this.addEvent(FACTORY.createEndElement(new QName(reader.getNamespaceURI(), reader.getLocalName(), reader.getPrefix()), null));
                        }
                        --read;
                        break;
                    }
                    case 4: {
                        String s = reader.getText();
                        if (s == null) break;
                        this.addEvent(FACTORY.createCharacters(s));
                        break;
                    }
                    case 5: {
                        this.addEvent(FACTORY.createComment(reader.getText()));
                        break;
                    }
                    case 12: {
                        this.addEvent(FACTORY.createCData(reader.getText()));
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 10: 
                    case 13: {
                        break;
                    }
                }
                event = reader.next();
            }
            return this.doc;
        }

        private void addEvent(XMLEvent event) {
            if (event.isStartElement()) {
                QName qName = event.asStartElement().getName();
                if (this.soapVersionHeader.getLocalPart().equals(qName.getLocalPart()) && this.soapVersionHeader.getNamespaceURI().equals(qName.getNamespaceURI())) {
                    this.context = new StaxUtils.StreamToDOMContext(true, false, false);
                    this.doc = DOMUtils.createDocument();
                    this.parent = this.doc;
                    try {
                        for (XMLEvent ev : this.events) {
                            this.parent = StaxUtils.readDocElement((Document)this.doc, (Node)this.parent, (XMLEvent)ev, (StaxUtils.StreamToDOMContext)this.context);
                        }
                    }
                    catch (XMLStreamException e) {
                        throw new Fault((Throwable)e);
                    }
                } else {
                    this.events.add(event);
                }
            } else {
                this.events.add(event);
            }
        }
    }

    public static class CheckClosingTagsInterceptor
    extends AbstractSoapInterceptor {
        public CheckClosingTagsInterceptor() {
            super("post-logical");
        }

        public void handleMessage(SoapMessage message) throws Fault {
            XMLStreamReader xmlReader = (XMLStreamReader)message.getContent(XMLStreamReader.class);
            if (xmlReader != null) {
                try {
                    while (xmlReader.hasNext()) {
                        if (xmlReader.next() != 8) continue;
                        return;
                    }
                }
                catch (XMLStreamException e) {
                    throw new SoapFault(e.getMessage(), (Throwable)e, message.getVersion().getSender());
                }
            }
        }
    }
}

