/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type.java5;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import javax.xml.namespace.QName;
import org.apache.cxf.aegis.type.TypeMapping;
import org.apache.cxf.aegis.type.basic.BeanTypeInfo;
import org.apache.cxf.aegis.type.java5.AnnotationReader;
import org.apache.cxf.aegis.util.NamespaceHelper;

public class AnnotatedTypeInfo
extends BeanTypeInfo {
    private final AnnotationReader annotationReader;

    public AnnotatedTypeInfo(TypeMapping tm, Class typeClass, String ns) {
        this(tm, typeClass, ns, new AnnotationReader());
    }

    public AnnotatedTypeInfo(TypeMapping tm, Class typeClass, String ns, AnnotationReader annotationReader) {
        super(typeClass, ns);
        this.annotationReader = annotationReader;
        this.setTypeMapping(tm);
        this.initialize();
    }

    protected void mapProperty(PropertyDescriptor pd) {
        if (this.annotationReader.isIgnored(pd.getReadMethod())) {
            return;
        }
        String name = pd.getName();
        if (this.isAttribute(pd)) {
            this.mapAttribute(name, this.createMappedName(pd));
        } else if (this.isElement(pd)) {
            this.mapElement(name, this.createMappedName(pd));
        }
    }

    protected boolean registerType(PropertyDescriptor desc) {
        Method readMethod = desc.getReadMethod();
        Class type = this.annotationReader.getType(readMethod);
        return type == null && super.registerType(desc);
    }

    protected boolean isAttribute(PropertyDescriptor desc) {
        return this.annotationReader.isAttribute(desc.getReadMethod());
    }

    protected boolean isElement(PropertyDescriptor desc) {
        return !this.isAttribute(desc);
    }

    protected QName createMappedName(PropertyDescriptor desc) {
        return this.createQName(desc);
    }

    protected QName createQName(PropertyDescriptor desc) {
        String namespace;
        String name = this.annotationReader.getName(desc.getReadMethod());
        if (name == null) {
            name = desc.getName();
        }
        if ((namespace = this.annotationReader.getNamespace(desc.getReadMethod())) == null) {
            namespace = this.annotationReader.getNamespace(this.getTypeClass());
        }
        if (namespace == null) {
            namespace = this.annotationReader.getNamespace(this.getTypeClass().getPackage());
        }
        if (namespace == null) {
            namespace = NamespaceHelper.makeNamespaceFromClassName(this.getTypeClass().getName(), "http");
        }
        return new QName(namespace, name);
    }

    public boolean isNillable(QName name) {
        PropertyDescriptor desc = this.getPropertyDescriptorFromMappedName(name);
        if (this.annotationReader.isElement(desc.getReadMethod())) {
            return this.annotationReader.isNillable(desc.getReadMethod());
        }
        return super.isNillable(name);
    }

    public int getMinOccurs(QName name) {
        PropertyDescriptor desc = this.getPropertyDescriptorFromMappedName(name);
        if (this.annotationReader.isElement(desc.getReadMethod())) {
            return this.annotationReader.getMinOccurs(desc.getReadMethod());
        }
        return super.getMinOccurs(name);
    }
}

