/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jibx;

import java.util.Collection;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.validation.Schema;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.jibx.JibxSimpleTypes;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.service.model.MessagePartInfo;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallable;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IXMLWriter;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.StAXWriter;

public class JibxDataWriter
implements DataWriter<XMLStreamWriter> {
    public void write(Object obj, XMLStreamWriter output) {
        try {
            IBindingFactory factory = BindingDirectory.getFactory(obj.getClass());
            IMarshallingContext ctx = this.getMarshallingContext(obj);
            StAXWriter writer = new StAXWriter(factory.getNamespaces(), output);
            ctx.setXmlWriter((IXMLWriter)writer);
            ((IMarshallable)obj).marshal(ctx);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void write(Object obj, MessagePartInfo part, XMLStreamWriter output) {
        Class jtype = part.getTypeClass();
        QName stype = part.getTypeQName();
        if (JibxSimpleTypes.isSimpleType(jtype)) {
            try {
                String pfx = output.getPrefix(part.getConcreteName().getNamespaceURI());
                if (StringUtils.isEmpty((String)pfx)) {
                    output.writeStartElement("tns", part.getConcreteName().getLocalPart(), part.getConcreteName().getNamespaceURI());
                    output.writeNamespace("tns", part.getConcreteName().getNamespaceURI());
                } else {
                    output.writeStartElement(pfx, part.getConcreteName().getLocalPart(), part.getConcreteName().getNamespaceURI());
                }
                output.writeCharacters(JibxSimpleTypes.toText(stype, obj));
                output.writeEndElement();
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            IBindingFactory factory = BindingDirectory.getFactory(obj.getClass());
            IMarshallingContext ctx = this.getMarshallingContext(obj);
            StAXWriter writer = new StAXWriter(factory.getNamespaces(), output);
            ctx.setXmlWriter((IXMLWriter)writer);
            ((IMarshallable)obj).marshal(ctx);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setAttachments(Collection<Attachment> attachments) {
    }

    public void setProperty(String key, Object value) {
    }

    public void setSchema(Schema s) {
    }

    private IMarshallingContext getMarshallingContext(Object object) throws JiBXException {
        IBindingFactory factory = BindingDirectory.getFactory(object.getClass());
        return factory.createMarshallingContext();
    }
}

