/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.xmlbeans;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.validation.Schema;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.xmlbeans.XmlBeansDataBinding;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.XmlTokenSource;
import org.apache.xmlbeans.impl.values.XmlObjectBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataWriterImpl
implements DataWriter<XMLStreamWriter> {
    private static final Logger LOG = LogUtils.getLogger(XmlBeansDataBinding.class);
    private Schema schema;

    public void write(Object obj, XMLStreamWriter output) {
        this.write(obj, null, output);
    }

    public void write(Object obj, MessagePartInfo part, XMLStreamWriter output) {
        try {
            Class typeClass = part.getTypeClass();
            if (!XmlObject.class.isAssignableFrom(typeClass)) {
                Class<?>[] cls;
                typeClass = (Class)part.getProperty(XmlAnySimpleType.class.getName());
                for (Class<?> c : cls = typeClass.getDeclaredClasses()) {
                    if (!"Factory".equals(c.getSimpleName())) continue;
                    try {
                        SchemaType st = (SchemaType)part.getProperty(SchemaType.class.getName());
                        XmlOptions options = new XmlOptions();
                        if (this.schema != null) {
                            options.setValidateOnSet();
                        }
                        if (!st.isDocumentType()) {
                            options.setLoadReplaceDocumentElement(null);
                        }
                        Method meth = c.getMethod("newValue", Object.class);
                        obj = meth.invoke(null, obj);
                        break;
                    }
                    catch (Exception e) {
                        throw new Fault(new Message("UNMARSHAL_ERROR", LOG, new Object[]{part.getTypeClass()}), (Throwable)e);
                    }
                }
            }
            if (obj != null || !(part.getXmlSchema() instanceof XmlSchemaElement)) {
                XMLStreamReader reader;
                XmlObjectBase source;
                XmlOptions options = new XmlOptions();
                if (this.schema != null) {
                    options.setValidateOnSet();
                }
                if (obj instanceof XmlObjectBase) {
                    source = (XmlObjectBase)obj;
                    reader = source.newCursorForce().newXMLStreamReader(options);
                } else {
                    source = (XmlTokenSource)obj;
                    reader = source.newCursor().newXMLStreamReader(options);
                }
                SchemaType st = (SchemaType)part.getProperty(SchemaType.class.getName());
                if (st != null && !st.isDocumentType()) {
                    if (StringUtils.isEmpty((String)part.getConcreteName().getNamespaceURI())) {
                        output.writeStartElement(part.getConcreteName().getLocalPart());
                    } else {
                        String pfx = output.getPrefix(part.getConcreteName().getNamespaceURI());
                        if (StringUtils.isEmpty((String)pfx)) {
                            output.writeStartElement("tns", part.getConcreteName().getLocalPart(), part.getConcreteName().getNamespaceURI());
                            output.writeNamespace("tns", part.getConcreteName().getNamespaceURI());
                        } else {
                            output.writeStartElement(pfx, part.getConcreteName().getLocalPart(), part.getConcreteName().getNamespaceURI());
                        }
                    }
                    StaxUtils.copy((XMLStreamReader)reader, (XMLStreamWriter)output, (boolean)true);
                    output.writeEndElement();
                } else {
                    StaxUtils.copy((XMLStreamReader)reader, (XMLStreamWriter)output, (boolean)true);
                }
            } else if (obj == null && this.needToRender(obj, part)) {
                output.writeStartElement(part.getConcreteName().getNamespaceURI(), part.getConcreteName().getLocalPart());
                output.writeEndElement();
            }
        }
        catch (XMLStreamException e) {
            throw new Fault(new Message("MARSHAL_ERROR", LOG, new Object[]{obj}), (Throwable)e);
        }
    }

    private boolean needToRender(Object obj, MessagePartInfo part) {
        if (part != null && part.getXmlSchema() instanceof XmlSchemaElement) {
            XmlSchemaElement element = (XmlSchemaElement)part.getXmlSchema();
            return element.isNillable() && element.getMinOccurs() > 0L;
        }
        return false;
    }

    public void setAttachments(Collection<Attachment> attachments) {
    }

    public void setProperty(String key, Object value) {
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }
}

