/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.interceptor;

import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxrs.JAXRSServiceImpl;
import org.apache.cxf.jaxrs.JAXRSUtils;
import org.apache.cxf.jaxrs.MetadataMap;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.provider.SystemQueryHandler;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXRSInInterceptor
extends AbstractPhaseInterceptor<Message> {
    public static final String RELATIVE_PATH = "relative.path";
    private static final Logger LOG = LogUtils.getL7dLogger(JAXRSInInterceptor.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(JAXRSInInterceptor.class);

    public JAXRSInInterceptor() {
        super("pre-stream");
    }

    public void handleMessage(Message message) {
        String acceptContentTypes;
        int idx;
        String path = (String)message.get((Object)Message.PATH_INFO);
        String address = (String)message.get((Object)Message.BASE_PATH);
        String httpMethod = (String)message.get((Object)Message.HTTP_REQUEST_METHOD);
        String requestContentType = (String)message.get((Object)"Content-Type");
        if (requestContentType == null) {
            requestContentType = "*/*";
        }
        if (address.startsWith("http") && (idx = address.indexOf(47, 7)) != -1) {
            address = address.substring(idx);
        }
        if (path.startsWith(address) && !(path = path.substring(address.length())).startsWith("/")) {
            path = "/" + path;
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        MultivaluedMap<String, String> queries = JAXRSUtils.getStructuredParams((String)message.get((Object)Message.QUERY_STRING), "&", true);
        SystemQueryHandler sqh = ProviderFactory.getInstance().getQueryHandler(queries);
        if (sqh != null) {
            sqh.handleQuery(message, null, queries);
        }
        if ((acceptContentTypes = (String)message.get((Object)"Accept")) == null) {
            acceptContentTypes = "*/*";
        }
        message.getExchange().put((Object)"Accept", (Object)acceptContentTypes);
        LOG.fine("Request path is: " + path);
        LOG.fine("Request HTTP method is: " + httpMethod);
        LOG.fine("Request contentType is: " + requestContentType);
        LOG.fine("Accept contentType is: " + acceptContentTypes);
        Service service = (Service)message.getExchange().get(Service.class);
        List<ClassResourceInfo> resources = ((JAXRSServiceImpl)service).getClassResourceInfos();
        MetadataMap<String, String> values = new MetadataMap<String, String>();
        OperationResourceInfo ori = JAXRSUtils.findTargetResourceClass(resources, path, httpMethod, values, requestContentType, acceptContentTypes);
        if (ori == null) {
            String errorMessage = "No operation found for path: " + path + ", contentType: " + requestContentType + ", Accept contentType: " + acceptContentTypes;
            LOG.severe(errorMessage);
            throw new Fault(new org.apache.cxf.common.i18n.Message("NO_OP_EXC", BUNDLE, new Object[]{path, requestContentType, acceptContentTypes}));
        }
        LOG.fine("Found operation: " + ori.getMethod().getName());
        message.getExchange().put(OperationResourceInfo.class, (Object)ori);
        message.put((Object)RELATIVE_PATH, values.getFirst("FINAL_MATCH_GROUP"));
        message.put((Object)"jaxrs.template.parameters", values);
        List<Object> params = JAXRSUtils.processParameters(ori, values, message);
        message.setContent(List.class, params);
    }
}

