/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.model;

import java.lang.reflect.Method;
import java.util.List;
import javax.ws.rs.ConsumeMime;
import javax.ws.rs.ProduceMime;
import javax.ws.rs.core.MediaType;
import org.apache.cxf.jaxrs.JAXRSUtils;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.URITemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationResourceInfo {
    private URITemplate uriTemplate;
    private ClassResourceInfo classResourceInfo;
    private Method method;
    private String httpMethod;

    public OperationResourceInfo(Method m, ClassResourceInfo cri) {
        this.method = m;
        this.classResourceInfo = cri;
    }

    public URITemplate getURITemplate() {
        return this.uriTemplate;
    }

    public void setURITemplate(URITemplate u) {
        this.uriTemplate = u;
    }

    public ClassResourceInfo getClassResourceInfo() {
        return this.classResourceInfo;
    }

    public void setClassResourceInfo(ClassResourceInfo c) {
        this.classResourceInfo = c;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method m) {
        this.method = m;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String m) {
        this.httpMethod = m;
    }

    public boolean isSubResourceLocator() {
        return this.httpMethod == null;
    }

    public List<MediaType> getProduceTypes() {
        ProduceMime pm = (ProduceMime)JAXRSUtils.getMethodAnnotation(this.method, ProduceMime.class);
        if (pm != null) {
            return JAXRSUtils.getMediaTypes(pm.value());
        }
        return JAXRSUtils.getProduceTypes(this.classResourceInfo.getProduceMime());
    }

    public List<MediaType> getConsumeTypes() {
        ConsumeMime pm = (ConsumeMime)JAXRSUtils.getMethodAnnotation(this.method, ConsumeMime.class);
        if (pm != null) {
            return JAXRSUtils.getMediaTypes(pm.value());
        }
        return JAXRSUtils.getConsumeTypes(this.classResourceInfo.getConsumeMime());
    }
}

