/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.Path;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class URITemplate {
    public static final String TEMPLATE_PARAMETERS = "jaxrs.template.parameters";
    public static final String LIMITED_REGEX_SUFFIX = "(/.*)?";
    public static final String UNLIMITED_REGEX_SUFFIX = "(/)?";
    public static final String FINAL_MATCH_GROUP = "FINAL_MATCH_GROUP";
    private static final Pattern TEMPLATE_NAMES_PATTERN = Pattern.compile("\\{([\\w-\\._~]+?)\\}");
    private static final String URITEMPLATE_VARIABLE_REGEX = "(.*?)";
    private final String template;
    private final String regexSuffix;
    private final boolean endsWithSlash;
    private final List<String> templateVariables;
    private final String templateRegex;
    private final Pattern templateRegexPattern;

    public URITemplate(String theTemplate) {
        this(theTemplate, null);
    }

    public URITemplate(String theTemplate, String theRegexSuffix) {
        this.template = theTemplate;
        this.regexSuffix = theRegexSuffix;
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> names = new ArrayList<String>();
        Matcher matcher = TEMPLATE_NAMES_PATTERN.matcher(this.template);
        int i = 0;
        while (matcher.find()) {
            this.copyURITemplateCharacters(this.template, i, matcher.start(), stringBuilder);
            stringBuilder.append(URITEMPLATE_VARIABLE_REGEX);
            names.add(matcher.group(1));
            i = matcher.end();
        }
        this.copyURITemplateCharacters(this.template, i, this.template.length(), stringBuilder);
        this.templateVariables = Collections.unmodifiableList(names);
        int endPos = stringBuilder.length() - 1;
        boolean bl = endPos >= 0 ? stringBuilder.charAt(endPos) == '/' : (this.endsWithSlash = false);
        if (this.regexSuffix != null) {
            if (this.endsWithSlash) {
                stringBuilder.deleteCharAt(endPos);
            }
            stringBuilder.append(this.regexSuffix);
        }
        this.templateRegex = stringBuilder.toString();
        this.templateRegexPattern = Pattern.compile(this.templateRegex);
    }

    public String getValue() {
        return this.template;
    }

    private void copyURITemplateCharacters(String templateValue, int start, int end, StringBuilder b) {
        for (int i = start; i < end; ++i) {
            char c = templateValue.charAt(i);
            if (c == '?') {
                b.append("\\?");
                continue;
            }
            b.append(c);
        }
    }

    public boolean match(String uri, MultivaluedMap<String, String> templateVariableToValue) {
        if (uri == null) {
            return this.templateRegexPattern == null;
        }
        if (this.templateRegexPattern == null) {
            return false;
        }
        Matcher m = this.templateRegexPattern.matcher(uri);
        if (!m.matches()) {
            return false;
        }
        int i = 1;
        for (String name : this.templateVariables) {
            String value = m.group(i++);
            templateVariableToValue.add((Object)name, (Object)value);
        }
        if (this.regexSuffix != null) {
            String finalGroup = m.group(i);
            templateVariableToValue.putSingle((Object)FINAL_MATCH_GROUP, (Object)(finalGroup == null ? "/" : finalGroup));
        }
        return true;
    }

    public static URITemplate createTemplate(ClassResourceInfo cri, Path path) {
        if (path == null) {
            return new URITemplate("/", UNLIMITED_REGEX_SUFFIX);
        }
        String pathValue = path.value();
        if (!pathValue.startsWith("/")) {
            pathValue = "/" + pathValue;
        }
        String suffixPattern = path.limited() ? LIMITED_REGEX_SUFFIX : UNLIMITED_REGEX_SUFFIX;
        return new URITemplate(pathValue, suffixPattern);
    }
}

