/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.apache.cxf.helpers.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryDataProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    public boolean isReadable(Class<?> type) {
        return byte[].class.isAssignableFrom(type) || InputStream.class.isAssignableFrom(type);
    }

    public Object readFrom(Class<Object> clazz, MediaType type, MultivaluedMap<String, String> headers, InputStream is) throws IOException {
        if (InputStream.class.isAssignableFrom(clazz)) {
            return is;
        }
        if (byte[].class.isAssignableFrom(clazz)) {
            return IOUtils.readBytesFromStream((InputStream)is);
        }
        throw new IOException("Unrecognized class");
    }

    public long getSize(Object t) {
        if (byte[].class.isAssignableFrom(t.getClass())) {
            return ((byte[])t).length;
        }
        return -1L;
    }

    public boolean isWriteable(Class<?> type) {
        return byte[].class.isAssignableFrom(type) || InputStream.class.isAssignableFrom(type) || File.class.isAssignableFrom(type);
    }

    public void writeTo(Object o, MediaType type, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException {
        if (InputStream.class.isAssignableFrom(o.getClass())) {
            IOUtils.copyAndCloseInput((InputStream)((InputStream)o), (OutputStream)os);
        } else if (File.class.isAssignableFrom(o.getClass())) {
            IOUtils.copyAndCloseInput((InputStream)new BufferedInputStream(new FileInputStream((File)o)), (OutputStream)os);
        } else if (byte[].class.isAssignableFrom(o.getClass())) {
            os.write((byte[])o);
        } else {
            throw new IOException("Unrecognized class");
        }
    }
}

