/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.jaxrs.JAXRSUtils;
import org.apache.cxf.jaxrs.MetadataMap;
import org.apache.cxf.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpHeadersImpl
implements HttpHeaders {
    private Message m;
    private MultivaluedMap<String, String> headers;

    public HttpHeadersImpl(Message message) {
        this.m = message;
        this.headers = new MetadataMap<String, String>((Map)message.get((Object)Message.PROTOCOL_HEADERS));
    }

    public List<MediaType> getAcceptableMediaTypes() {
        return JAXRSUtils.parseMediaTypes((String)this.m.get((Object)"Accept"));
    }

    public Map<String, Cookie> getCookies() {
        List cs = (List)this.headers.get((Object)"Cookie");
        HashMap<String, Cookie> cl = new HashMap<String, Cookie>();
        for (String c : cs) {
            Cookie cookie = Cookie.parse((String)c);
            cl.put(cookie.getName(), cookie);
        }
        return cl;
    }

    public String getLanguage() {
        String l = (String)this.headers.getFirst((Object)"Content-Language");
        return l == null ? "UTF-8" : l;
    }

    public MediaType getMediaType() {
        return MediaType.parse((String)((String)this.m.get((Object)"Content-Type")));
    }

    public MultivaluedMap<String, String> getRequestHeaders() {
        MetadataMap<String, String> map = new MetadataMap<String, String>();
        map.putAll((Map)this.headers);
        return map;
    }
}

