/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.ConsumeMime;
import javax.ws.rs.Path;
import javax.ws.rs.ProduceMime;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.cxf.jaxrs.model.AbstractResourceInfo;
import org.apache.cxf.jaxrs.model.MethodDispatcher;
import org.apache.cxf.jaxrs.model.URITemplate;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassResourceInfo
extends AbstractResourceInfo {
    private URITemplate uriTemplate;
    private MethodDispatcher methodDispatcher;
    private ResourceProvider resourceProvider;
    private List<ClassResourceInfo> subClassResourceInfo = new ArrayList<ClassResourceInfo>();
    private List<Field> paramFields;
    private List<Method> paramMethods;

    public ClassResourceInfo(Class<?> theResourceClass) {
        this(theResourceClass, false);
    }

    public ClassResourceInfo(Class<?> theResourceClass, boolean theRoot) {
        this(theResourceClass, theResourceClass, theRoot);
    }

    public ClassResourceInfo(Class<?> theResourceClass, Class<?> theServiceClass) {
        this(theResourceClass, theServiceClass, false);
    }

    public ClassResourceInfo(Class<?> theResourceClass, Class<?> theServiceClass, boolean theRoot) {
        super(theResourceClass, theServiceClass, theRoot);
        if (theRoot) {
            this.initParamFields();
            this.initParamMethods();
        }
    }

    private void initParamFields() {
        if (this.getResourceClass() == null || !this.isRoot()) {
            return;
        }
        for (Field f : this.getServiceClass().getDeclaredFields()) {
            for (Annotation a : f.getAnnotations()) {
                if (!AnnotationUtils.isParamAnnotationClass(a.annotationType())) continue;
                if (this.paramFields == null) {
                    this.paramFields = new ArrayList<Field>();
                }
                this.paramFields.add(f);
            }
        }
    }

    private void initParamMethods() {
        block0: for (Method m : this.getServiceClass().getMethods()) {
            if (!m.getName().startsWith("set") || m.getParameterTypes().length != 1) continue;
            for (Annotation a : m.getAnnotations()) {
                if (!AnnotationUtils.isParamAnnotationClass(a.annotationType())) continue;
                this.checkParamMethod(m, AnnotationUtils.getAnnotationValue(a));
                continue block0;
            }
        }
    }

    public URITemplate getURITemplate() {
        return this.uriTemplate;
    }

    public void setURITemplate(URITemplate u) {
        this.uriTemplate = u;
    }

    public MethodDispatcher getMethodDispatcher() {
        return this.methodDispatcher;
    }

    public void setMethodDispatcher(MethodDispatcher md) {
        this.methodDispatcher = md;
    }

    public boolean hasSubResources() {
        return !this.subClassResourceInfo.isEmpty();
    }

    public void addSubClassResourceInfo(ClassResourceInfo cri) {
        this.subClassResourceInfo.add(cri);
    }

    public List<ClassResourceInfo> getSubClassResourceInfo() {
        return this.subClassResourceInfo;
    }

    public ResourceProvider getResourceProvider() {
        return this.resourceProvider;
    }

    public void setResourceProvider(ResourceProvider rp) {
        this.resourceProvider = rp;
    }

    public ProduceMime getProduceMime() {
        return (ProduceMime)AnnotationUtils.getClassAnnotation(this.getServiceClass(), ProduceMime.class);
    }

    public ConsumeMime getConsumeMime() {
        return (ConsumeMime)AnnotationUtils.getClassAnnotation(this.getServiceClass(), ConsumeMime.class);
    }

    public Path getPath() {
        return (Path)AnnotationUtils.getClassAnnotation(this.getServiceClass(), Path.class);
    }

    private void addParamMethod(Method m) {
        if (this.paramMethods == null) {
            this.paramMethods = new ArrayList<Method>();
        }
        this.paramMethods.add(m);
    }

    public List<Method> getParameterMethods() {
        return this.paramMethods == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(this.paramMethods);
    }

    public List<Field> getParameterFields() {
        return this.paramFields == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(this.paramFields);
    }

    private void checkParamMethod(Method m, String value) {
        if (m.getName().equalsIgnoreCase("set" + value)) {
            this.addParamMethod(m);
        }
    }

    @Override
    public boolean isSingleton() {
        return this.resourceProvider instanceof SingletonResourceProvider;
    }
}

