/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.interceptor;

import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.JAXRSServiceImpl;
import org.apache.cxf.jaxrs.ext.RequestHandler;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.impl.RequestPreprocessor;
import org.apache.cxf.jaxrs.impl.UriInfoImpl;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXRSInInterceptor
extends AbstractPhaseInterceptor<Message> {
    public static final String RELATIVE_PATH = "relative.path";
    public static final String ROOT_RESOURCE_CLASS = "root.resource.class";
    private static final Logger LOG = LogUtils.getL7dLogger(JAXRSInInterceptor.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(JAXRSInInterceptor.class);

    public JAXRSInInterceptor() {
        super("pre-stream");
    }

    public void handleMessage(Message message) {
        try {
            this.processRequest(message);
        }
        catch (RuntimeException ex) {
            Response excResponse = JAXRSUtils.convertFaultToResponse(ex, message);
            if (excResponse == null) {
                ProviderFactory.getInstance(message).clearThreadLocalProxies();
                message.getExchange().put((Object)Message.PROPOGATE_EXCEPTION, (Object)Boolean.TRUE);
                throw ex;
            }
            message.getExchange().put(Response.class, (Object)excResponse);
        }
    }

    private void processRequest(Message message) {
        String requestContentType;
        if (message.getExchange().get(OperationResourceInfo.class) != null) {
            return;
        }
        RequestPreprocessor rp = ProviderFactory.getInstance(message).getRequestPreprocessor();
        if (rp != null) {
            rp.preprocess(message, new UriInfoImpl(message, null));
        }
        if ((requestContentType = (String)message.get((Object)"Content-Type")) == null) {
            requestContentType = "*/*";
        }
        String rawPath = HttpUtils.getPathToMatch(message, true);
        Service service = (Service)message.getExchange().get(Service.class);
        List<ClassResourceInfo> resources = ((JAXRSServiceImpl)service).getClassResourceInfos();
        String acceptTypes = (String)message.get((Object)"Accept");
        if (acceptTypes == null) {
            acceptTypes = "*/*";
            message.put((Object)"Accept", (Object)acceptTypes);
        }
        List<MediaType> acceptContentTypes = JAXRSUtils.sortMediaTypes(acceptTypes);
        message.getExchange().put((Object)"Accept", acceptContentTypes);
        MetadataMap<String, String> values = new MetadataMap<String, String>();
        ClassResourceInfo resource = JAXRSUtils.selectResourceClass(resources, rawPath, values);
        if (resource == null) {
            org.apache.cxf.common.i18n.Message errorMsg = new org.apache.cxf.common.i18n.Message("NO_ROOT_EXC", BUNDLE, new Object[]{rawPath});
            LOG.warning(errorMsg.toString());
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        message.getExchange().put((Object)ROOT_RESOURCE_CLASS, (Object)resource);
        String httpMethod = (String)message.get((Object)Message.HTTP_REQUEST_METHOD);
        OperationResourceInfo ori = null;
        List<ProviderInfo<RequestHandler>> shs = ProviderFactory.getInstance(message).getRequestHandlers();
        for (ProviderInfo<RequestHandler> sh : shs) {
            Response response;
            String newAcceptTypes = (String)message.get((Object)"Accept");
            if (!acceptTypes.equals(newAcceptTypes) || ori == null) {
                acceptTypes = newAcceptTypes;
                acceptContentTypes = JAXRSUtils.sortMediaTypes(newAcceptTypes);
                message.getExchange().put((Object)"Accept", acceptContentTypes);
                if (ori != null) {
                    values = new MetadataMap();
                    resource = JAXRSUtils.selectResourceClass(resources, rawPath, values);
                }
                try {
                    ori = JAXRSUtils.findTargetMethod(resource, (String)values.getFirst("FINAL_MATCH_GROUP"), httpMethod, values, requestContentType, acceptContentTypes);
                }
                catch (WebApplicationException ex) {
                    if (ex.getResponse() != null && ex.getResponse().getStatus() == 405 && "OPTIONS".equalsIgnoreCase(httpMethod)) {
                        Response response2 = JAXRSUtils.createResponseBuilder(resource, 200, true).build();
                        message.getExchange().put(Response.class, (Object)response2);
                        return;
                    }
                    throw ex;
                }
                message.getExchange().put(OperationResourceInfo.class, (Object)ori);
            }
            if ((response = sh.getProvider().handleRequest(message, resource)) == null) continue;
            message.getExchange().put(Response.class, (Object)response);
            return;
        }
        String newAcceptTypes = (String)message.get((Object)"Accept");
        if (!acceptTypes.equals(newAcceptTypes) || ori == null) {
            acceptTypes = newAcceptTypes;
            acceptContentTypes = JAXRSUtils.sortMediaTypes(acceptTypes);
            message.getExchange().put((Object)"Accept", acceptContentTypes);
            if (ori != null) {
                values = new MetadataMap();
                resource = JAXRSUtils.selectResourceClass(resources, rawPath, values);
            }
            ori = JAXRSUtils.findTargetMethod(resource, (String)values.getFirst("FINAL_MATCH_GROUP"), httpMethod, values, requestContentType, acceptContentTypes);
            message.getExchange().put(OperationResourceInfo.class, (Object)ori);
        }
        LOG.fine("Request path is: " + rawPath);
        LOG.fine("Request HTTP method is: " + httpMethod);
        LOG.fine("Request contentType is: " + requestContentType);
        LOG.fine("Accept contentType is: " + acceptTypes);
        LOG.fine("Found operation: " + ori.getMethodToInvoke().getName());
        message.getExchange().put(OperationResourceInfo.class, (Object)ori);
        message.put((Object)RELATIVE_PATH, values.getFirst("FINAL_MATCH_GROUP"));
        message.put((Object)"jaxrs.template.parameters", values);
        List<Object> params = JAXRSUtils.processParameters(ori, values, message);
        message.setContent(List.class, params);
    }
}

