/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.apache.cxf.aegis.AegisContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAegisProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    private static Map<Class<?>, AegisContext> classContexts = new WeakHashMap();
    @Context
    protected ContextResolver<AegisContext> resolver;

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] anns, MediaType mt) {
        return this.isSupported(type, genericType, anns);
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return this.isSupported(type, genericType, annotations);
    }

    public long getSize(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return -1L;
    }

    protected AegisContext getAegisContext(Class<?> type, Type genericType) {
        AegisContext context;
        if (this.resolver != null && (context = (AegisContext)this.resolver.getContext(type)) != null) {
            return context;
        }
        return this.getClassContext(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AegisContext getClassContext(Class<?> type) {
        Map<Class<?>, AegisContext> map = classContexts;
        synchronized (map) {
            AegisContext context = classContexts.get(type);
            if (context == null) {
                context = new AegisContext();
                context.setWriteXsiTypes(true);
                context.setReadXsiTypes(true);
                HashSet rootClasses = new HashSet();
                rootClasses.add(type);
                context.setRootClasses(rootClasses);
                context.initialize();
                classContexts.put(type, context);
            }
            return context;
        }
    }

    protected boolean isSupported(Class<?> type, Type genericType, Annotation[] annotations) {
        return true;
    }
}

