/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.servlet;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang.ClassUtils;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.lifecycle.PerRequestResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.transport.servlet.CXFNonSpringServlet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CXFNonSpringJaxrsServlet
extends CXFNonSpringServlet {
    private static final String SERVICE_ADDRESS_PARAM = "jaxrs.address";
    private static final String SERVICE_CLASSES_PARAM = "jaxrs.serviceClasses";
    private static final String PROVIDERS_PARAM = "jaxrs.providers";
    private static final String SERVICE_SCOPE_PARAM = "jaxrs.scope";
    private static final String SERVICE_SCOPE_SINGLETON = "singleton";
    private static final String SERVICE_SCOPE_REQUEST = "prototype";
    private static final String JAXRS_APPLICATION_PARAM = "javax.ws.rs.Application";

    public void loadBus(ServletConfig servletConfig) throws ServletException {
        super.loadBus(servletConfig);
        String applicationClass = servletConfig.getInitParameter(JAXRS_APPLICATION_PARAM);
        if (applicationClass != null) {
            this.createServerFromApplication(applicationClass);
            return;
        }
        String address = servletConfig.getInitParameter(SERVICE_ADDRESS_PARAM);
        if (address == null) {
            address = "/";
        }
        List<Class> resourceClasses = this.getServiceClasses(servletConfig);
        Map<Class, ResourceProvider> resourceProviders = this.getResourceProviders(servletConfig, resourceClasses);
        List<?> providers = this.getProviders(servletConfig);
        JAXRSServerFactoryBean bean = new JAXRSServerFactoryBean();
        bean.setAddress(address);
        bean.setResourceClasses(resourceClasses);
        bean.setProviders(providers);
        for (Map.Entry<Class, ResourceProvider> entry : resourceProviders.entrySet()) {
            bean.setResourceProvider(entry.getKey(), entry.getValue());
        }
        bean.create();
    }

    protected List<Class> getServiceClasses(ServletConfig servletConfig) throws ServletException {
        String serviceBeans = servletConfig.getInitParameter(SERVICE_CLASSES_PARAM);
        if (serviceBeans == null) {
            throw new ServletException("At least one resource class should be specified");
        }
        String[] classNames = serviceBeans.split(" ");
        ArrayList<Class> resourceClasses = new ArrayList<Class>();
        for (String cName : classNames) {
            if (cName.length() == 0) continue;
            Class<?> cls = this.loadClass(cName);
            resourceClasses.add(cls);
        }
        if (resourceClasses.isEmpty()) {
            throw new ServletException("At least one resource class should be specified");
        }
        return resourceClasses;
    }

    protected List<?> getProviders(ServletConfig servletConfig) throws ServletException {
        String providersList = servletConfig.getInitParameter(PROVIDERS_PARAM);
        if (providersList == null) {
            return Collections.EMPTY_LIST;
        }
        String[] classNames = providersList.split(" ");
        ArrayList<Object> providers = new ArrayList<Object>();
        for (String cName : classNames) {
            if (cName.length() == 0) continue;
            Class<?> cls = this.loadClass(cName);
            providers.add(this.createSingletonInstance(cls, servletConfig));
        }
        return providers;
    }

    protected Map<Class, ResourceProvider> getResourceProviders(ServletConfig servletConfig, List<Class> resourceClasses) throws ServletException {
        String scope = servletConfig.getInitParameter(SERVICE_SCOPE_PARAM);
        if (scope != null && !SERVICE_SCOPE_SINGLETON.equals(scope) && !SERVICE_SCOPE_REQUEST.equals(scope)) {
            throw new ServletException("Only singleton and prototype scopes are supported");
        }
        boolean isPrototype = SERVICE_SCOPE_REQUEST.equals(scope);
        HashMap<Class, ResourceProvider> map = new HashMap<Class, ResourceProvider>();
        for (Class c : resourceClasses) {
            map.put(c, isPrototype ? new PerRequestResourceProvider(c) : new SingletonResourceProvider(this.createSingletonInstance(c, servletConfig)));
        }
        return map;
    }

    private Object createSingletonInstance(Class<?> cls, ServletConfig sc) throws ServletException {
        Object[] objectArray;
        boolean isDefault;
        Constructor c = ResourceUtils.findResourceConstructor(cls, false);
        if (c == null) {
            throw new ServletException("No valid constructor found for " + cls.getName());
        }
        boolean bl = isDefault = c.getParameterTypes().length == 0;
        if (!isDefault && (c.getParameterTypes().length != 1 || c.getParameterTypes()[0] != ServletConfig.class && c.getParameterTypes()[0] != ServletContext.class)) {
            throw new ServletException("Resource classes with singleton scope can only have ServletConfig or ServletContext instances injected through their constructors");
        }
        if (isDefault) {
            objectArray = new Object[]{};
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = c.getParameterTypes()[0] == ServletConfig.class ? sc : sc.getServletContext();
        }
        Object[] values = objectArray;
        try {
            return c.newInstance(values);
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
            throw new ServletException("Resource class " + cls.getName() + " can not be instantiated");
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
            throw new ServletException("Resource class " + cls.getName() + " can not be instantiated due to IllegalAccessException");
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
            throw new ServletException("Resource class " + cls.getName() + " can not be instantiated due to InvocationTargetException");
        }
    }

    protected void createServerFromApplication(String cName) throws ServletException {
        Class<?> appClass = this.loadClass(cName);
        Application app = null;
        try {
            app = (Application)appClass.newInstance();
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
            throw new ServletException("Application class " + cName + " can not be instantiated");
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
            throw new ServletException("Application class " + cName + " can not be instantiated due to IllegalAccessException");
        }
        ArrayList<Class> resourceClasses = new ArrayList<Class>();
        ArrayList providers = new ArrayList();
        HashMap map = new HashMap();
        for (Class c : app.getClasses()) {
            resourceClasses.add(c);
            map.put(c, new PerRequestResourceProvider(c));
        }
        for (Object o : app.getSingletons()) {
            boolean isProvider;
            boolean bl = isProvider = o.getClass().getAnnotation(Provider.class) != null;
            if (isProvider) {
                providers.add(o);
                continue;
            }
            resourceClasses.add(o.getClass());
            map.put(o.getClass(), new SingletonResourceProvider(o));
        }
        JAXRSServerFactoryBean bean = new JAXRSServerFactoryBean();
        bean.setAddress("/");
        bean.setResourceClasses(resourceClasses);
        bean.setProviders(providers);
        for (Map.Entry entry : map.entrySet()) {
            bean.setResourceProvider((Class)entry.getKey(), (ResourceProvider)entry.getValue());
        }
        bean.create();
    }

    private Class<?> loadClass(String cName) throws ServletException {
        try {
            return ClassUtils.getClass((ClassLoader)CXFNonSpringJaxrsServlet.class.getClassLoader(), (String)cName.trim());
        }
        catch (ClassNotFoundException ex) {
            throw new ServletException("No resource class " + cName.trim() + " can be found", (Throwable)ex);
        }
    }
}

