/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpHeadersImpl
implements HttpHeaders {
    private Message m;
    private MultivaluedMap<String, String> headers;

    public HttpHeadersImpl(Message message) {
        this.m = message;
        this.headers = new MetadataMap<String, String>((Map)message.get((Object)Message.PROTOCOL_HEADERS));
    }

    public List<MediaType> getAcceptableMediaTypes() {
        String lValues = (String)this.headers.getFirst((Object)"Accept");
        if (lValues == null) {
            return Collections.emptyList();
        }
        return JAXRSUtils.sortMediaTypes(lValues);
    }

    public Map<String, Cookie> getCookies() {
        List values = (List)this.headers.get((Object)"Cookie");
        if (values == null || values.isEmpty()) {
            return Collections.emptyMap();
        }
        String[] cs = ((String)values.get(0)).split(",");
        HashMap<String, Cookie> cl = new HashMap<String, Cookie>();
        for (String c : cs) {
            Cookie cookie = Cookie.valueOf((String)c);
            cl.put(cookie.getName(), cookie);
        }
        return cl;
    }

    public Locale getLanguage() {
        String l = (String)this.headers.getFirst((Object)"Content-Language");
        return l == null || l.length() == 0 ? null : new Locale(l);
    }

    public MediaType getMediaType() {
        String value = (String)this.m.get((Object)"Content-Type");
        return value == null ? null : MediaType.valueOf((String)value);
    }

    public MultivaluedMap<String, String> getRequestHeaders() {
        MetadataMap<String, String> map = new MetadataMap<String, String>();
        for (String key : this.headers.keySet()) {
            map.put(key, this.getRequestHeader(key));
        }
        return map;
    }

    public List<Locale> getAcceptableLanguages() {
        List values = (List)this.headers.get((Object)"Accept-Language");
        if (values == null || values.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Locale> newLs = new ArrayList<Locale>();
        String[] ls = ((String)values.get(0)).split(",");
        HashMap<Locale, Float> prefs = new HashMap<Locale, Float>();
        for (String l : ls) {
            String[] pair = l.split(";");
            Locale locale = new Locale(pair[0].trim());
            newLs.add(locale);
            if (pair.length > 1) {
                String[] pair2 = pair[1].split("=");
                if (pair2.length > 1) {
                    prefs.put(locale, Float.valueOf(JAXRSUtils.getMediaTypeQualityFactor(pair2[1].trim())));
                    continue;
                }
                prefs.put(locale, Float.valueOf(1.0f));
                continue;
            }
            prefs.put(locale, Float.valueOf(1.0f));
        }
        if (newLs.size() == 1) {
            return newLs;
        }
        Collections.sort(newLs, new AcceptLanguageComparator(prefs));
        return newLs;
    }

    public List<String> getRequestHeader(String name) {
        String[] ls;
        List values = (List)this.headers.get((Object)name);
        if (values == null || values.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> hValues = new ArrayList<String>();
        for (String s : ls = ((String)values.get(0)).split(",")) {
            hValues.add(s.trim());
        }
        return hValues;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AcceptLanguageComparator
    implements Comparator<Locale> {
        private Map<Locale, Float> prefs;

        public AcceptLanguageComparator(Map<Locale, Float> prefs) {
            this.prefs = prefs;
        }

        @Override
        public int compare(Locale lang1, Locale lang2) {
            float p2;
            float p1 = this.prefs.get(lang1).floatValue();
            int result = Float.compare(p1, p2 = this.prefs.get(lang2).floatValue());
            return result == 0 ? result : result * -1;
        }
    }
}

