/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.validation.Schema;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.provider.AbstractConfigurableProvider;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.schemas.SchemaHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJAXBProvider
extends AbstractConfigurableProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    protected static final ResourceBundle BUNDLE = BundleUtils.getBundle(AbstractJAXBProvider.class);
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractJAXBProvider.class);
    private static final String CHARSET_PARAMETER = "charset";
    private static Map<String, JAXBContext> packageContexts = new WeakHashMap<String, JAXBContext>();
    private static Map<Class<?>, JAXBContext> classContexts = new WeakHashMap();
    private MessageContext mc;
    private Schema schema;

    protected void setContext(MessageContext context) {
        this.mc = context;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] anns, MediaType mt) {
        return this.isSupported(type, genericType, anns);
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] anns, MediaType mt) {
        return this.isSupported(type, genericType, anns);
    }

    public void setSchemaLocations(List<String> locations) {
        this.schema = SchemaHandler.createSchema(locations);
    }

    public void setSchema(Schema s) {
        this.schema = s;
    }

    public long getSize(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return -1L;
    }

    protected MessageContext getContext() {
        return this.mc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JAXBContext getJAXBContext(Class<?> type, Type genericType) throws JAXBException {
        JAXBContext customContext;
        ContextResolver resolver;
        if (this.mc != null && (resolver = this.mc.getResolver(ContextResolver.class, JAXBContext.class)) != null && (customContext = (JAXBContext)resolver.getContext(type)) != null) {
            return customContext;
        }
        resolver = classContexts;
        synchronized (resolver) {
            JAXBContext context = classContexts.get(type);
            if (context != null) {
                return context;
            }
        }
        JAXBContext context = this.getPackageContext(type);
        if (context == null && type != genericType) {
            context = this.getPackageContext(InjectionUtils.getActualType(genericType));
        }
        return context != null ? context : this.getClassContext(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JAXBContext getClassContext(Class<?> type) throws JAXBException {
        Map<Class<?>, JAXBContext> map = classContexts;
        synchronized (map) {
            JAXBContext context = classContexts.get(type);
            if (context == null) {
                context = JAXBContext.newInstance((Class[])new Class[]{type});
                classContexts.put(type, context);
            }
            return context;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JAXBContext getPackageContext(Class<?> type) {
        if (type == null) {
            return null;
        }
        Map<String, JAXBContext> map = packageContexts;
        synchronized (map) {
            String packageName = PackageUtils.getPackageName(type);
            JAXBContext context = packageContexts.get(packageName);
            if (context == null) {
                try {
                    context = JAXBContext.newInstance((String)packageName, (ClassLoader)type.getClassLoader());
                    packageContexts.put(packageName, context);
                }
                catch (JAXBException ex) {
                    LOG.fine("Error creating a JAXBContext using ObjectFactory : " + ex.getMessage());
                    return null;
                }
            }
            return context;
        }
    }

    protected boolean isSupported(Class<?> type, Type genericType, Annotation[] anns) {
        return type.getAnnotation(XmlRootElement.class) != null || JAXBElement.class.isAssignableFrom(type) || this.objectFactoryForClass(type) || type != genericType && this.objectFactoryForType(genericType) || this.adapterAvailable(type, anns);
    }

    protected boolean adapterAvailable(Class<?> type, Annotation[] anns) {
        return AnnotationUtils.getAnnotation(anns, XmlJavaTypeAdapter.class) != null || type.getAnnotation(XmlJavaTypeAdapter.class) != null;
    }

    protected boolean objectFactoryForClass(Class<?> type) {
        try {
            return type.getClassLoader().loadClass(PackageUtils.getPackageName(type) + ".ObjectFactory") != null;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private boolean objectFactoryForType(Type genericType) {
        return this.objectFactoryForClass(InjectionUtils.getActualType(genericType));
    }

    protected Unmarshaller createUnmarshaller(Class<?> cls, Type genericType) throws JAXBException {
        JAXBContext context = this.getJAXBContext(cls, genericType);
        Unmarshaller unmarshaller = context.createUnmarshaller();
        if (this.schema != null) {
            unmarshaller.setSchema(this.schema);
        }
        return unmarshaller;
    }

    protected Marshaller createMarshaller(Object obj, Class<?> cls, Type genericType, MediaType m) throws JAXBException {
        Class objClazz = JAXBElement.class.isAssignableFrom(cls) ? ((JAXBElement)obj).getDeclaredType() : cls;
        JAXBContext context = this.getJAXBContext(objClazz, genericType);
        Marshaller marshaller = context.createMarshaller();
        String enc = (String)m.getParameters().get(CHARSET_PARAMETER);
        if (enc != null) {
            marshaller.setProperty("jaxb.encoding", (Object)enc);
        }
        return marshaller;
    }

    protected Class<?> getActualType(Class<?> type, Type genericType, Annotation[] anns) {
        Class<Object> theType = null;
        theType = JAXBElement.class.isAssignableFrom(type) ? InjectionUtils.getActualType(genericType) : type;
        XmlJavaTypeAdapter adapter = this.getAdapter(theType, anns);
        if (adapter != null) {
            if (adapter.type() != XmlJavaTypeAdapter.DEFAULT.class) {
                theType = adapter.type();
            } else {
                Type[] types = InjectionUtils.getActualTypes(adapter.value().getGenericSuperclass());
                if (types != null && types.length == 2) {
                    theType = (Class)types[0];
                }
            }
        }
        return theType;
    }

    protected Object checkAdapter(Object obj, Annotation[] anns, boolean marshal) {
        XmlJavaTypeAdapter typeAdapter = this.getAdapter(obj.getClass(), anns);
        if (typeAdapter != null) {
            try {
                XmlAdapter xmlAdapter = (XmlAdapter)typeAdapter.value().newInstance();
                if (marshal) {
                    return xmlAdapter.marshal(obj);
                }
                return xmlAdapter.unmarshal(obj);
            }
            catch (Exception ex) {
                LOG.warning("Problem using the XmlJavaTypeAdapter");
                ex.printStackTrace();
            }
        }
        return obj;
    }

    protected XmlJavaTypeAdapter getAdapter(Class<?> type, Annotation[] anns) {
        XmlJavaTypeAdapter typeAdapter = AnnotationUtils.getAnnotation(anns, XmlJavaTypeAdapter.class);
        if (typeAdapter == null) {
            typeAdapter = type.getAnnotation(XmlJavaTypeAdapter.class);
        }
        return typeAdapter;
    }

    protected Schema getSchema() {
        return this.schema;
    }

    static void clearContexts() {
        classContexts.clear();
        packageContexts.clear();
    }

    protected static void handleJAXBException(JAXBException e) {
        Throwable t = e.getLinkedException() != null ? e.getLinkedException() : (e.getCause() != null ? e.getCause() : e);
        String message = new Message("JAXB_EXCEPTION", BUNDLE, new Object[]{t.getMessage()}).toString();
        LOG.warning(message);
        Response r = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("text/plain").entity((Object)message).build();
        throw new WebApplicationException(t, r);
    }
}

