/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.utils;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Providers;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PrimitiveUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.ext.ParameterHandler;
import org.apache.cxf.jaxrs.impl.PathSegmentImpl;
import org.apache.cxf.jaxrs.impl.tl.AbstractThreadLocalProxy;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalContextResolver;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalHttpHeaders;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalHttpServletRequest;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalHttpServletResponse;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalMessageContext;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalProviders;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalProxy;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalRequest;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalSecurityContext;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalServletConfig;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalServletContext;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalUriInfo;
import org.apache.cxf.jaxrs.model.AbstractResourceInfo;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.jaxrs.utils.ParameterType;
import org.apache.cxf.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InjectionUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(InjectionUtils.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(InjectionUtils.class);

    private InjectionUtils() {
    }

    public static boolean invokeBooleanGetter(Object o, String name) {
        try {
            Method method = o.getClass().getMethod(name, new Class[0]);
            return (Boolean)method.invoke(o, new Object[0]);
        }
        catch (Exception ex) {
            LOG.finest("Can not invoke method " + name + " on object of class " + o.getClass().getName());
            return false;
        }
    }

    public static Method checkProxy(Method methodToInvoke, Object resourceObject) {
        if (Proxy.class.isInstance(resourceObject)) {
            for (Class<?> c : resourceObject.getClass().getInterfaces()) {
                try {
                    Method m = c.getMethod(methodToInvoke.getName(), methodToInvoke.getParameterTypes());
                    if (m != null) {
                        return m;
                    }
                }
                catch (NoSuchMethodException ex) {
                    // empty catch block
                }
            }
        }
        return methodToInvoke;
    }

    public static void injectFieldValue(final Field f, final Object o, final Object v) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                f.setAccessible(true);
                try {
                    f.set(o, v);
                }
                catch (IllegalAccessException ex) {
                    InjectionUtils.reportServerError("FIELD_ACCESS_FAILURE", f.getType().getName());
                }
                return null;
            }
        });
    }

    public static Class<?> getActualType(Type genericType) {
        if (genericType == null || !ParameterizedType.class.isAssignableFrom(genericType.getClass())) {
            return null;
        }
        ParameterizedType paramType = (ParameterizedType)genericType;
        return (Class)paramType.getActualTypeArguments()[0];
    }

    public static Type[] getActualTypes(Type genericType) {
        if (genericType == null || !ParameterizedType.class.isAssignableFrom(genericType.getClass())) {
            return null;
        }
        ParameterizedType paramType = (ParameterizedType)genericType;
        return paramType.getActualTypeArguments();
    }

    public static void injectThroughMethod(Object requestObject, Method method, Object parameterValue) {
        try {
            Method methodToInvoke = InjectionUtils.checkProxy(method, requestObject);
            methodToInvoke.invoke(requestObject, parameterValue);
        }
        catch (IllegalAccessException ex) {
            InjectionUtils.reportServerError("METHOD_ACCESS_FAILURE", method.getName());
        }
        catch (Exception ex) {
            InjectionUtils.reportServerError("METHOD_INJECTION_FAILURE", method.getName());
        }
    }

    public static Object handleParameter(String value, Class<?> pClass, ParameterType pType, Message message) {
        ParameterHandler pm;
        String[] stringArray;
        if (value == null) {
            return null;
        }
        if (pType == ParameterType.PATH) {
            PathSegmentImpl ps = new PathSegmentImpl(value, false);
            if (PathSegment.class.isAssignableFrom(pClass)) {
                return ps;
            }
            value = ps.getPath();
        }
        if (pClass.isPrimitive()) {
            return PrimitiveUtils.read((String)value, pClass);
        }
        try {
            Constructor<?> c = pClass.getConstructor(String.class);
            return c.newInstance(value);
        }
        catch (NoSuchMethodException ex) {
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            LOG.severe(new org.apache.cxf.common.i18n.Message("CLASS_CONSTRUCTOR_FAILURE", BUNDLE, new Object[]{pClass.getName()}).toString());
            throw new WebApplicationException((Throwable)ex, HttpUtils.getParameterFailureStatus(pType));
        }
        if (pClass.isEnum()) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "fromString";
            stringArray = stringArray2;
            stringArray2[1] = "valueOf";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "valueOf";
            stringArray = stringArray3;
            stringArray3[1] = "fromString";
        }
        String[] methodNames = stringArray;
        Object result = InjectionUtils.evaluateFactoryMethod(value, pClass, pType, methodNames[0]);
        if (result == null) {
            result = InjectionUtils.evaluateFactoryMethod(value, pClass, pType, methodNames[1]);
        }
        if (message != null && (pm = ProviderFactory.getInstance(message).createParameterHandler(pClass)) != null) {
            result = pm.fromString(value);
        }
        if (result != null) {
            return result;
        }
        InjectionUtils.reportServerError("WRONG_PARAMETER_TYPE", pClass.getName());
        return null;
    }

    public static void reportServerError(String messageName, String parameter) {
        org.apache.cxf.common.i18n.Message errorMessage = new org.apache.cxf.common.i18n.Message(messageName, BUNDLE, new Object[]{parameter});
        LOG.severe(errorMessage.toString());
        Response r = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type(MediaType.TEXT_PLAIN_TYPE).entity((Object)errorMessage.toString()).build();
        throw new WebApplicationException(r);
    }

    private static Object evaluateFactoryMethod(String value, Class<?> pClass, ParameterType pType, String methodName) {
        try {
            Method m = pClass.getMethod(methodName, String.class);
            if (Modifier.isStatic(m.getModifiers())) {
                return m.invoke(null, value);
            }
        }
        catch (NoSuchMethodException ex) {
        }
        catch (Exception ex) {
            Exception t = ex instanceof InvocationTargetException ? ((InvocationTargetException)ex).getTargetException() : ex;
            LOG.severe(new org.apache.cxf.common.i18n.Message("CLASS_VALUE_OF_FAILURE", BUNDLE, new Object[]{pClass.getName()}).toString());
            throw new WebApplicationException((Throwable)t, HttpUtils.getParameterFailureStatus(pType));
        }
        return null;
    }

    public static Object handleBean(Class<?> paramType, MultivaluedMap<String, String> values, ParameterType pType, Message message) {
        Object bean = null;
        try {
            bean = paramType.newInstance();
        }
        catch (IllegalAccessException ex) {
            InjectionUtils.reportServerError("CLASS_ACCESS_FAILURE", paramType.getName());
        }
        catch (Exception ex) {
            InjectionUtils.reportServerError("CLASS_INSTANTIATION_FAILURE", paramType.getName());
        }
        block3: for (Map.Entry entry : values.entrySet()) {
            Object paramValue;
            boolean injected = false;
            for (Method method : paramType.getMethods()) {
                if (!method.getName().equalsIgnoreCase("set" + (String)entry.getKey()) || method.getParameterTypes().length != 1 || (paramValue = InjectionUtils.handleParameter((String)((List)entry.getValue()).get(0), method.getParameterTypes()[0], pType, message)) == null) continue;
                InjectionUtils.injectThroughMethod(bean, method, paramValue);
                injected = true;
                break;
            }
            if (injected) continue;
            for (AccessibleObject accessibleObject : paramType.getFields()) {
                if (!((Field)accessibleObject).getName().equalsIgnoreCase((String)entry.getKey()) || (paramValue = InjectionUtils.handleParameter((String)((List)entry.getValue()).get(0), ((Field)accessibleObject).getType(), pType, message)) == null) continue;
                InjectionUtils.injectFieldValue((Field)accessibleObject, bean, paramValue);
                continue block3;
            }
        }
        return bean;
    }

    public static Object injectIntoList(Type genericType, List<String> values, boolean decoded, ParameterType pathParam, Message message) {
        Class<?> realType = InjectionUtils.getActualType(genericType);
        values = InjectionUtils.checkPathSegment(values, realType, pathParam);
        ArrayList<Object> theValues = new ArrayList<Object>();
        for (String r : values) {
            String value = InjectionUtils.decodeValue(r, decoded, pathParam);
            Object o = InjectionUtils.handleParameter(value, realType, pathParam, message);
            if (o == null) continue;
            theValues.add(o);
        }
        return theValues;
    }

    public static Object injectIntoSet(Type genericType, List<String> values, boolean sorted, boolean decoded, ParameterType pathParam, Message message) {
        Class<?> realType = InjectionUtils.getActualType(genericType);
        values = InjectionUtils.checkPathSegment(values, realType, pathParam);
        AbstractSet theValues = sorted ? new TreeSet() : new HashSet();
        for (String r : values) {
            String value = InjectionUtils.decodeValue(r, decoded, pathParam);
            Object o = InjectionUtils.handleParameter(value, realType, pathParam, message);
            if (o == null) continue;
            theValues.add(o);
        }
        return theValues;
    }

    private static List<String> checkPathSegment(List<String> values, Class<?> type, ParameterType pathParam) {
        if (pathParam != ParameterType.PATH || !PathSegment.class.isAssignableFrom(type)) {
            return values;
        }
        ArrayList<String> newValues = new ArrayList<String>();
        for (String v : values) {
            String[] segments;
            for (String s : segments = v.split("/")) {
                if (s.length() == 0) continue;
                newValues.add(s);
            }
            if (!v.endsWith("/")) continue;
            newValues.add("");
        }
        return newValues;
    }

    public static Object createParameterObject(List<String> paramValues, Class<?> paramType, Type genericType, String defaultValue, boolean decoded, ParameterType pathParam, Message message) {
        if (paramValues == null) {
            if (defaultValue != null) {
                paramValues = Collections.singletonList(defaultValue);
            } else if (paramType.isPrimitive()) {
                paramValues = Collections.singletonList(Boolean.TYPE == paramType ? "false" : "0");
            } else {
                return null;
            }
        }
        if (List.class.isAssignableFrom(paramType)) {
            return InjectionUtils.injectIntoList(genericType, paramValues, decoded, pathParam, message);
        }
        if (Set.class.isAssignableFrom(paramType)) {
            return InjectionUtils.injectIntoSet(genericType, paramValues, false, decoded, pathParam, message);
        }
        if (SortedSet.class.isAssignableFrom(paramType)) {
            return InjectionUtils.injectIntoSet(genericType, paramValues, true, decoded, pathParam, message);
        }
        String result = null;
        if (paramValues.size() > 0) {
            boolean isLast = pathParam == ParameterType.PATH;
            String string = result = isLast ? paramValues.get(paramValues.size() - 1) : paramValues.get(0);
        }
        if (result != null) {
            result = InjectionUtils.decodeValue(result, decoded, pathParam);
            return InjectionUtils.handleParameter(result, paramType, pathParam, message);
        }
        return null;
    }

    public static ThreadLocalProxy createThreadLocalProxy(Class<?> type) {
        AbstractThreadLocalProxy proxy = null;
        if (UriInfo.class.isAssignableFrom(type)) {
            proxy = new ThreadLocalUriInfo();
        } else if (HttpHeaders.class.isAssignableFrom(type)) {
            proxy = new ThreadLocalHttpHeaders();
        } else if (SecurityContext.class.isAssignableFrom(type)) {
            proxy = new ThreadLocalSecurityContext();
        } else if (ContextResolver.class.isAssignableFrom(type)) {
            proxy = new ThreadLocalContextResolver();
        } else if (Request.class.isAssignableFrom(type)) {
            proxy = new ThreadLocalRequest();
        } else if (Providers.class.isAssignableFrom(type)) {
            proxy = new ThreadLocalProviders();
        } else if (HttpServletRequest.class.isAssignableFrom(type)) {
            proxy = new ThreadLocalHttpServletRequest();
        } else if (ServletContext.class.isAssignableFrom(type)) {
            proxy = new ThreadLocalServletContext();
        } else if (HttpServletResponse.class.isAssignableFrom(type)) {
            proxy = new ThreadLocalHttpServletResponse();
        } else if (MessageContext.class.isAssignableFrom(type)) {
            proxy = new ThreadLocalMessageContext();
        } else if (ServletConfig.class.isAssignableFrom(type)) {
            proxy = new ThreadLocalServletConfig();
        }
        return proxy;
    }

    public static void injectContextProxies(AbstractResourceInfo cri, Object instance) {
        ThreadLocalProxy proxy;
        if (!cri.isSingleton()) {
            return;
        }
        for (Map.Entry<Class<?>, Method> entry : cri.getContextMethods().entrySet()) {
            proxy = cri.getContextSetterProxy(entry.getValue());
            InjectionUtils.injectThroughMethod(instance, entry.getValue(), proxy);
        }
        for (Field f : cri.getContextFields()) {
            proxy = cri.getContextFieldProxy(f);
            InjectionUtils.injectFieldValue(f, instance, proxy);
        }
        for (Field f : cri.getResourceFields()) {
            proxy = cri.getResourceFieldProxy(f);
            InjectionUtils.injectFieldValue(f, instance, proxy);
        }
    }

    public static void injectContextField(AbstractResourceInfo cri, Field f, Object o, Object value, boolean resource) {
        if (!cri.isSingleton()) {
            InjectionUtils.injectFieldValue(f, o, value);
        } else {
            ThreadLocalProxy proxy;
            ThreadLocalProxy threadLocalProxy = proxy = resource ? cri.getResourceFieldProxy(f) : cri.getContextFieldProxy(f);
            if (proxy != null) {
                proxy.set(value);
            }
        }
    }

    public static void injectContextMethods(Object requestObject, AbstractResourceInfo cri, Message message) {
        for (Map.Entry<Class<?>, Method> entry : cri.getContextMethods().entrySet()) {
            Object o = JAXRSUtils.createContextValue(message, entry.getValue().getGenericParameterTypes()[0], entry.getKey());
            if (o == null) continue;
            if (!cri.isSingleton()) {
                InjectionUtils.injectThroughMethod(requestObject, entry.getValue(), o);
                continue;
            }
            ThreadLocalProxy proxy = cri.getContextSetterProxy(entry.getValue());
            if (proxy == null) continue;
            proxy.set(o);
        }
    }

    public static void injectContextFields(Object o, AbstractResourceInfo cri, Message m) {
        for (Field f : cri.getContextFields()) {
            Object value = JAXRSUtils.createContextValue(m, f.getGenericType(), f.getType());
            InjectionUtils.injectContextField(cri, f, o, value, false);
        }
    }

    public static void injectResourceFields(Object o, AbstractResourceInfo cri, Message m) {
        for (Field f : cri.getResourceFields()) {
            Object value = JAXRSUtils.createResourceValue(m, f.getGenericType(), f.getType());
            InjectionUtils.injectContextField(cri, f, o, value, true);
        }
    }

    public static boolean isPrimitive(Class<?> type) {
        return type.isPrimitive() || Number.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || String.class == type;
    }

    private static String decodeValue(String value, boolean decode, ParameterType param) {
        if (!decode) {
            return value;
        }
        if (param == ParameterType.PATH || param == ParameterType.MATRIX) {
            return HttpUtils.pathDecode(value);
        }
        return HttpUtils.urlDecode(value);
    }
}

