/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.aegis.AegisContext;
import org.apache.cxf.aegis.AegisWriter;
import org.apache.cxf.aegis.type.AegisType;
import org.apache.cxf.jaxrs.provider.AegisElementProvider;
import org.apache.cxf.jaxrs.provider.JSONUtils;
import org.apache.cxf.jaxrs.provider.PrefixCollectingXMLStreamWriter;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.codehaus.jettison.mapped.Configuration;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public final class AegisJSONProvider<T>
extends AegisElementProvider<T> {
    private List<String> arrayKeys;
    private boolean serializeAsArray;
    private boolean dropRootElement;
    private boolean ignoreNamespaces;
    private ConcurrentHashMap<String, String> namespaceMap = new ConcurrentHashMap();

    public void setIgnoreNamespaces(boolean ignoreNamespaces) {
        this.ignoreNamespaces = ignoreNamespaces;
    }

    public void setDropRootElement(boolean dropRootElement) {
        this.dropRootElement = dropRootElement;
    }

    public void setArrayKeys(List<String> keys) {
        this.arrayKeys = keys;
    }

    public void setSerializeAsArray(boolean asArray) {
        this.serializeAsArray = asArray;
    }

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return true;
    }

    public void setNamespaceMap(Map<String, String> nsMap) {
        this.namespaceMap = new ConcurrentHashMap<String, String>(nsMap);
    }

    @Override
    public void writeTo(T obj, Class<?> type, Type genericType, Annotation[] anns, MediaType m, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException {
        if (type == null) {
            type = obj.getClass();
        }
        if (genericType == null) {
            genericType = type;
        }
        AegisContext context = this.getAegisContext(type, genericType);
        AegisType aegisType = context.getTypeMapping().getType(genericType);
        AegisWriter aegisWriter = context.createXMLStreamWriter();
        try {
            W3CDOMStreamWriter w3cStreamWriter = new W3CDOMStreamWriter();
            PrefixCollectingXMLStreamWriter spyingWriter = new PrefixCollectingXMLStreamWriter((XMLStreamWriter)w3cStreamWriter, this.namespaceMap);
            spyingWriter.writeStartDocument();
            aegisWriter.write(obj, aegisType.getSchemaType(), false, (Object)spyingWriter, aegisType);
            spyingWriter.writeEndDocument();
            spyingWriter.close();
            Document dom = w3cStreamWriter.getDocument();
            XMLStreamWriter xmlStreamWriter = this.createStreamWriter(aegisType.getSchemaType(), os);
            xmlStreamWriter.writeStartDocument();
            StaxUtils.copy((Document)dom, (XMLStreamWriter)xmlStreamWriter);
            xmlStreamWriter.writeEndDocument();
            xmlStreamWriter.flush();
            xmlStreamWriter.close();
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @Override
    protected XMLStreamWriter createStreamWriter(QName typeQName, OutputStream os) throws Exception {
        Configuration config = JSONUtils.createConfiguration(this.namespaceMap, this.writeXsiType && !this.ignoreNamespaces, false, null);
        XMLStreamWriter writer = JSONUtils.createStreamWriter(os, typeQName, this.writeXsiType && !this.ignoreNamespaces, config, this.serializeAsArray, this.arrayKeys, this.dropRootElement);
        return JSONUtils.createIgnoreNsWriterIfNeeded(writer, this.ignoreNamespaces);
    }

    @Override
    protected XMLStreamReader createStreamReader(AegisType typeToRead, InputStream is) throws Exception {
        if (typeToRead != null) {
            this.namespaceMap.put(typeToRead.getSchemaType().getNamespaceURI(), "ns1");
        }
        return JSONUtils.createStreamReader(is, this.readXsiType, this.namespaceMap);
    }
}

