/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.ContentDisposition;
import org.apache.cxf.jaxrs.ext.multipart.Multipart;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.phase.PhaseInterceptorChain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FormUtils {
    public static final String FORM_PARAM_MAP = "org.apache.cxf.form_data";
    private static final Logger LOG = LogUtils.getL7dLogger(FormUtils.class);
    private static final String MULTIPART_FORM_DATA_TYPE = "form-data";

    private FormUtils() {
    }

    public static void addPropertyToForm(MultivaluedMap<String, String> map, String name, Object value) {
        if (!"".equals(name)) {
            map.add((Object)name, (Object)value.toString());
        } else {
            MultivaluedMap<String, Object> values = InjectionUtils.extractValuesFromBean(value, "");
            for (Map.Entry entry : values.entrySet()) {
                for (Object v : (List)entry.getValue()) {
                    map.add(entry.getKey(), (Object)v.toString());
                }
            }
        }
    }

    public static String readBody(InputStream is, String encoding) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)is, (OutputStream)bos, (int)1024);
            return new String(bos.toByteArray(), encoding);
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex);
        }
    }

    public static void populateMapFromString(MultivaluedMap<String, String> params, String postBody, String enc, boolean decode, HttpServletRequest request) {
        if (!StringUtils.isEmpty((String)postBody)) {
            List<String> parts = Arrays.asList(postBody.split("&"));
            for (String part : parts) {
                String[] keyValue = new String[2];
                int index = part.indexOf("=");
                if (index != -1) {
                    keyValue[0] = part.substring(0, index);
                    keyValue[1] = index + 1 < part.length() ? part.substring(index + 1) : "";
                } else {
                    keyValue[0] = part;
                    keyValue[1] = "";
                }
                String name = HttpUtils.urlDecode(keyValue[0], enc);
                if (decode) {
                    params.add((Object)name, (Object)HttpUtils.urlDecode(keyValue[1], enc));
                    continue;
                }
                params.add((Object)name, (Object)keyValue[1]);
            }
        } else if (request != null) {
            Enumeration en = request.getParameterNames();
            while (en.hasMoreElements()) {
                String paramName = en.nextElement().toString();
                String[] values = request.getParameterValues(paramName);
                params.put((Object)HttpUtils.urlDecode(paramName), Arrays.asList(values));
            }
            FormUtils.logRequestParametersIfNeeded(params, enc);
        }
    }

    public static void logRequestParametersIfNeeded(Map<String, List<String>> params, String enc) {
        String chain = PhaseInterceptorChain.getCurrentMessage().getInterceptorChain().toString();
        if (chain.contains(LoggingInInterceptor.class.getSimpleName())) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                FormUtils.writeMapToOutputStream(params, bos, enc, false);
                LOG.info(bos.toString(enc));
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
    }

    public static void writeMapToOutputStream(Map<String, List<String>> map, OutputStream os, String enc, boolean encoded) throws IOException {
        Iterator<Map.Entry<String, List<String>>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, List<String>> entry = it.next();
            Iterator<String> entryIterator = entry.getValue().iterator();
            while (entryIterator.hasNext()) {
                String value = entryIterator.next();
                os.write(entry.getKey().getBytes(enc));
                os.write(61);
                String data = encoded ? value : HttpUtils.urlEncode(value);
                os.write(data.getBytes(enc));
                if (!entryIterator.hasNext() && !it.hasNext()) continue;
                os.write(38);
            }
        }
    }

    public static void populateMapFromMultipart(MultivaluedMap<String, String> params, Annotation[] anns, MultipartBody body, boolean decode) {
        List<Attachment> atts = body.getAllAttachments();
        for (Attachment a : atts) {
            ContentDisposition cd = a.getContentDisposition();
            if (cd == null || !MULTIPART_FORM_DATA_TYPE.equalsIgnoreCase(cd.getType()) || cd.getParameter("name") == null) {
                Multipart id = AnnotationUtils.getAnnotation(anns, Multipart.class);
                if (id == null || id.required()) {
                    throw new WebApplicationException(400);
                }
                return;
            }
            String name = cd.getParameter("name").replace("\"", "").replace("'", "");
            try {
                String value = IOUtils.toString((InputStream)a.getDataHandler().getInputStream());
                params.add((Object)HttpUtils.urlDecode(name), (Object)(decode ? HttpUtils.urlDecode(value) : value));
            }
            catch (IOException ex) {
                throw new WebApplicationException(415);
            }
        }
    }
}

