/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.apache.cxf.Bus;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.jaxrs.client.ResponseExceptionMapper;
import org.apache.cxf.jaxrs.ext.ParameterHandler;
import org.apache.cxf.jaxrs.ext.RequestHandler;
import org.apache.cxf.jaxrs.ext.ResponseHandler;
import org.apache.cxf.jaxrs.impl.HttpHeadersImpl;
import org.apache.cxf.jaxrs.impl.RequestPreprocessor;
import org.apache.cxf.jaxrs.impl.WebApplicationExceptionMapper;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.model.wadl.WadlGenerator;
import org.apache.cxf.jaxrs.provider.AbstractConfigurableProvider;
import org.apache.cxf.jaxrs.provider.BinaryDataProvider;
import org.apache.cxf.jaxrs.provider.DataSourceProvider;
import org.apache.cxf.jaxrs.provider.FormEncodingProvider;
import org.apache.cxf.jaxrs.provider.MultipartProvider;
import org.apache.cxf.jaxrs.provider.PrimitiveTextProvider;
import org.apache.cxf.jaxrs.provider.SourceProvider;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProviderFactory {
    private static final String ACTIVE_JAXRS_PROVIDER_KEY = "active.jaxrs.provider";
    private static final Logger LOG = LogUtils.getL7dLogger(ProviderFactory.class);
    private static final ProviderFactory SHARED_FACTORY = new ProviderFactory();
    private static final String JAXB_PROVIDER_NAME = "org.apache.cxf.jaxrs.provider.JAXBElementProvider";
    private static final String JSON_PROVIDER_NAME = "org.apache.cxf.jaxrs.provider.JSONProvider";
    private List<ProviderInfo<MessageBodyReader>> messageReaders = new ArrayList<ProviderInfo<MessageBodyReader>>();
    private List<ProviderInfo<MessageBodyWriter>> messageWriters = new ArrayList<ProviderInfo<MessageBodyWriter>>();
    private List<ProviderInfo<ContextResolver>> contextResolvers = new ArrayList<ProviderInfo<ContextResolver>>(1);
    private List<ProviderInfo<ExceptionMapper>> exceptionMappers = new ArrayList<ProviderInfo<ExceptionMapper>>(1);
    private List<ProviderInfo<RequestHandler>> requestHandlers = new ArrayList<ProviderInfo<RequestHandler>>(1);
    private List<ProviderInfo<ResponseHandler>> responseHandlers = new ArrayList<ProviderInfo<ResponseHandler>>(1);
    private List<ProviderInfo<ParameterHandler>> paramHandlers = new ArrayList<ProviderInfo<ParameterHandler>>(1);
    private List<ProviderInfo<ResponseExceptionMapper>> responseExceptionMappers = new ArrayList<ProviderInfo<ResponseExceptionMapper>>(1);
    private RequestPreprocessor requestPreprocessor;
    private ProviderInfo<Application> application;
    private List<ProviderInfo<MessageBodyReader>> jaxbReaders = new ArrayList<ProviderInfo<MessageBodyReader>>();
    private List<ProviderInfo<MessageBodyWriter>> jaxbWriters = new ArrayList<ProviderInfo<MessageBodyWriter>>();

    private ProviderFactory() {
        this.initJaxbProviders();
    }

    private void initJaxbProviders() {
        Object jsonProvider;
        Object jaxbProvider = ProviderFactory.createProvider(JAXB_PROVIDER_NAME);
        if (jaxbProvider != null) {
            this.jaxbReaders.add(new ProviderInfo<MessageBodyReader>((MessageBodyReader)jaxbProvider));
            this.jaxbWriters.add(new ProviderInfo<MessageBodyWriter>((MessageBodyWriter)jaxbProvider));
        }
        if ((jsonProvider = ProviderFactory.createProvider(JSON_PROVIDER_NAME)) != null) {
            this.jaxbReaders.add(new ProviderInfo<MessageBodyReader>((MessageBodyReader)jsonProvider));
            this.jaxbWriters.add(new ProviderInfo<MessageBodyWriter>((MessageBodyWriter)jsonProvider));
        }
        this.injectContextProxies(this.jaxbReaders, this.jaxbWriters);
    }

    private static Object createProvider(String className) {
        try {
            return ClassLoaderUtils.loadClass((String)className, ProviderFactory.class).newInstance();
        }
        catch (Throwable ex) {
            String message = "Problem with creating the default provider " + className;
            message = ex.getMessage() != null ? message + ": " + ex.getMessage() : message + ", exception class : " + ex.getClass().getName();
            LOG.fine(message);
            return null;
        }
    }

    public static ProviderFactory getInstance() {
        return new ProviderFactory();
    }

    public static ProviderFactory getInstance(Message m) {
        Endpoint e = (Endpoint)m.getExchange().get(Endpoint.class);
        return (ProviderFactory)e.get((Object)ProviderFactory.class.getName());
    }

    public static ProviderFactory getSharedInstance() {
        return SHARED_FACTORY;
    }

    public <T> ContextResolver<T> createContextResolver(Type contextType, Message m) {
        Message responseMessage;
        boolean isRequestor = MessageUtils.isRequestor((Message)m);
        Message requestMessage = isRequestor ? m.getExchange().getOutMessage() : m.getExchange().getInMessage();
        HttpHeadersImpl requestHeaders = new HttpHeadersImpl(requestMessage);
        MediaType mt = null;
        Message message = responseMessage = isRequestor ? m.getExchange().getInMessage() : m.getExchange().getOutMessage();
        if (responseMessage != null) {
            Object ctProperty = responseMessage.get((Object)"Content-Type");
            if (ctProperty == null) {
                List accepts = requestHeaders.getAcceptableMediaTypes();
                if (accepts.size() > 0) {
                    mt = (MediaType)accepts.get(0);
                }
            } else {
                mt = JAXRSUtils.toMediaType(ctProperty.toString());
            }
        } else {
            mt = requestHeaders.getMediaType();
        }
        return this.createContextResolver(contextType, m, mt == null ? MediaType.WILDCARD_TYPE : mt);
    }

    public <T> ContextResolver<T> createContextResolver(Type contextType, Message m, MediaType type) {
        Class<?> contextCls = InjectionUtils.getActualType(contextType);
        if (contextCls == null) {
            return null;
        }
        LinkedList candidates = new LinkedList();
        for (ProviderInfo<ContextResolver> cr : this.contextResolvers) {
            Type[] types;
            for (Type t : types = cr.getProvider().getClass().getGenericInterfaces()) {
                List<MediaType> mTypes;
                Class<?> argCls;
                ParameterizedType pt;
                Type[] args;
                if (!(t instanceof ParameterizedType) || (args = (pt = (ParameterizedType)t).getActualTypeArguments()).length <= 0 || (argCls = InjectionUtils.getActualType(args[0])) == null || !argCls.isAssignableFrom(contextCls) || JAXRSUtils.intersectMimeTypes(mTypes = JAXRSUtils.getProduceTypes(cr.getProvider().getClass().getAnnotation(Produces.class)), type).size() <= 0) continue;
                ProviderFactory.injectContextValues(cr, m);
                candidates.add(cr.getProvider());
            }
        }
        if (candidates.size() == 0) {
            return null;
        }
        if (candidates.size() == 1) {
            return (ContextResolver)candidates.get(0);
        }
        Collections.sort(candidates, new ClassComparator());
        return new ContextResolverProxy(candidates);
    }

    public <T extends Throwable> ExceptionMapper<T> createExceptionMapper(Class<?> exceptionType, Message m) {
        ExceptionMapper<T> mapper = this.doCreateExceptionMapper(exceptionType, m);
        if (mapper != null || this == SHARED_FACTORY) {
            return mapper;
        }
        return SHARED_FACTORY.createExceptionMapper(exceptionType, m);
    }

    private <T extends Throwable> ExceptionMapper<T> doCreateExceptionMapper(Class<?> exceptionType, Message m) {
        LinkedList<Object> candidates = new LinkedList<Object>();
        for (ProviderInfo<ExceptionMapper> em : this.exceptionMappers) {
            ProviderFactory.handleMapper(candidates, em, exceptionType, m, ExceptionMapper.class, true);
        }
        if (candidates.size() == 0) {
            return null;
        }
        Collections.sort(candidates, new ExceptionMapperComparator());
        return (ExceptionMapper)candidates.get(0);
    }

    public <T> ParameterHandler<T> createParameterHandler(Class<?> paramType) {
        LinkedList<Object> candidates = new LinkedList<Object>();
        for (ProviderInfo<ParameterHandler> em : this.paramHandlers) {
            ProviderFactory.handleMapper(candidates, em, paramType, null, ParameterHandler.class, true);
        }
        if (candidates.size() == 0) {
            return null;
        }
        Collections.sort(candidates, new ClassComparator());
        return (ParameterHandler)candidates.get(0);
    }

    public <T extends Throwable> ResponseExceptionMapper<T> createResponseExceptionMapper(Class<?> paramType) {
        LinkedList<Object> candidates = new LinkedList<Object>();
        for (ProviderInfo<ResponseExceptionMapper> em : this.responseExceptionMappers) {
            ProviderFactory.handleMapper(candidates, em, paramType, null, ResponseExceptionMapper.class, true);
        }
        if (candidates.size() == 0) {
            return null;
        }
        Collections.sort(candidates, new ClassComparator());
        return (ResponseExceptionMapper)candidates.get(0);
    }

    private static void handleMapper(List<Object> candidates, ProviderInfo em, Class<?> expectedType, Message m, Class<?> providerClass, boolean injectContext) {
        Type[] types;
        Class mapperClass = ClassHelper.getRealClass(em.getProvider());
        for (Type t : types = ProviderFactory.getGenericInterfaces(mapperClass)) {
            if (t instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)t;
                Type[] args = pt.getActualTypeArguments();
                for (int i = 0; i < args.length; ++i) {
                    Type arg = args[i];
                    if (arg instanceof TypeVariable) {
                        TypeVariable var = (TypeVariable)arg;
                        Type[] bounds = var.getBounds();
                        boolean isResolved = false;
                        for (int j = 0; j < bounds.length; ++j) {
                            Class<?> cls = InjectionUtils.getRawType(bounds[j]);
                            if (cls == null || !cls.isAssignableFrom(expectedType)) continue;
                            isResolved = true;
                            break;
                        }
                        if (!isResolved) {
                            return;
                        }
                        if (injectContext) {
                            ProviderFactory.injectContextValues(em, m);
                        }
                        candidates.add(em.getProvider());
                        return;
                    }
                    Class<?> actualClass = InjectionUtils.getRawType(arg);
                    if (actualClass == null) continue;
                    if (expectedType.isArray() && !actualClass.isArray()) {
                        expectedType = expectedType.getComponentType();
                    }
                    if (!actualClass.isAssignableFrom(expectedType)) continue;
                    if (injectContext) {
                        ProviderFactory.injectContextValues(em, m);
                    }
                    candidates.add(em.getProvider());
                    return;
                }
                continue;
            }
            if (!(t instanceof Class) || !((Class)t).isAssignableFrom(providerClass)) continue;
            if (injectContext) {
                ProviderFactory.injectContextValues(em, m);
            }
            candidates.add(em.getProvider());
        }
    }

    public <T> MessageBodyReader<T> createMessageBodyReader(Class<T> bodyType, Type parameterType, Annotation[] parameterAnnotations, MediaType mediaType, Message m) {
        MessageBodyReader<T> mr = this.chooseMessageReader(this.messageReaders, bodyType, parameterType, parameterAnnotations, mediaType, m);
        if (mr == null) {
            mr = this.chooseMessageReader(this.jaxbReaders, bodyType, parameterType, parameterAnnotations, mediaType, m);
        }
        if (mr != null || SHARED_FACTORY == this) {
            return mr;
        }
        return SHARED_FACTORY.createMessageBodyReader(bodyType, parameterType, parameterAnnotations, mediaType, m);
    }

    private boolean isJaxbBasedProvider(Object sharedProvider) {
        String clsName = sharedProvider.getClass().getName();
        return JAXB_PROVIDER_NAME.equals(clsName) || JSON_PROVIDER_NAME.equals(clsName);
    }

    public List<ProviderInfo<RequestHandler>> getRequestHandlers() {
        List<ProviderInfo<RequestHandler>> handlers = null;
        if (this.requestHandlers.size() == 0) {
            handlers = ProviderFactory.SHARED_FACTORY.requestHandlers;
        } else {
            handlers = new ArrayList<ProviderInfo<RequestHandler>>();
            boolean customWADLHandler = false;
            for (int i = 0; i < this.requestHandlers.size(); ++i) {
                if (!(this.requestHandlers.get(i).getProvider() instanceof WadlGenerator)) continue;
                customWADLHandler = true;
                break;
            }
            if (!customWADLHandler) {
                handlers.addAll(ProviderFactory.SHARED_FACTORY.requestHandlers);
            }
            handlers.addAll(this.requestHandlers);
        }
        return Collections.unmodifiableList(handlers);
    }

    public List<ProviderInfo<ResponseHandler>> getResponseHandlers() {
        return Collections.unmodifiableList(this.responseHandlers);
    }

    public <T> MessageBodyWriter<T> createMessageBodyWriter(Class<T> bodyType, Type parameterType, Annotation[] parameterAnnotations, MediaType mediaType, Message m) {
        MessageBodyWriter<T> mw = this.chooseMessageWriter(this.messageWriters, bodyType, parameterType, parameterAnnotations, mediaType, m);
        if (mw == null) {
            mw = this.chooseMessageWriter(this.jaxbWriters, bodyType, parameterType, parameterAnnotations, mediaType, m);
        }
        if (mw != null || SHARED_FACTORY == this) {
            return mw;
        }
        return SHARED_FACTORY.createMessageBodyWriter(bodyType, parameterType, parameterAnnotations, mediaType, m);
    }

    private void setProviders(Object ... providers) {
        for (Object o : providers) {
            if (o == null) continue;
            Class oClass = ClassHelper.getRealClass((Object)o);
            if (MessageBodyReader.class.isAssignableFrom(oClass)) {
                this.messageReaders.add(new ProviderInfo<MessageBodyReader>((MessageBodyReader)o));
            }
            if (MessageBodyWriter.class.isAssignableFrom(oClass)) {
                this.messageWriters.add(new ProviderInfo<MessageBodyWriter>((MessageBodyWriter)o));
            }
            if (ContextResolver.class.isAssignableFrom(oClass)) {
                this.contextResolvers.add(new ProviderInfo<ContextResolver>((ContextResolver)o));
            }
            if (RequestHandler.class.isAssignableFrom(oClass)) {
                this.requestHandlers.add(new ProviderInfo<RequestHandler>((RequestHandler)o));
            }
            if (ResponseHandler.class.isAssignableFrom(oClass)) {
                this.responseHandlers.add(new ProviderInfo<ResponseHandler>((ResponseHandler)o));
            }
            if (ExceptionMapper.class.isAssignableFrom(oClass)) {
                this.exceptionMappers.add(new ProviderInfo<ExceptionMapper>((ExceptionMapper)o));
            }
            if (ResponseExceptionMapper.class.isAssignableFrom(oClass)) {
                this.responseExceptionMappers.add(new ProviderInfo<ResponseExceptionMapper>((ResponseExceptionMapper)o));
            }
            if (!ParameterHandler.class.isAssignableFrom(oClass)) continue;
            this.paramHandlers.add(new ProviderInfo<ParameterHandler>((ParameterHandler)o));
        }
        this.sortReaders();
        this.sortWriters();
        this.sortContextResolvers();
        this.injectContextProxies(this.messageReaders, this.messageWriters, this.contextResolvers, this.requestHandlers, this.responseHandlers, this.exceptionMappers);
    }

    static void injectContextValues(ProviderInfo pi, Message m) {
        if (m != null) {
            InjectionUtils.injectContextFields(pi.getProvider(), pi, m);
            InjectionUtils.injectContextMethods(pi.getProvider(), pi, m);
        }
    }

    void injectContextProxies(List<?> ... providerLists) {
        for (List<?> list : providerLists) {
            for (Object p : list) {
                ProviderInfo pi = (ProviderInfo)p;
                if (SHARED_FACTORY == this && this.isJaxbBasedProvider(pi.getProvider())) continue;
                InjectionUtils.injectContextProxies(pi, pi.getProvider());
            }
        }
    }

    private void sortReaders() {
        Collections.sort(this.messageReaders, new MessageBodyReaderComparator());
    }

    private void sortWriters() {
        Collections.sort(this.messageWriters, new MessageBodyWriterComparator());
    }

    private void sortContextResolvers() {
        Collections.sort(this.contextResolvers, new ContextResolverComparator());
    }

    private <T> MessageBodyReader<T> chooseMessageReader(List<ProviderInfo<MessageBodyReader>> readers, Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, Message m) {
        LinkedList<Object> candidates = new LinkedList<Object>();
        for (ProviderInfo<MessageBodyReader> ep : readers) {
            if (!this.matchesReaderCriterias(ep, type, genericType, annotations, mediaType, m)) continue;
            if (this == SHARED_FACTORY) {
                return ep.getProvider();
            }
            ProviderFactory.handleMapper(candidates, ep, type, m, MessageBodyReader.class, false);
        }
        if (candidates.size() == 0) {
            return null;
        }
        Collections.sort(candidates, new ClassComparator());
        return (MessageBodyReader)candidates.get(0);
    }

    private <T> boolean matchesReaderCriterias(ProviderInfo<MessageBodyReader> pi, Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, Message m) {
        boolean matches;
        MessageBodyReader ep = pi.getProvider();
        List<MediaType> supportedMediaTypes = JAXRSUtils.getProviderConsumeTypes(ep);
        List<MediaType> availableMimeTypes = JAXRSUtils.intersectMimeTypes(Collections.singletonList(mediaType), supportedMediaTypes, false);
        if (availableMimeTypes.size() == 0) {
            return false;
        }
        boolean injected = false;
        if (this != SHARED_FACTORY || !this.isJaxbBasedProvider(ep)) {
            ProviderFactory.injectContextValues(pi, m);
            injected = true;
        }
        if (!(matches = ep.isReadable(type, genericType, annotations, mediaType)) && injected) {
            pi.clearThreadLocalProxies();
        }
        return matches;
    }

    private <T> MessageBodyWriter<T> chooseMessageWriter(List<ProviderInfo<MessageBodyWriter>> writers, Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, Message m) {
        LinkedList<Object> candidates = new LinkedList<Object>();
        for (ProviderInfo<MessageBodyWriter> ep : writers) {
            if (!this.matchesWriterCriterias(ep, type, genericType, annotations, mediaType, m)) continue;
            if (this == SHARED_FACTORY) {
                return ep.getProvider();
            }
            ProviderFactory.handleMapper(candidates, ep, type, m, MessageBodyWriter.class, false);
        }
        if (candidates.size() == 0) {
            return null;
        }
        Collections.sort(candidates, new ClassComparator());
        return (MessageBodyWriter)candidates.get(0);
    }

    private <T> boolean matchesWriterCriterias(ProviderInfo<MessageBodyWriter> pi, Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, Message m) {
        boolean matches;
        MessageBodyWriter ep = pi.getProvider();
        List<MediaType> supportedMediaTypes = JAXRSUtils.getProviderProduceTypes(ep);
        List<MediaType> availableMimeTypes = JAXRSUtils.intersectMimeTypes(Collections.singletonList(mediaType), supportedMediaTypes, false);
        if (availableMimeTypes.size() == 0) {
            return false;
        }
        boolean injected = false;
        if (!(this == SHARED_FACTORY && this.isJaxbBasedProvider(ep) || m.get((Object)ACTIVE_JAXRS_PROVIDER_KEY) == ep)) {
            ProviderFactory.injectContextValues(pi, m);
            injected = true;
        }
        if (!(matches = ep.isWriteable(type, genericType, annotations, mediaType)) && injected) {
            pi.clearThreadLocalProxies();
        }
        return matches;
    }

    List<ProviderInfo<MessageBodyReader>> getMessageReaders() {
        return Collections.unmodifiableList(this.messageReaders);
    }

    List<ProviderInfo<MessageBodyWriter>> getMessageWriters() {
        return Collections.unmodifiableList(this.messageWriters);
    }

    List<ProviderInfo<ContextResolver>> getContextResolvers() {
        return Collections.unmodifiableList(this.contextResolvers);
    }

    public void registerUserProvider(Object provider) {
        this.setUserProviders(Collections.singletonList(provider));
    }

    public void setUserProviders(List<?> userProviders) {
        this.setProviders(userProviders.toArray());
    }

    public void setApplicationProvider(ProviderInfo<Application> app) {
        this.application = app;
    }

    public void setRequestPreprocessor(RequestPreprocessor rp) {
        this.requestPreprocessor = rp;
    }

    public RequestPreprocessor getRequestPreprocessor() {
        return this.requestPreprocessor;
    }

    public void clearThreadLocalProxies() {
        this.clearProxies(this.messageReaders, this.messageWriters, this.jaxbReaders, this.jaxbWriters, this.contextResolvers, this.requestHandlers, this.responseHandlers, this.exceptionMappers);
        if (this.application != null) {
            this.application.clearThreadLocalProxies();
        }
        if (this != SHARED_FACTORY) {
            SHARED_FACTORY.clearThreadLocalProxies();
        }
    }

    void clearProxies(List<?> ... lists) {
        for (List<?> list : lists) {
            for (Object p : list) {
                ProviderInfo pi = (ProviderInfo)p;
                pi.clearThreadLocalProxies();
            }
        }
    }

    void clearProviders() {
        this.messageReaders.clear();
        this.messageWriters.clear();
        this.contextResolvers.clear();
        this.exceptionMappers.clear();
        this.requestHandlers.clear();
        this.responseHandlers.clear();
        this.paramHandlers.clear();
        this.responseExceptionMappers.clear();
    }

    public void setBus(Bus bus) {
        if (bus == null) {
            return;
        }
        for (ProviderInfo<MessageBodyReader> r : this.messageReaders) {
            this.injectProviderProperty(r.getProvider(), "setBus", Bus.class, bus);
        }
    }

    private boolean injectProviderProperty(Object provider, String mName, Class<?> pClass, Object pValue) {
        try {
            Method m = provider.getClass().getMethod(mName, pClass);
            m.invoke(provider, pValue);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void setSchemaLocations(List<String> schemas) {
        boolean schemasMethodAvailable = false;
        for (ProviderInfo<MessageBodyReader> r : this.messageReaders) {
            schemasMethodAvailable = this.injectProviderProperty(r.getProvider(), "setSchemas", List.class, schemas);
        }
        if (!schemasMethodAvailable) {
            for (ProviderInfo<MessageBodyReader> r : this.jaxbReaders) {
                schemasMethodAvailable = this.injectProviderProperty(r.getProvider(), "setSchemas", List.class, schemas);
            }
        }
    }

    public void initProviders(List<ClassResourceInfo> cris) {
        Set<Object> set = this.getReadersWriters();
        for (Object o : set) {
            Object provider = ((ProviderInfo)o).getProvider();
            if (!(provider instanceof AbstractConfigurableProvider)) continue;
            ((AbstractConfigurableProvider)provider).init(cris);
        }
        if (this != SHARED_FACTORY) {
            SHARED_FACTORY.initProviders(cris);
        }
    }

    Set<Object> getReadersWriters() {
        HashSet<Object> set = new HashSet<Object>();
        set.addAll(this.messageReaders);
        set.addAll(this.jaxbReaders);
        set.addAll(this.messageWriters);
        set.addAll(this.jaxbWriters);
        return set;
    }

    private static int compareClasses(Object o1, Object o2) {
        Class<?> realClass2;
        Class cl1 = ClassHelper.getRealClass((Object)o1);
        Class cl2 = ClassHelper.getRealClass((Object)o2);
        Type[] types1 = ProviderFactory.getGenericInterfaces(cl1);
        Type[] types2 = ProviderFactory.getGenericInterfaces(cl2);
        if (types1.length == 0 && types2.length > 0) {
            return 1;
        }
        if (types1.length > 0 && types2.length == 0) {
            return -1;
        }
        Class<?> realClass1 = InjectionUtils.getActualType(types1[0]);
        if (realClass1 == (realClass2 = InjectionUtils.getActualType(types2[0]))) {
            return 0;
        }
        if (realClass1.isAssignableFrom(realClass2)) {
            return 1;
        }
        return -1;
    }

    private static Type[] getGenericInterfaces(Class<?> cls) {
        if (Object.class == cls) {
            return new Type[0];
        }
        Type genericSuperCls = cls.getGenericSuperclass();
        if (genericSuperCls instanceof ParameterizedType) {
            return new Type[]{genericSuperCls};
        }
        Type[] types = cls.getGenericInterfaces();
        if (types.length > 0) {
            return types;
        }
        return ProviderFactory.getGenericInterfaces(cls.getSuperclass());
    }

    static {
        SHARED_FACTORY.setProviders(new BinaryDataProvider(), new SourceProvider(), new FormEncodingProvider(), new PrimitiveTextProvider(), new DataSourceProvider(), new MultipartProvider(), new WebApplicationExceptionMapper(), new WadlGenerator());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ContextResolverProxy<T>
    implements ContextResolver<T> {
        private List<ContextResolver<T>> candidates;

        public ContextResolverProxy(List<ContextResolver<T>> candidates) {
            this.candidates = candidates;
        }

        public T getContext(Class<?> cls) {
            for (ContextResolver<T> resolver : this.candidates) {
                Object context = resolver.getContext(cls);
                if (context == null) continue;
                return (T)context;
            }
            return null;
        }

        public List<ContextResolver<T>> getResolvers() {
            return this.candidates;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassComparator
    implements Comparator<Object> {
        private ClassComparator() {
        }

        @Override
        public int compare(Object em1, Object em2) {
            return ProviderFactory.compareClasses(em1, em2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExceptionMapperComparator
    implements Comparator<ExceptionMapper<? extends Throwable>> {
        private ExceptionMapperComparator() {
        }

        @Override
        public int compare(ExceptionMapper<? extends Throwable> em1, ExceptionMapper<? extends Throwable> em2) {
            return ProviderFactory.compareClasses(em1, em2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ContextResolverComparator
    implements Comparator<ProviderInfo<ContextResolver>> {
        private ContextResolverComparator() {
        }

        @Override
        public int compare(ProviderInfo<ContextResolver> p1, ProviderInfo<ContextResolver> p2) {
            ContextResolver e1 = p1.getProvider();
            ContextResolver e2 = p2.getProvider();
            List<MediaType> types1 = JAXRSUtils.sortMediaTypes(JAXRSUtils.getProduceTypes(e1.getClass().getAnnotation(Produces.class)));
            List<MediaType> types2 = JAXRSUtils.sortMediaTypes(JAXRSUtils.getProduceTypes(e2.getClass().getAnnotation(Produces.class)));
            return JAXRSUtils.compareSortedMediaTypes(types1, types2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MessageBodyWriterComparator
    implements Comparator<ProviderInfo<MessageBodyWriter>> {
        private MessageBodyWriterComparator() {
        }

        @Override
        public int compare(ProviderInfo<MessageBodyWriter> p1, ProviderInfo<MessageBodyWriter> p2) {
            MessageBodyWriter e1 = p1.getProvider();
            MessageBodyWriter e2 = p2.getProvider();
            List<MediaType> types1 = JAXRSUtils.sortMediaTypes(JAXRSUtils.getProviderProduceTypes(e1));
            List<MediaType> types2 = JAXRSUtils.sortMediaTypes(JAXRSUtils.getProviderProduceTypes(e2));
            return JAXRSUtils.compareSortedMediaTypes(types1, types2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MessageBodyReaderComparator
    implements Comparator<ProviderInfo<MessageBodyReader>> {
        private MessageBodyReaderComparator() {
        }

        @Override
        public int compare(ProviderInfo<MessageBodyReader> p1, ProviderInfo<MessageBodyReader> p2) {
            MessageBodyReader e1 = p1.getProvider();
            MessageBodyReader e2 = p2.getProvider();
            List<MediaType> types1 = JAXRSUtils.getProviderConsumeTypes(e1);
            types1 = JAXRSUtils.sortMediaTypes(types1);
            List<MediaType> types2 = JAXRSUtils.getProviderConsumeTypes(e2);
            types2 = JAXRSUtils.sortMediaTypes(types2);
            return JAXRSUtils.compareSortedMediaTypes(types1, types2);
        }
    }
}

