/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client;

import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.client.ClientState;
import org.apache.cxf.jaxrs.impl.MetadataMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalClientState
implements ClientState {
    private static final String HTTP_SCHEME = "http";
    private MultivaluedMap<String, String> requestHeaders = new MetadataMap<String, String>(false, true);
    private MultivaluedMap<String, String> templates;
    private Response.ResponseBuilder responseBuilder;
    private URI baseURI;
    private UriBuilder currentBuilder;

    public LocalClientState() {
    }

    public LocalClientState(URI baseURI) {
        this.baseURI = baseURI;
        this.currentBuilder = LocalClientState.isHttpScheme(baseURI) ? UriBuilder.fromUri((URI)baseURI) : UriBuilder.fromUri((String)"/");
    }

    public LocalClientState(URI baseURI, URI currentURI) {
        this.baseURI = baseURI;
        this.currentBuilder = UriBuilder.fromUri((URI)currentURI);
    }

    public LocalClientState(LocalClientState cs) {
        this.requestHeaders = new MetadataMap<String, String>((Map<String, List<String>>)cs.requestHeaders);
        this.templates = cs.templates == null ? null : new MetadataMap(cs.templates);
        this.responseBuilder = cs.responseBuilder != null ? cs.responseBuilder.clone() : null;
        this.baseURI = cs.baseURI;
        this.currentBuilder = cs.currentBuilder != null ? cs.currentBuilder.clone() : null;
    }

    @Override
    public void setCurrentBuilder(UriBuilder currentBuilder) {
        this.currentBuilder = currentBuilder;
    }

    @Override
    public UriBuilder getCurrentBuilder() {
        return this.currentBuilder;
    }

    @Override
    public void setBaseURI(URI baseURI) {
        this.baseURI = baseURI;
    }

    @Override
    public URI getBaseURI() {
        return this.baseURI;
    }

    @Override
    public void setResponseBuilder(Response.ResponseBuilder responseBuilder) {
        this.responseBuilder = responseBuilder;
    }

    @Override
    public Response.ResponseBuilder getResponseBuilder() {
        return this.responseBuilder;
    }

    @Override
    public void setRequestHeaders(MultivaluedMap<String, String> requestHeaders) {
        this.requestHeaders = requestHeaders;
    }

    @Override
    public MultivaluedMap<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    @Override
    public MultivaluedMap<String, String> getTemplates() {
        return this.templates;
    }

    @Override
    public void setTemplates(MultivaluedMap<String, String> map) {
        if (this.templates == null) {
            this.templates = map;
        } else if (map != null) {
            this.templates.putAll(map);
        } else {
            this.templates = null;
        }
    }

    @Override
    public void reset() {
        this.requestHeaders.clear();
        this.responseBuilder = null;
        this.currentBuilder = UriBuilder.fromUri((URI)this.baseURI);
        this.templates = null;
    }

    @Override
    public ClientState newState(URI currentURI, MultivaluedMap<String, String> headers, MultivaluedMap<String, String> templatesMap) {
        MultivaluedMap<String, String> newTemplateParams;
        LocalClientState state = null;
        state = LocalClientState.isHttpScheme(currentURI) ? new LocalClientState(currentURI) : new LocalClientState(this.baseURI, currentURI);
        if (headers != null) {
            state.setRequestHeaders(headers);
        }
        if ((newTemplateParams = this.templates) != null && templatesMap != null) {
            newTemplateParams.putAll(templatesMap);
        } else {
            newTemplateParams = templatesMap;
        }
        state.setTemplates(newTemplateParams);
        return state;
    }

    private static boolean isHttpScheme(URI uri) {
        return !StringUtils.isEmpty((String)uri.getScheme()) && uri.getScheme().startsWith(HTTP_SCHEME);
    }
}

