/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.model.BeanResourceInfo;
import org.apache.cxf.jaxrs.model.MethodDispatcher;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.SubresourceKey;
import org.apache.cxf.jaxrs.model.URITemplate;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;

public class ClassResourceInfo
extends BeanResourceInfo {
    private URITemplate uriTemplate;
    private MethodDispatcher methodDispatcher;
    private ResourceProvider resourceProvider;
    private ConcurrentHashMap<SubresourceKey, ClassResourceInfo> subResources = new ConcurrentHashMap();
    private boolean enableStatic;
    private boolean createdFromModel;
    private String consumesTypes;
    private String producesTypes;
    private List<String> nameBindings = Collections.emptyList();
    private ClassResourceInfo parent;

    public ClassResourceInfo(ClassResourceInfo cri) {
        super(cri.getBus());
        if (!cri.isCreatedFromModel() || InjectionUtils.isConcreteClass(cri.getServiceClass())) {
            throw new IllegalArgumentException();
        }
        this.root = cri.root;
        this.serviceClass = cri.serviceClass;
        this.uriTemplate = cri.uriTemplate;
        this.methodDispatcher = new MethodDispatcher(cri.methodDispatcher, this);
        this.subResources = cri.subResources;
        this.paramFields = cri.paramFields;
        this.paramMethods = cri.paramMethods;
        this.enableStatic = true;
        this.nameBindings = cri.nameBindings;
        this.parent = cri.parent;
    }

    public ClassResourceInfo(Class<?> theResourceClass, Class<?> theServiceClass, boolean theRoot, boolean enableStatic, Bus bus) {
        super(theResourceClass, theServiceClass, theRoot, bus);
        this.enableStatic = enableStatic;
        if (this.root && this.resourceClass != null) {
            this.nameBindings = AnnotationUtils.getNameBindings(this.serviceClass.getAnnotations());
        }
    }

    public ClassResourceInfo(Class<?> theResourceClass, Class<?> theServiceClass, boolean theRoot, boolean enableStatic, boolean createdFromModel, Bus bus) {
        this(theResourceClass, theServiceClass, theRoot, enableStatic, bus);
        this.createdFromModel = createdFromModel;
    }

    public ClassResourceInfo(Class<?> theResourceClass, Class<?> c, boolean theRoot, boolean enableStatic, boolean createdFromModel, String consumesTypes, String producesTypes, Bus bus) {
        this(theResourceClass, theResourceClass, theRoot, enableStatic, createdFromModel, bus);
        this.consumesTypes = consumesTypes;
        this.producesTypes = producesTypes;
    }

    public ClassResourceInfo(Class<?> theResourceClass) {
        this(theResourceClass, true);
    }

    public ClassResourceInfo(Class<?> theResourceClass, boolean theRoot) {
        this(theResourceClass, theResourceClass, theRoot);
    }

    public ClassResourceInfo(Class<?> theResourceClass, Class<?> theServiceClass) {
        this(theResourceClass, theServiceClass, false);
    }

    public ClassResourceInfo(Class<?> theResourceClass, Class<?> theServiceClass, boolean theRoot) {
        this(theResourceClass, theServiceClass, theRoot, false, BusFactory.getDefaultBus((boolean)true));
    }

    public ClassResourceInfo findResource(Class<?> typedClass, Class<?> instanceClass) {
        instanceClass = this.enableStatic ? typedClass : instanceClass;
        SubresourceKey key = new SubresourceKey(typedClass, instanceClass);
        return this.subResources.get(key);
    }

    public ClassResourceInfo getSubResource(Class<?> typedClass, Class<?> instanceClass) {
        ClassResourceInfo tmpCri;
        instanceClass = this.enableStatic ? typedClass : instanceClass;
        SubresourceKey key = new SubresourceKey(typedClass, instanceClass);
        ClassResourceInfo cri = this.subResources.get(key);
        if (cri == null && !this.enableStatic && (cri = ResourceUtils.createClassResourceInfo(typedClass, instanceClass, false, this.enableStatic, this.getBus())) != null && (tmpCri = this.subResources.putIfAbsent(key, cri)) != null && (cri = tmpCri) != this) {
            cri.setParent(this);
        }
        return cri;
    }

    public void addSubClassResourceInfo(ClassResourceInfo cri) {
        this.subResources.putIfAbsent(new SubresourceKey(cri.getResourceClass(), cri.getServiceClass()), cri);
        if (cri != this) {
            cri.setParent(this);
        }
    }

    public Collection<ClassResourceInfo> getSubResources() {
        return Collections.unmodifiableCollection(this.subResources.values());
    }

    public List<String> getNameBindings() {
        if (this.root || this.parent == null) {
            return this.nameBindings;
        }
        return this.parent.nameBindings;
    }

    public void setNameBindings(List<String> names) {
        this.nameBindings = names;
    }

    public Set<String> getAllowedMethods() {
        HashSet<String> methods = new HashSet<String>();
        for (OperationResourceInfo o : this.methodDispatcher.getOperationResourceInfos()) {
            String method = o.getHttpMethod();
            if (method == null) continue;
            methods.add(method);
        }
        return methods;
    }

    public URITemplate getURITemplate() {
        return this.uriTemplate;
    }

    public void setURITemplate(URITemplate u) {
        this.uriTemplate = u;
    }

    public MethodDispatcher getMethodDispatcher() {
        return this.methodDispatcher;
    }

    public void setMethodDispatcher(MethodDispatcher md) {
        this.methodDispatcher = md;
    }

    public boolean hasSubResources() {
        return !this.subResources.isEmpty();
    }

    public boolean isCreatedFromModel() {
        return this.createdFromModel;
    }

    public ResourceProvider getResourceProvider() {
        return this.resourceProvider;
    }

    public void setResourceProvider(ResourceProvider rp) {
        this.resourceProvider = rp;
    }

    public List<MediaType> getProduceMime() {
        if (this.root || this.parent == null) {
            if (this.producesTypes != null) {
                return JAXRSUtils.parseMediaTypes(this.producesTypes);
            }
            return JAXRSUtils.getProduceTypes(AnnotationUtils.getClassAnnotation(this.getServiceClass(), Produces.class));
        }
        return this.parent.getProduceMime();
    }

    public List<MediaType> getConsumeMime() {
        if (this.root || this.parent == null) {
            if (this.consumesTypes != null) {
                return JAXRSUtils.parseMediaTypes(this.consumesTypes);
            }
            return JAXRSUtils.getConsumeTypes(AnnotationUtils.getClassAnnotation(this.getServiceClass(), Consumes.class));
        }
        return this.parent.getConsumeMime();
    }

    public Path getPath() {
        return AnnotationUtils.getClassAnnotation(this.getServiceClass(), Path.class);
    }

    @Override
    public boolean isSingleton() {
        return this.resourceProvider != null && this.resourceProvider.isSingleton();
    }

    void setParent(ClassResourceInfo parent) {
        this.parent = parent;
    }
}

