/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import javax.ws.rs.core.NewCookie;
import javax.ws.rs.ext.RuntimeDelegate;
import org.apache.cxf.common.util.StringUtils;

public class NewCookieHeaderProvider
implements RuntimeDelegate.HeaderDelegate<NewCookie> {
    private static final String VERSION = "Version";
    private static final String PATH = "Path";
    private static final String DOMAIN = "Domain";
    private static final String MAX_AGE = "Max-Age";
    private static final String COMMENT = "Comment";
    private static final String SECURE = "Secure";
    private static final String EXPIRES = "Expires";

    public NewCookie fromString(String c) {
        String[] tokens;
        if (c == null) {
            throw new IllegalArgumentException("SetCookie value can not be null");
        }
        String name = null;
        String value = null;
        String path = null;
        String domain = null;
        String comment = null;
        int maxAge = -1;
        boolean isSecure = false;
        for (String token : tokens = StringUtils.split((String)c, (String)";")) {
            String paramValue;
            String theToken = token.trim();
            int sepIndex = theToken.indexOf(61);
            String paramName = sepIndex != -1 ? theToken.substring(0, sepIndex) : theToken;
            String string = paramValue = sepIndex == theToken.length() + 1 ? null : theToken.substring(sepIndex + 1);
            if (paramName.equalsIgnoreCase(MAX_AGE)) {
                maxAge = Integer.parseInt(paramValue);
                continue;
            }
            if (paramName.equalsIgnoreCase(PATH)) {
                path = paramValue;
                continue;
            }
            if (paramName.equalsIgnoreCase(DOMAIN)) {
                domain = paramValue;
                continue;
            }
            if (paramName.equalsIgnoreCase(COMMENT)) {
                comment = paramValue;
                continue;
            }
            if (paramName.equalsIgnoreCase(SECURE)) {
                isSecure = true;
                continue;
            }
            if (paramName.equalsIgnoreCase(EXPIRES) || paramName.equalsIgnoreCase(VERSION)) continue;
            name = paramName;
            value = paramValue;
        }
        if (name == null || value == null) {
            throw new IllegalArgumentException("Set-Cookie is malformed : " + c);
        }
        return new NewCookie(name, value, path, domain, comment, maxAge, isSecure);
    }

    public String toString(NewCookie value) {
        StringBuilder sb = new StringBuilder();
        sb.append(value.getName()).append('=').append(value.getValue());
        if (value.getComment() != null) {
            sb.append(';').append(COMMENT).append('=').append(value.getComment());
        }
        if (value.getDomain() != null) {
            sb.append(';').append(DOMAIN).append('=').append(value.getDomain());
        }
        if (value.getMaxAge() != -1) {
            sb.append(';').append(MAX_AGE).append('=').append(value.getMaxAge());
        }
        if (value.getPath() != null) {
            sb.append(';').append(PATH).append('=').append(value.getPath());
        }
        if (value.isSecure()) {
            sb.append(';').append(SECURE);
        }
        sb.append(';').append(VERSION).append('=').append(value.getVersion());
        return sb.toString();
    }
}

