/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.interceptor;

import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.core.Response;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.AbstractOutDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.provider.ServerProviderFactory;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.logging.FaultListener;
import org.apache.cxf.logging.NoOpFaultListener;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.phase.PhaseManager;

public class JAXRSOutExceptionMapperInterceptor
extends AbstractOutDatabindingInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(JAXRSOutExceptionMapperInterceptor.class);

    public JAXRSOutExceptionMapperInterceptor() {
        super("setup");
    }

    public JAXRSOutExceptionMapperInterceptor(String phase) {
        super(phase);
    }

    public void handleFault(Message message) {
        Response r;
        if (Boolean.TRUE == message.get((Object)"jaxrs.out.fault")) {
            return;
        }
        Throwable ex = (Throwable)message.getContent(Exception.class);
        if (ex instanceof Fault) {
            ex = ((Fault)ex).getCause();
        }
        if ((r = JAXRSUtils.convertFaultToResponse(ex, message)) != null) {
            message.removeContent(Exception.class);
            message.getInterceptorChain().setFaultObserver(null);
            message.setContent(List.class, (Object)new MessageContentsList(new Object[]{r}));
            if (message.getContextualProperty(FaultListener.class.getName()) == null) {
                message.put((Object)FaultListener.class.getName(), (Object)new NoOpFaultListener());
            }
            PhaseManager pm = (PhaseManager)((Bus)message.getExchange().get(Bus.class)).getExtension(PhaseManager.class);
            PhaseInterceptorChain chain = new PhaseInterceptorChain(pm.getOutPhases());
            boolean jaxrsOutOrAfter = false;
            for (Interceptor outInterceptor : message.getInterceptorChain()) {
                if (outInterceptor.getClass() == JAXRSOutInterceptor.class) {
                    jaxrsOutOrAfter = true;
                }
                if (!jaxrsOutOrAfter) continue;
                chain.add(outInterceptor);
            }
            message.setInterceptorChain((InterceptorChain)chain);
            message.getInterceptorChain().doInterceptStartingAt(message, JAXRSOutInterceptor.class.getName());
            return;
        }
        LOG.fine("Cleanup thread local variables");
        Object rootInstance = message.getExchange().remove((Object)"service.root.instance");
        Object rootProvider = message.getExchange().remove((Object)"service.root.provider");
        if (rootInstance != null && rootProvider != null) {
            try {
                ((ResourceProvider)rootProvider).releaseInstance(message, rootInstance);
            }
            catch (Throwable tex) {
                LOG.warning("Exception occurred during releasing the service instance, " + tex.getMessage());
            }
        }
        ServerProviderFactory.getInstance(message).clearThreadLocalProxies();
        ClassResourceInfo cri = (ClassResourceInfo)message.getExchange().get((Object)"root.resource.class");
        if (cri != null) {
            cri.clearThreadLocalProxies();
        }
    }

    public void handleMessage(Message message) throws Fault {
    }
}

