/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.validation;

import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.message.Message;

public final class ValidationUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(ValidationUtils.class);

    private ValidationUtils() {
    }

    public static Object getResourceInstance(Message message) {
        OperationResourceInfo ori = (OperationResourceInfo)message.getExchange().get(OperationResourceInfo.class);
        ResourceProvider resourceProvider = ori.getClassResourceInfo().getResourceProvider();
        if (!resourceProvider.isSingleton()) {
            String error = "Service object is not a singleton, use a custom invoker to validate";
            LOG.warning(error);
            return null;
        }
        return resourceProvider.getInstance(message);
    }
}

