/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.jaxrs.impl.ConfigurableImpl;
import org.apache.cxf.jaxrs.impl.RequestPreprocessor;
import org.apache.cxf.jaxrs.impl.ResourceInfoImpl;
import org.apache.cxf.jaxrs.impl.WebApplicationExceptionMapper;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.model.BeanParamInfo;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.FilterProviderInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.message.Message;

public final class ServerProviderFactory
extends ProviderFactory {
    private static final String SHARED_SERVER_FACTORY = "jaxrs.shared.server.factory";
    private static final Set<Class<?>> SERVER_FILTER_INTERCEPTOR_CLASSES = new HashSet<Class>(Arrays.asList(ContainerRequestFilter.class, ContainerResponseFilter.class, ReaderInterceptor.class, WriterInterceptor.class));
    private static final String WADL_PROVIDER_NAME = "org.apache.cxf.jaxrs.model.wadl.WadlGenerator";
    private List<ProviderInfo<ExceptionMapper<?>>> exceptionMappers = new ArrayList(1);
    private List<ProviderInfo<ContainerRequestFilter>> preMatchContainerRequestFilters = new ArrayList<ProviderInfo<ContainerRequestFilter>>(1);
    private Map<ProviderFactory.NameKey, ProviderInfo<ContainerRequestFilter>> postMatchContainerRequestFilters = new ProviderFactory.NameKeyMap<ProviderInfo<ContainerRequestFilter>>(true);
    private Map<ProviderFactory.NameKey, ProviderInfo<ContainerResponseFilter>> postMatchContainerResponseFilters = new ProviderFactory.NameKeyMap<ProviderInfo<ContainerResponseFilter>>(false);
    private RequestPreprocessor requestPreprocessor;
    private ProviderInfo<Application> application;
    private Set<DynamicFeature> dynamicFeatures = new LinkedHashSet<DynamicFeature>();
    private Map<Class<?>, BeanParamInfo> beanParams = new HashMap();
    private ProviderInfo<ContainerRequestFilter> wadlGenerator;

    private ServerProviderFactory(ProviderFactory baseFactory, Bus bus) {
        super(baseFactory, bus);
        if (baseFactory == null) {
            this.wadlGenerator = ServerProviderFactory.createWadlGenerator(bus);
        }
    }

    private static ProviderInfo<ContainerRequestFilter> createWadlGenerator(Bus bus) {
        Object provider = ServerProviderFactory.createProvider(WADL_PROVIDER_NAME);
        if (provider == null) {
            return null;
        }
        return new ProviderInfo<ContainerRequestFilter>((ContainerRequestFilter)provider, bus);
    }

    public static ServerProviderFactory getInstance() {
        return ServerProviderFactory.createInstance(null);
    }

    public static ServerProviderFactory createInstance(Bus bus) {
        if (bus == null) {
            bus = BusFactory.getThreadDefaultBus();
        }
        ServerProviderFactory baseFactory = ServerProviderFactory.initBaseFactory(bus);
        ServerProviderFactory factory = new ServerProviderFactory(baseFactory, bus);
        factory.setBusProviders();
        return factory;
    }

    public static ServerProviderFactory getInstance(Message m) {
        Endpoint e = (Endpoint)m.getExchange().get(Endpoint.class);
        return (ServerProviderFactory)e.get((Object)"org.apache.cxf.jaxrs.provider.ServerProviderFactory");
    }

    private static synchronized ServerProviderFactory initBaseFactory(Bus bus) {
        ServerProviderFactory factory = (ServerProviderFactory)bus.getProperty(SHARED_SERVER_FACTORY);
        if (factory != null) {
            return factory;
        }
        factory = new ServerProviderFactory(null, bus);
        ProviderFactory.initBaseFactory(factory);
        factory.setProviders(new WebApplicationExceptionMapper());
        bus.setProperty(SHARED_SERVER_FACTORY, (Object)factory);
        return factory;
    }

    public List<ProviderInfo<ContainerRequestFilter>> getPreMatchContainerRequestFilters() {
        return this.getContainerRequestFilters(this.preMatchContainerRequestFilters, true);
    }

    public List<ProviderInfo<ContainerRequestFilter>> getPostMatchContainerRequestFilters(Set<String> names) {
        return ServerProviderFactory.getBoundFilters(this.postMatchContainerRequestFilters, names);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ProviderInfo<ContainerRequestFilter>> getContainerRequestFilters(List<ProviderInfo<ContainerRequestFilter>> filters, boolean syncNeeded) {
        ProviderInfo<ContainerRequestFilter> generator;
        ProviderInfo<ContainerRequestFilter> providerInfo = generator = this.wadlGenerator != null ? this.wadlGenerator : ((ServerProviderFactory)this.getBaseFactory()).wadlGenerator;
        if (generator == null) {
            return filters;
        }
        if (filters.size() == 0) {
            return Collections.singletonList(generator);
        }
        if (!syncNeeded) {
            filters.add(0, generator);
            return filters;
        }
        List<ProviderInfo<ContainerRequestFilter>> list = filters;
        synchronized (list) {
            if (filters.get(0) != generator) {
                filters.add(0, generator);
            }
        }
        return filters;
    }

    public List<ProviderInfo<ContainerResponseFilter>> getContainerResponseFilters(Set<String> names) {
        return ServerProviderFactory.getBoundFilters(this.postMatchContainerResponseFilters, names);
    }

    public void addBeanParamInfo(BeanParamInfo bpi) {
        this.beanParams.put(bpi.getResourceClass(), bpi);
    }

    public BeanParamInfo getBeanParamInfo(Class<?> beanClass) {
        return this.beanParams.get(beanClass);
    }

    public <T extends Throwable> ExceptionMapper<T> createExceptionMapper(Class<?> exceptionType, Message m) {
        ExceptionMapper<T> mapper = this.doCreateExceptionMapper(exceptionType, m);
        if (mapper != null || this.isBaseFactory()) {
            return mapper;
        }
        return ((ServerProviderFactory)this.getBaseFactory()).createExceptionMapper(exceptionType, m);
    }

    private <T extends Throwable> ExceptionMapper<T> doCreateExceptionMapper(Class<?> exceptionType, Message m) {
        LinkedList candidates = new LinkedList();
        for (ProviderInfo<ExceptionMapper<?>> em : this.exceptionMappers) {
            this.handleMapper(candidates, em, exceptionType, m, ExceptionMapper.class, true);
        }
        if (candidates.size() == 0) {
            return null;
        }
        Collections.sort(candidates, new ProviderFactory.ClassComparator(exceptionType));
        return (ExceptionMapper)candidates.get(0);
    }

    @Override
    protected void setProviders(Object ... providers) {
        LinkedList<ProviderInfo<ContainerRequestFilter>> postMatchRequestFilters = new LinkedList<ProviderInfo<ContainerRequestFilter>>();
        LinkedList postMatchResponseFilters = new LinkedList();
        List<ProviderInfo<? extends Object>> theProviders = this.prepareProviders(providers, this.application);
        super.setCommonProviders(theProviders);
        for (ProviderInfo<? extends Object> provider : theProviders) {
            Class providerCls;
            if (ServerProviderFactory.filterContractSupported(provider, providerCls = ClassHelper.getRealClass((Object)provider.getProvider()), ContainerRequestFilter.class)) {
                this.addContainerRequestFilter(postMatchRequestFilters, provider);
            }
            if (ServerProviderFactory.filterContractSupported(provider, providerCls, ContainerResponseFilter.class)) {
                postMatchResponseFilters.add(provider);
            }
            if (DynamicFeature.class.isAssignableFrom(providerCls)) {
                Object feature = provider.getProvider();
                this.dynamicFeatures.add((DynamicFeature)feature);
            }
            if (!ExceptionMapper.class.isAssignableFrom(providerCls)) continue;
            this.addProviderToList(this.exceptionMappers, provider);
        }
        Collections.sort(this.preMatchContainerRequestFilters, new ProviderFactory.BindingPriorityComparator(ContainerRequestFilter.class, true));
        ServerProviderFactory.mapInterceptorFilters(this.postMatchContainerRequestFilters, postMatchRequestFilters, ContainerRequestFilter.class, true);
        ServerProviderFactory.mapInterceptorFilters(this.postMatchContainerResponseFilters, postMatchResponseFilters, ContainerResponseFilter.class, false);
        this.injectContextProxies(this.exceptionMappers, this.postMatchContainerRequestFilters.values(), this.preMatchContainerRequestFilters, this.postMatchContainerResponseFilters.values());
    }

    @Override
    protected void injectContextProxiesIntoProvider(ProviderInfo<?> pi) {
        this.injectContextProxiesIntoProvider(pi, this.application == null ? null : this.application.getProvider());
    }

    @Override
    protected void injectContextValues(ProviderInfo<?> pi, Message m) {
        if (m != null) {
            InjectionUtils.injectContexts(pi.getProvider(), pi, m);
            if (this.application != null && this.application.contextsAvailable()) {
                InjectionUtils.injectContexts(this.application.getProvider(), this.application, m);
            }
        }
    }

    private void addContainerRequestFilter(List<ProviderInfo<ContainerRequestFilter>> postMatchFilters, ProviderInfo<ContainerRequestFilter> p) {
        ContainerRequestFilter filter = p.getProvider();
        if (ServerProviderFactory.isWadlGenerator(filter.getClass())) {
            this.wadlGenerator = p;
        } else if (ServerProviderFactory.isPrematching(filter.getClass())) {
            this.addProviderToList(this.preMatchContainerRequestFilters, p);
        } else {
            postMatchFilters.add(p);
        }
    }

    private static boolean isWadlGenerator(Class<?> filterCls) {
        if (filterCls == null || filterCls == Object.class) {
            return false;
        }
        if (WADL_PROVIDER_NAME.equals(filterCls.getName())) {
            return true;
        }
        return ServerProviderFactory.isWadlGenerator(filterCls.getSuperclass());
    }

    public RequestPreprocessor getRequestPreprocessor() {
        return this.requestPreprocessor;
    }

    public void setApplicationProvider(ProviderInfo<Application> app) {
        this.application = app;
    }

    public ProviderInfo<Application> getApplicationProvider() {
        return this.application;
    }

    public void setRequestPreprocessor(RequestPreprocessor rp) {
        this.requestPreprocessor = rp;
    }

    public void clearExceptionMapperProxies() {
        this.clearProxies(this.exceptionMappers);
    }

    @Override
    public void clearProviders() {
        super.clearProviders();
        this.exceptionMappers.clear();
        this.postMatchContainerRequestFilters.clear();
        this.postMatchContainerResponseFilters.clear();
        this.preMatchContainerRequestFilters.clear();
    }

    @Override
    public void clearThreadLocalProxies() {
        if (this.application != null) {
            this.application.clearThreadLocalProxies();
        }
        super.clearThreadLocalProxies();
    }

    public void applyDynamicFeatures(List<ClassResourceInfo> list) {
        if (this.dynamicFeatures.size() > 0) {
            for (ClassResourceInfo cri : list) {
                this.doApplyDynamicFeatures(cri);
            }
        }
    }

    private void doApplyDynamicFeatures(ClassResourceInfo cri) {
        Set<OperationResourceInfo> oris = cri.getMethodDispatcher().getOperationResourceInfos();
        for (OperationResourceInfo ori : oris) {
            for (DynamicFeature feature : this.dynamicFeatures) {
                MethodFeatureContextImpl featureContext = new MethodFeatureContextImpl(ori);
                feature.configure((ResourceInfo)new ResourceInfoImpl(ori), (FeatureContext)featureContext);
                super.setDynamicConfiguration(featureContext.getConfiguration());
            }
        }
        Collection<ClassResourceInfo> subs = cri.getSubResources();
        for (ClassResourceInfo sub : subs) {
            if (sub == cri) continue;
            this.doApplyDynamicFeatures(sub);
        }
    }

    protected static boolean isPrematching(Class<?> filterCls) {
        return AnnotationUtils.getClassAnnotation(filterCls, PreMatching.class) != null;
    }

    public static void clearThreadLocalProxies(Message message) {
        ServerProviderFactory.clearThreadLocalProxies(ServerProviderFactory.getInstance(message), message);
    }

    public static void clearThreadLocalProxies(ServerProviderFactory factory, Message message) {
        factory.clearThreadLocalProxies();
        ClassResourceInfo cri = (ClassResourceInfo)message.getExchange().get((Object)"root.resource.class");
        if (cri != null) {
            cri.clearThreadLocalProxies();
        }
    }

    public static void releaseRequestState(Message message) {
        ServerProviderFactory.releaseRequestState(ServerProviderFactory.getInstance(message), message);
    }

    public static void releaseRequestState(ServerProviderFactory factory, Message message) {
        Object rootProvider;
        Object rootInstance = message.getExchange().remove((Object)"service.root.instance");
        if (rootInstance != null && (rootProvider = message.getExchange().remove((Object)"service.root.provider")) != null) {
            try {
                ((ResourceProvider)rootProvider).releaseInstance(message, rootInstance);
            }
            catch (Throwable tex) {
                // empty catch block
            }
        }
        ServerProviderFactory.clearThreadLocalProxies(factory, message);
    }

    private static class MethodFeatureContextConfigurable
    extends ConfigurableImpl<FeatureContext> {
        protected MethodFeatureContextConfigurable(MethodFeatureContextImpl mc) {
            super(mc, RuntimeType.SERVER, SERVER_FILTER_INTERCEPTOR_CLASSES.toArray(new Class[0]));
        }

        @Override
        public FeatureContext register(Object provider, Map<Class<?>, Integer> contracts) {
            super.register(provider, contracts);
            return ((MethodFeatureContextImpl)super.getConfigurable()).doRegister(provider, contracts);
        }
    }

    private class MethodFeatureContextImpl
    implements FeatureContext {
        private Configurable<FeatureContext> configImpl;
        private OperationResourceInfo ori;
        private String nameBinding;

        public MethodFeatureContextImpl(OperationResourceInfo ori) {
            this.ori = ori;
            this.configImpl = new MethodFeatureContextConfigurable(this);
            this.nameBinding = "org.apache.cxf.filter.binding" + ori.getClassResourceInfo().getServiceClass().getName() + "." + ori.getMethodToInvoke().getName();
        }

        public Configuration getConfiguration() {
            return this.configImpl.getConfiguration();
        }

        public FeatureContext property(String name, Object value) {
            return (FeatureContext)this.configImpl.property(name, value);
        }

        public FeatureContext register(Class<?> cls) {
            return (FeatureContext)this.configImpl.register(cls);
        }

        public FeatureContext register(Object object) {
            return (FeatureContext)this.configImpl.register(object);
        }

        public FeatureContext register(Class<?> cls, int index) {
            return (FeatureContext)this.configImpl.register(cls, index);
        }

        public FeatureContext register(Class<?> cls, Class<?> ... contracts) {
            return (FeatureContext)this.configImpl.register(cls, (Class[])contracts);
        }

        public FeatureContext register(Class<?> cls, Map<Class<?>, Integer> map) {
            return (FeatureContext)this.configImpl.register(cls, map);
        }

        public FeatureContext register(Object object, int index) {
            return (FeatureContext)this.configImpl.register(object, index);
        }

        public FeatureContext register(Object object, Class<?> ... contracts) {
            return (FeatureContext)this.configImpl.register(object, (Class[])contracts);
        }

        public FeatureContext register(Object object, Map<Class<?>, Integer> map) {
            return (FeatureContext)this.configImpl.register(object, map);
        }

        FeatureContext doRegister(Object provider, Map<Class<?>, Integer> contracts) {
            HashMap actualContracts = new HashMap();
            for (Class<?> contract : contracts.keySet()) {
                if (!SERVER_FILTER_INTERCEPTOR_CLASSES.contains(contract) || !contract.isAssignableFrom(provider.getClass())) continue;
                actualContracts.put(contract, contracts.get(contract));
            }
            if (!actualContracts.isEmpty()) {
                ServerProviderFactory.this.registerUserProvider(new FilterProviderInfo<Object>(provider, ServerProviderFactory.this.getBus(), this.nameBinding, true, actualContracts));
                this.ori.addNameBindings(Collections.singletonList(this.nameBinding));
            }
            return this;
        }
    }
}

