/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Providers;
import org.apache.cxf.jaxrs.ext.StreamingResponse;
import org.apache.cxf.jaxrs.utils.InjectionUtils;

public class StreamingResponseProvider<T>
implements MessageBodyWriter<StreamingResponse<T>> {
    @Context
    private Providers providers;

    public boolean isWriteable(Class<?> cls, Type type, Annotation[] anns, MediaType mt) {
        return StreamingResponse.class.isAssignableFrom(cls);
    }

    public void writeTo(StreamingResponse<T> p, Class<?> cls, Type t, Annotation[] anns, MediaType mt, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException, WebApplicationException {
        Class<Object> actualCls = InjectionUtils.getActualType(t);
        if (cls == actualCls) {
            actualCls = Object.class;
        }
        StreamingResponseWriter thewriter = new StreamingResponseWriter(actualCls, anns, mt, headers, os);
        p.writeTo(thewriter);
    }

    public long getSize(StreamingResponse<T> arg0, Class<?> arg1, Type arg2, Annotation[] arg3, MediaType arg4) {
        return -1L;
    }

    private class StreamingResponseWriter
    implements StreamingResponse.Writer<T> {
        private volatile MessageBodyWriter<T> writer;
        private Class<?> entityCls;
        private MediaType mt;
        private Annotation[] anns;
        private MultivaluedMap<String, Object> headers;
        private OutputStream os;

        public StreamingResponseWriter(Class<?> entityCls, Annotation[] anns, MediaType mt, MultivaluedMap<String, Object> headers, OutputStream os) {
            this.entityCls = entityCls;
            this.anns = anns;
            this.mt = mt;
            this.headers = headers;
            this.os = os;
        }

        @Override
        public void write(T data) throws IOException {
            Class<?> actualCls;
            Class<?> clazz = actualCls = this.entityCls != Object.class ? this.entityCls : data.getClass();
            if (this.writer == null) {
                this.writer = StreamingResponseProvider.this.providers.getMessageBodyWriter(actualCls, actualCls, this.anns, this.mt);
                if (this.writer == null) {
                    throw new InternalServerErrorException();
                }
            }
            this.writer.writeTo(data, actualCls, actualCls, this.anns, this.mt, this.headers, this.os);
        }

        @Override
        public OutputStream getEntityStream() {
            return this.os;
        }
    }
}

