/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Providers;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalProxy;
import org.apache.cxf.jaxrs.utils.InjectionUtils;

public abstract class AbstractResourceInfo {
    public static final String CONSTRUCTOR_PROXY_MAP = "jaxrs-constructor-proxy-map";
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractResourceInfo.class);
    private static final String FIELD_PROXY_MAP = "jaxrs-field-proxy-map";
    private static final String SETTER_PROXY_MAP = "jaxrs-setter-proxy-map";
    private static final Set<String> STANDARD_CONTEXT_CLASSES = new HashSet<String>();
    protected boolean root;
    protected Class<?> resourceClass;
    protected Class<?> serviceClass;
    private Map<Class<?>, List<Field>> contextFields;
    private Map<Class<?>, Map<Class<?>, Method>> contextMethods;
    private Bus bus;
    private boolean constructorProxiesAvailable;
    private boolean contextsAvailable;

    protected AbstractResourceInfo(Bus bus) {
        this.bus = bus;
    }

    protected AbstractResourceInfo(Class<?> resourceClass, Class<?> serviceClass, boolean isRoot, boolean checkContexts, Bus bus) {
        this(resourceClass, serviceClass, isRoot, checkContexts, null, bus, null);
    }

    protected AbstractResourceInfo(Class<?> resourceClass, Class<?> serviceClass, boolean isRoot, boolean checkContexts, Map<Class<?>, ThreadLocalProxy<?>> constructorProxies, Bus bus, Object provider) {
        this.bus = bus;
        this.serviceClass = serviceClass;
        this.resourceClass = resourceClass;
        this.root = isRoot;
        if (checkContexts && resourceClass != null) {
            this.findContexts(serviceClass, provider, constructorProxies);
        }
    }

    private void findContexts(Class<?> cls, Object provider, Map<Class<?>, ThreadLocalProxy<?>> constructorProxies) {
        this.findContextFields(cls, provider);
        this.findContextSetterMethods(cls, provider);
        if (constructorProxies != null) {
            Map<Class<?>, Map<Class<?>, ThreadLocalProxy<?>>> proxies = this.getConstructorProxyMap(true);
            proxies.put(this.serviceClass, constructorProxies);
            this.constructorProxiesAvailable = true;
        }
        this.contextsAvailable = this.contextFields != null && !this.contextFields.isEmpty() || this.contextMethods != null && !this.contextMethods.isEmpty() || this.constructorProxiesAvailable;
    }

    public boolean contextsAvailable() {
        return this.contextsAvailable;
    }

    public Bus getBus() {
        return this.bus;
    }

    public void setResourceClass(Class<?> rClass) {
        this.resourceClass = rClass;
        if (this.serviceClass.isInterface() && this.resourceClass != null && !this.resourceClass.isInterface()) {
            this.findContexts(this.resourceClass, null, null);
        }
    }

    public Class<?> getServiceClass() {
        return this.serviceClass;
    }

    private void findContextFields(Class<?> cls, Object provider) {
        if (cls == Object.class || cls == null) {
            return;
        }
        for (Field f : cls.getDeclaredFields()) {
            for (Annotation a : f.getAnnotations()) {
                if (a.annotationType() != Context.class) continue;
                this.contextFields = this.addContextField(this.contextFields, f);
                if (!f.getType().isInterface()) continue;
                this.checkContextClass(f.getType());
                this.addToMap(this.getFieldProxyMap(true), f, AbstractResourceInfo.getFieldThreadLocalProxy(f, provider));
            }
        }
        this.findContextFields(cls.getSuperclass(), provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ThreadLocalProxy<?> getFieldThreadLocalProxy(Field f, Object provider) {
        if (provider != null) {
            ThreadLocalProxy<?> proxy = null;
            Object object = provider;
            synchronized (object) {
                try {
                    proxy = InjectionUtils.extractFieldValue(f, provider);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (!(proxy instanceof ThreadLocalProxy)) {
                    proxy = InjectionUtils.createThreadLocalProxy(f.getType());
                    InjectionUtils.injectFieldValue(f, provider, proxy);
                }
            }
            return proxy;
        }
        return InjectionUtils.createThreadLocalProxy(f.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ThreadLocalProxy<?> getMethodThreadLocalProxy(Method m, Object provider) {
        if (provider != null) {
            ThreadLocalProxy<?> proxy = null;
            Object object = provider;
            synchronized (object) {
                try {
                    proxy = InjectionUtils.extractFromMethod(provider, InjectionUtils.getGetterFromSetter(m), false);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (!(proxy instanceof ThreadLocalProxy)) {
                    proxy = InjectionUtils.createThreadLocalProxy(m.getParameterTypes()[0]);
                    InjectionUtils.injectThroughMethod(provider, m, proxy);
                }
            }
            return proxy;
        }
        return InjectionUtils.createThreadLocalProxy(m.getParameterTypes()[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Map<Class<?>, Map<T, ThreadLocalProxy<?>>> getProxyMap(Class<T> keyCls, String prop, boolean create) {
        Map property = null;
        Bus bus = this.bus;
        synchronized (bus) {
            property = this.bus.getProperty(prop);
            if (property == null && create) {
                Map map = Collections.synchronizedMap(new WeakHashMap(2));
                this.bus.setProperty(prop, map);
                property = map;
            }
        }
        return property;
    }

    public Map<Class<?>, ThreadLocalProxy<?>> getConstructorProxies() {
        if (this.constructorProxiesAvailable) {
            return this.getConstructorProxyMap(false).get(this.serviceClass);
        }
        return null;
    }

    private Map<Class<?>, Map<Class<?>, ThreadLocalProxy<?>>> getConstructorProxyMap(boolean create) {
        Map property = this.bus.getProperty(CONSTRUCTOR_PROXY_MAP);
        if (property == null) {
            Map map = Collections.synchronizedMap(new WeakHashMap(2));
            this.bus.setProperty(CONSTRUCTOR_PROXY_MAP, map);
            property = map;
        }
        return property;
    }

    private Map<Class<?>, Map<Field, ThreadLocalProxy<?>>> getFieldProxyMap(boolean create) {
        return this.getProxyMap(Field.class, FIELD_PROXY_MAP, create);
    }

    private Map<Class<?>, Map<Method, ThreadLocalProxy<?>>> getSetterProxyMap(boolean create) {
        return this.getProxyMap(Method.class, SETTER_PROXY_MAP, create);
    }

    private void findContextSetterMethods(Class<?> cls, Object provider) {
        Class<?>[] interfaces;
        block0: for (Method m : cls.getMethods()) {
            if (!m.getName().startsWith("set") || m.getParameterTypes().length != 1) continue;
            for (Annotation a : m.getAnnotations()) {
                if (a.annotationType() != Context.class) continue;
                this.checkContextMethod(m, provider);
                continue block0;
            }
        }
        for (Class<?> i : interfaces = cls.getInterfaces()) {
            this.findContextSetterMethods(i, provider);
        }
        Class<?> superCls = cls.getSuperclass();
        if (superCls != null && superCls != Object.class) {
            this.findContextSetterMethods(superCls, provider);
        }
    }

    private void checkContextMethod(Method m, Object provider) {
        Class<?> type = m.getParameterTypes()[0];
        if (type.isInterface() || type == Application.class) {
            this.checkContextClass(type);
            this.addContextMethod(type, m, provider);
        }
    }

    private void checkContextClass(Class<?> type) {
        if (!STANDARD_CONTEXT_CLASSES.contains(type.getName())) {
            LOG.fine("Injecting a custom context " + type.getName() + ", ContextProvider is required for this type");
        }
    }

    public Map<Class<?>, Method> getContextMethods() {
        Map<Class<?>, Method> methods = this.contextMethods == null ? null : this.contextMethods.get(this.getServiceClass());
        return methods == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(methods);
    }

    private void addContextMethod(Class<?> contextClass, Method m, Object provider) {
        if (this.contextMethods == null) {
            this.contextMethods = new HashMap();
        }
        this.addToMap(this.contextMethods, contextClass, m);
        if (m.getParameterTypes()[0] != Application.class) {
            this.addToMap(this.getSetterProxyMap(true), m, AbstractResourceInfo.getMethodThreadLocalProxy(m, provider));
        }
    }

    public boolean isRoot() {
        return this.root;
    }

    public Class<?> getResourceClass() {
        return this.resourceClass;
    }

    public List<Field> getContextFields() {
        return this.getList(this.contextFields);
    }

    public ThreadLocalProxy<?> getContextFieldProxy(Field f) {
        return this.getProxy(this.getFieldProxyMap(true), f);
    }

    public ThreadLocalProxy<?> getContextSetterProxy(Method m) {
        return this.getProxy(this.getSetterProxyMap(true), m);
    }

    public abstract boolean isSingleton();

    public static void clearAllMaps() {
        Bus bus = BusFactory.getThreadDefaultBus((boolean)false);
        if (bus != null) {
            Object property = bus.getProperty(FIELD_PROXY_MAP);
            if (property != null) {
                ((Map)property).clear();
            }
            if ((property = bus.getProperty(SETTER_PROXY_MAP)) != null) {
                ((Map)property).clear();
            }
            if ((property = bus.getProperty(CONSTRUCTOR_PROXY_MAP)) != null) {
                ((Map)property).clear();
            }
        }
    }

    public void clearThreadLocalProxies() {
        this.clearProxies(this.getFieldProxyMap(false));
        this.clearProxies(this.getSetterProxyMap(false));
        this.clearProxies(this.getConstructorProxyMap(false));
    }

    private <T> void clearProxies(Map<Class<?>, Map<T, ThreadLocalProxy<?>>> tlps) {
        Map<T, ThreadLocalProxy<?>> proxies;
        Map<T, ThreadLocalProxy<?>> map = proxies = tlps == null ? null : tlps.get(this.getServiceClass());
        if (proxies == null) {
            return;
        }
        for (ThreadLocalProxy<?> tlp : proxies.values()) {
            if (tlp == null) continue;
            tlp.remove();
        }
    }

    private Map<Class<?>, List<Field>> addContextField(Map<Class<?>, List<Field>> theFields, Field f) {
        List<Field> fields;
        if (theFields == null) {
            theFields = new HashMap();
        }
        if ((fields = theFields.get(this.serviceClass)) == null) {
            fields = new ArrayList<Field>();
            theFields.put(this.serviceClass, fields);
        }
        if (!fields.contains(f)) {
            fields.add(f);
        }
        return theFields;
    }

    private <T, V> void addToMap(Map<Class<?>, Map<T, V>> proxyMap, T f, V proxy) {
        Map<Object, V> proxies = proxyMap.get(this.serviceClass);
        if (proxies == null) {
            proxies = Collections.synchronizedMap(new WeakHashMap());
            proxyMap.put(this.serviceClass, proxies);
        }
        if (!proxies.containsKey(f)) {
            proxies.put(f, proxy);
        }
    }

    private List<Field> getList(Map<Class<?>, List<Field>> fields) {
        List<Field> ret = fields == null ? null : fields.get(this.getServiceClass());
        ret = ret != null ? Collections.unmodifiableList(ret) : Collections.emptyList();
        return ret;
    }

    private <T> ThreadLocalProxy<?> getProxy(Map<Class<?>, Map<T, ThreadLocalProxy<?>>> proxies, T key) {
        Map<T, ThreadLocalProxy<?>> theMap = proxies == null ? null : proxies.get(this.getServiceClass());
        ThreadLocalProxy<?> ret = null;
        if (theMap != null) {
            ret = theMap.get(key);
        }
        return ret;
    }

    static {
        STANDARD_CONTEXT_CLASSES.add(Application.class.getName());
        STANDARD_CONTEXT_CLASSES.add(UriInfo.class.getName());
        STANDARD_CONTEXT_CLASSES.add(HttpHeaders.class.getName());
        STANDARD_CONTEXT_CLASSES.add(Request.class.getName());
        STANDARD_CONTEXT_CLASSES.add(SecurityContext.class.getName());
        STANDARD_CONTEXT_CLASSES.add(Providers.class.getName());
        STANDARD_CONTEXT_CLASSES.add(ContextResolver.class.getName());
        STANDARD_CONTEXT_CLASSES.add("javax.servlet.http.HttpServletRequest");
        STANDARD_CONTEXT_CLASSES.add("javax.servlet.http.HttpServletResponse");
        STANDARD_CONTEXT_CLASSES.add("javax.servlet.ServletContext");
        STANDARD_CONTEXT_CLASSES.add("javax.ws.rs.container.ResourceContext");
        STANDARD_CONTEXT_CLASSES.add("javax.ws.rs.container.ResourceInfo");
        STANDARD_CONTEXT_CLASSES.add("javax.ws.rs.core.Configuration");
    }
}

