/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.client.ResponseProcessingException;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.NoContentException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.ReaderInputStream;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;

public final class ResponseImpl
extends Response {
    public static final String RESPONSE_STREAM_AUTO_CLOSE = "response.stream.auto.close";
    private static final Pattern LINK_DELIMITER = Pattern.compile(",\\s*(?=\\<|$)");
    private Response.StatusType status;
    private Object entity;
    private Annotation[] entityAnnotations;
    private MultivaluedMap<String, Object> metadata;
    private Message outMessage;
    private boolean entityClosed;
    private boolean entityBufferred;
    private Object lastEntity;

    ResponseImpl(int statusCode) {
        this.status = this.createStatusType(statusCode, null);
    }

    ResponseImpl(int statusCode, Object entity) {
        this(statusCode);
        this.entity = entity;
    }

    ResponseImpl(int statusCode, Object entity, String reasonPhrase) {
        this.status = this.createStatusType(statusCode, reasonPhrase);
        this.entity = entity;
    }

    public void addMetadata(MultivaluedMap<String, Object> meta) {
        this.metadata = meta;
    }

    public void setStatus(int statusCode) {
        this.status = this.createStatusType(statusCode, null);
    }

    public void setStatus(int statusCode, String reasonPhrase) {
        this.status = this.createStatusType(statusCode, reasonPhrase);
    }

    public void setEntity(Object e, Annotation[] anns) {
        this.entity = e;
        this.entityAnnotations = anns;
    }

    public void setEntityAnnotations(Annotation[] anns) {
        this.entityAnnotations = anns;
    }

    public Annotation[] getEntityAnnotations() {
        return this.entityAnnotations;
    }

    public void setOutMessage(Message message) {
        this.outMessage = message;
    }

    public Message getOutMessage() {
        return this.outMessage;
    }

    public int getStatus() {
        return this.status.getStatusCode();
    }

    public Response.StatusType getStatusInfo() {
        return this.status;
    }

    public Object getActualEntity() {
        this.checkEntityIsClosed();
        return this.lastEntity != null ? this.lastEntity : this.entity;
    }

    public Object getEntity() {
        return InjectionUtils.getEntity(this.getActualEntity());
    }

    public boolean hasEntity() {
        Object actualEntity = this.getActualEntity();
        if (actualEntity == null) {
            return false;
        }
        if (this.entityBufferred) {
            return true;
        }
        if (actualEntity instanceof InputStream) {
            InputStream is = (InputStream)actualEntity;
            try {
                PushbackInputStream pbis;
                if (is.markSupported()) {
                    is.mark(1);
                    int i = is.read();
                    is.reset();
                    return i != -1;
                }
                try {
                    if (is.available() > 0) {
                        return true;
                    }
                }
                catch (IOException i) {
                    // empty catch block
                }
                int b = is.read();
                if (b == -1) {
                    return false;
                }
                if (is instanceof PushbackInputStream) {
                    pbis = (PushbackInputStream)is;
                } else {
                    pbis = new PushbackInputStream(is, 1);
                    if (this.lastEntity != null) {
                        this.lastEntity = pbis;
                    } else {
                        this.entity = pbis;
                    }
                }
                pbis.unread(b);
                return true;
            }
            catch (IOException ex) {
                throw new ProcessingException((Throwable)ex);
            }
        }
        return true;
    }

    public MultivaluedMap<String, Object> getMetadata() {
        return this.getHeaders();
    }

    public MultivaluedMap<String, Object> getHeaders() {
        return this.metadata;
    }

    public MultivaluedMap<String, String> getStringHeaders() {
        MetadataMap<String, String> headers = new MetadataMap<String, String>(false, true);
        for (Map.Entry entry : this.metadata.entrySet()) {
            String headerName = (String)entry.getKey();
            headers.put(headerName, this.toListOfStrings((List)entry.getValue()));
        }
        return headers;
    }

    public String getHeaderString(String header) {
        List methodValues = (List)this.metadata.get((Object)header);
        return HttpUtils.getHeaderString(this.toListOfStrings(methodValues));
    }

    private List<String> toListOfStrings(List<Object> values) {
        if (values == null) {
            return null;
        }
        ArrayList<String> stringValues = new ArrayList<String>(values.size());
        RuntimeDelegate.HeaderDelegate<Object> hd = HttpUtils.getHeaderDelegate(values.get(0));
        for (Object value : values) {
            String actualValue = hd == null ? value.toString() : hd.toString(value);
            stringValues.add(actualValue);
        }
        return stringValues;
    }

    public Set<String> getAllowedMethods() {
        List methodValues = (List)this.metadata.get((Object)"Allow");
        if (methodValues == null) {
            return Collections.emptySet();
        }
        HashSet<String> methods = new HashSet<String>();
        for (Object o : methodValues) {
            methods.add(o.toString());
        }
        return methods;
    }

    public Map<String, NewCookie> getCookies() {
        List cookieValues = (List)this.metadata.get((Object)"Set-Cookie");
        if (cookieValues == null) {
            return Collections.emptyMap();
        }
        HashMap<String, NewCookie> cookies = new HashMap<String, NewCookie>();
        for (Object o : cookieValues) {
            NewCookie newCookie = NewCookie.valueOf((String)o.toString());
            cookies.put(newCookie.getName(), newCookie);
        }
        return cookies;
    }

    public Date getDate() {
        return this.doGetDate("Date");
    }

    private Date doGetDate(String dateHeader) {
        Object value = this.metadata.getFirst((Object)dateHeader);
        return value == null || value instanceof Date ? (Date)value : HttpUtils.getHttpDate(value.toString());
    }

    public EntityTag getEntityTag() {
        Object header = this.metadata.getFirst((Object)"ETag");
        return header == null || header instanceof EntityTag ? (EntityTag)header : EntityTag.valueOf((String)header.toString());
    }

    public Locale getLanguage() {
        Object header = this.metadata.getFirst((Object)"Content-Language");
        return header == null || header instanceof Locale ? (Locale)header : HttpUtils.getLocale(header.toString());
    }

    public Date getLastModified() {
        return this.doGetDate("Last-Modified");
    }

    public int getLength() {
        Object header = this.metadata.getFirst((Object)"Content-Length");
        return HttpUtils.getContentLength(header == null ? null : header.toString());
    }

    public URI getLocation() {
        Object header = this.metadata.getFirst((Object)"Location");
        return header == null || header instanceof URI ? (URI)header : URI.create(header.toString());
    }

    public MediaType getMediaType() {
        Object header = this.metadata.getFirst((Object)"Content-Type");
        return header == null || header instanceof MediaType ? (MediaType)header : JAXRSUtils.toMediaType(header.toString());
    }

    public boolean hasLink(String relation) {
        List linkValues = (List)this.metadata.get((Object)"Link");
        if (linkValues != null) {
            for (Object o : linkValues) {
                String[] links;
                if (o instanceof Link && relation.equals(((Link)o).getRel())) {
                    return true;
                }
                for (String splitLink : links = LINK_DELIMITER.split(o.toString())) {
                    Link link = Link.valueOf((String)splitLink);
                    if (!relation.equals(link.getRel())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Link getLink(String relation) {
        Set<Link> links = this.getAllLinks();
        for (Link link : links) {
            if (link.getRel() == null || !link.getRel().equals(relation)) continue;
            return link;
        }
        return null;
    }

    public Link.Builder getLinkBuilder(String relation) {
        Link link = this.getLink(relation);
        return link == null ? null : Link.fromLink((Link)link);
    }

    public Set<Link> getLinks() {
        return new HashSet<Link>(this.getAllLinks());
    }

    private Set<Link> getAllLinks() {
        List linkValues = (List)this.metadata.get((Object)"Link");
        if (linkValues == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<Link> links = new LinkedHashSet<Link>();
        for (Object o : linkValues) {
            List<Link> parsedLinks = this.parseLink(o);
            links.addAll(parsedLinks);
        }
        return links;
    }

    private Link makeAbsoluteLink(Link link) {
        if (!link.getUri().isAbsolute()) {
            URI requestURI = URI.create((String)this.outMessage.get((Object)"org.apache.cxf.request.uri"));
            link = Link.fromLink((Link)link).baseUri(requestURI).build(new Object[0]);
        }
        return link;
    }

    private List<Link> parseLink(Object o) {
        String[] linkArray;
        if (o instanceof Link) {
            return Collections.singletonList(this.makeAbsoluteLink((Link)o));
        }
        ArrayList<Link> links = new ArrayList<Link>();
        for (String textLink : linkArray = LINK_DELIMITER.split(o.toString())) {
            Link link = Link.valueOf((String)textLink);
            links.add(this.makeAbsoluteLink(link));
        }
        return Collections.unmodifiableList(links);
    }

    public <T> T readEntity(Class<T> cls) throws ProcessingException, IllegalStateException {
        return this.readEntity(cls, new Annotation[0]);
    }

    public <T> T readEntity(GenericType<T> genType) throws ProcessingException, IllegalStateException {
        return this.readEntity(genType, new Annotation[0]);
    }

    public <T> T readEntity(Class<T> cls, Annotation[] anns) throws ProcessingException, IllegalStateException {
        return this.doReadEntity(cls, cls, anns);
    }

    public <T> T readEntity(GenericType<T> genType, Annotation[] anns) throws ProcessingException, IllegalStateException {
        return this.doReadEntity(genType.getRawType(), genType.getType(), anns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T doReadEntity(Class<T> cls, Type t, Annotation[] anns) throws ProcessingException, IllegalStateException {
        List<ReaderInterceptor> readers;
        this.checkEntityIsClosed();
        if (this.lastEntity != null && cls.isAssignableFrom(this.lastEntity.getClass()) && !(this.lastEntity instanceof InputStream)) {
            return cls.cast(this.lastEntity);
        }
        MediaType mediaType = this.getMediaType();
        if (mediaType == null) {
            mediaType = MediaType.WILDCARD_TYPE;
        }
        boolean entityStreamAvailable = this.entityStreamAvailable();
        InputStream entityStream = null;
        if (!entityStreamAvailable) {
            entityStream = this.convertEntityToStreamIfPossible();
            entityStreamAvailable = entityStream != null;
        } else if (this.entity instanceof InputStream) {
            entityStream = (InputStream)InputStream.class.cast(this.entity);
        } else {
            Message inMessage = this.getResponseMessage();
            Reader reader = (Reader)inMessage.getContent(Reader.class);
            if (reader != null) {
                entityStream = (InputStream)InputStream.class.cast(new ReaderInputStream(reader));
            }
        }
        List<ReaderInterceptor> list = readers = this.outMessage == null ? null : ProviderFactory.getInstance(this.outMessage).createMessageBodyReaderInterceptor(cls, t, anns, mediaType, this.outMessage, entityStreamAvailable, null);
        if (readers != null) {
            boolean autoCloseHint = !JAXRSUtils.isStreamingLikeOutType(cls, t);
            try {
                if (this.entityBufferred) {
                    ((InputStream)InputStream.class.cast(this.entity)).reset();
                }
                Message responseMessage = this.getResponseMessage();
                responseMessage.put((Object)Message.PROTOCOL_HEADERS, this.getHeaders());
                this.lastEntity = JAXRSUtils.readFromMessageBodyReader(readers, cls, t, anns, entityStream, mediaType, responseMessage);
                T tCastLastEntity = this.castLastEntity();
                this.autoCloseWithHint(cls, autoCloseHint, false);
                T t2 = tCastLastEntity;
                return t2;
            }
            catch (NoContentException ex) {
                if (ResponseImpl.isBasicType(cls)) {
                    this.autoClose(cls, true);
                    this.reportMessageHandlerProblem("MSG_READER_PROBLEM", cls, mediaType, ex);
                }
                this.autoCloseWithHint(cls, autoCloseHint, false);
                T t3 = null;
                return t3;
            }
            catch (Exception ex) {
                this.autoClose(cls, true);
                this.reportMessageHandlerProblem("MSG_READER_PROBLEM", cls, mediaType, ex);
            }
            finally {
                ProviderFactory pf = ProviderFactory.getInstance(this.outMessage);
                if (pf != null) {
                    pf.clearThreadLocalProxies();
                }
            }
        } else {
            if (this.entity != null && cls.isAssignableFrom(this.entity.getClass())) {
                this.lastEntity = this.entity;
                return this.castLastEntity();
            }
            if (entityStreamAvailable) {
                this.reportMessageHandlerProblem("NO_MSG_READER", cls, mediaType, null);
            }
        }
        throw new IllegalStateException("The entity is not backed by an input stream, entity class is : " + (this.entity != null ? this.entity.getClass().getName() : cls.getName()));
    }

    private <T> T castLastEntity() {
        return (T)this.lastEntity;
    }

    public InputStream convertEntityToStreamIfPossible() {
        String stringEntity = null;
        if (this.entity instanceof String || this.entity instanceof Number) {
            stringEntity = this.entity.toString();
        }
        if (stringEntity != null) {
            try {
                return new ByteArrayInputStream(stringEntity.getBytes(StandardCharsets.UTF_8));
            }
            catch (Exception ex) {
                throw new ProcessingException((Throwable)ex);
            }
        }
        return null;
    }

    private boolean entityStreamAvailable() {
        if (this.entity == null) {
            Message inMessage = this.getResponseMessage();
            return inMessage != null && (inMessage.getContent(XMLStreamReader.class) != null || inMessage.getContent(Reader.class) != null);
        }
        return this.entity instanceof InputStream;
    }

    private Message getResponseMessage() {
        Message responseMessage = this.outMessage.getExchange().getInMessage();
        if (responseMessage == null) {
            responseMessage = this.outMessage.getExchange().getInFaultMessage();
        }
        return responseMessage;
    }

    private void reportMessageHandlerProblem(String name, Class<?> cls, MediaType ct, Throwable cause) {
        String errorMessage = JAXRSUtils.logMessageHandlerProblem(name, cls, ct);
        throw new ResponseProcessingException((Response)this, errorMessage, cause);
    }

    protected void autoClose(Class<?> cls, boolean exception) {
        this.autoCloseWithHint(cls, false, exception);
    }

    protected void autoCloseWithHint(Class<?> cls, boolean autoCloseHint, boolean exception) {
        if (!this.entityBufferred && !JAXRSUtils.isStreamingOutType(cls) && (exception || MessageUtils.getContextualBoolean((Message)this.outMessage, (String)RESPONSE_STREAM_AUTO_CLOSE, (boolean)autoCloseHint))) {
            this.close();
        }
    }

    public boolean bufferEntity() throws ProcessingException {
        this.checkEntityIsClosed();
        if (!this.entityBufferred && this.entity instanceof InputStream) {
            try {
                InputStream oldEntity = (InputStream)this.entity;
                this.entity = IOUtils.loadIntoBAIS((InputStream)oldEntity);
                oldEntity.close();
                this.entityBufferred = true;
            }
            catch (IOException ex) {
                throw new ResponseProcessingException((Response)this, (Throwable)ex);
            }
        }
        return this.entityBufferred;
    }

    public void close() throws ProcessingException {
        if (!this.entityClosed) {
            if (!this.entityBufferred && this.entity instanceof InputStream) {
                try {
                    ((InputStream)this.entity).close();
                }
                catch (IOException ex) {
                    throw new ResponseProcessingException((Response)this, (Throwable)ex);
                }
            }
            this.entity = null;
            this.entityClosed = true;
        }
    }

    private void checkEntityIsClosed() {
        if (this.entityClosed) {
            throw new IllegalStateException("Entity is not available");
        }
    }

    private Response.StatusType createStatusType(final int statusCode, final String reasonPhrase) {
        return new Response.StatusType(){

            public Response.Status.Family getFamily() {
                return Response.Status.Family.familyOf((int)statusCode);
            }

            public String getReasonPhrase() {
                if (reasonPhrase != null) {
                    return reasonPhrase;
                }
                Response.Status statusEnum = Response.Status.fromStatusCode((int)statusCode);
                return statusEnum != null ? statusEnum.getReasonPhrase() : "";
            }

            public int getStatusCode() {
                return statusCode;
            }
        };
    }

    private static boolean isBasicType(Class<?> type) {
        return type.isPrimitive() || Number.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || Character.class.isAssignableFrom(type);
    }
}

