/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.impl.HttpHeadersImpl;
import org.apache.cxf.jaxrs.impl.PathSegmentImpl;
import org.apache.cxf.jaxrs.impl.UriInfoImpl;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;

public class RequestPreprocessor {
    private static final String ALLOW_HTTP_METHOD_OVERRIDE = "org.apache.cxf.jaxrs.allow.http.method.override";
    private static final String ACCEPT_QUERY = "_type";
    private static final String CTYPE_QUERY = "_ctype";
    private static final String METHOD_QUERY = "_method";
    private static final String METHOD_HEADER = "X-HTTP-Method-Override";
    private static final Set<String> PATHS_TO_SKIP;
    private static final Map<String, String> MEDIA_TYPE_SHORTCUTS;
    private Map<Object, Object> languageMappings;
    private Map<Object, Object> extensionMappings;

    public RequestPreprocessor() {
        this(null, null);
    }

    public RequestPreprocessor(Map<Object, Object> languageMappings, Map<Object, Object> extensionMappings) {
        this.languageMappings = languageMappings == null ? Collections.emptyMap() : languageMappings;
        this.extensionMappings = extensionMappings == null ? Collections.emptyMap() : extensionMappings;
    }

    public String preprocess(Message m, UriInfo u) {
        this.handleExtensionMappings(m, u);
        this.handleLanguageMappings(m, u);
        MultivaluedMap queries = u.getQueryParameters();
        this.handleTypeQuery(m, (MultivaluedMap<String, String>)queries);
        this.handleCType(m, (MultivaluedMap<String, String>)queries);
        this.handleMethod(m, (MultivaluedMap<String, String>)queries, new HttpHeadersImpl(m));
        return new UriInfoImpl(m, null).getPath();
    }

    private void handleLanguageMappings(Message m, UriInfo uriInfo) {
        if (this.languageMappings.isEmpty()) {
            return;
        }
        PathSegmentImpl ps = new PathSegmentImpl(uriInfo.getPath(false), false);
        String path = ps.getPath();
        for (Map.Entry<Object, Object> entry : this.languageMappings.entrySet()) {
            if (!path.endsWith("." + String.valueOf(entry.getKey()))) continue;
            this.updateAcceptLanguageHeader(m, entry.getValue().toString());
            this.updatePath(m, path, entry.getKey().toString(), ps.getMatrixString());
            break;
        }
    }

    private void handleExtensionMappings(Message m, UriInfo uriInfo) {
        if (this.extensionMappings.isEmpty()) {
            return;
        }
        PathSegmentImpl ps = new PathSegmentImpl(uriInfo.getPath(false), false);
        String path = ps.getPath();
        if (PATHS_TO_SKIP.contains(path)) {
            return;
        }
        for (Map.Entry<Object, Object> entry : this.extensionMappings.entrySet()) {
            String key = entry.getKey().toString();
            if (!path.endsWith("." + key)) continue;
            this.updateAcceptTypeHeader(m, entry.getValue().toString());
            this.updatePath(m, path, key, ps.getMatrixString());
            if (!"wadl".equals(key)) break;
            Object query = (String)m.get((Object)Message.QUERY_STRING);
            if (StringUtils.isEmpty((String)query)) {
                query = "_wadl";
            } else if (!((String)query).contains("_wadl")) {
                query = (String)query + "&_wadl";
            }
            m.put((Object)Message.QUERY_STRING, query);
            break;
        }
    }

    private void updateAcceptLanguageHeader(Message m, String anotherValue) {
        ArrayList<String> acceptLanguage = (ArrayList<String>)((Map)m.get((Object)Message.PROTOCOL_HEADERS)).get("Accept-Language");
        if (acceptLanguage == null) {
            acceptLanguage = new ArrayList<String>();
        }
        acceptLanguage.add(anotherValue);
        ((Map)m.get((Object)Message.PROTOCOL_HEADERS)).put("Accept-Language", acceptLanguage);
    }

    private void updatePath(Message m, String path, String suffix, String matrixString) {
        Object newPath = path.substring(0, path.length() - (suffix.length() + 1));
        if (matrixString != null) {
            newPath = (String)newPath + matrixString;
        }
        HttpUtils.updatePath(m, (String)newPath);
    }

    private void handleMethod(Message m, MultivaluedMap<String, String> queries, HttpHeaders headers) {
        if (MessageUtils.getContextualBoolean((Message)m, (String)ALLOW_HTTP_METHOD_OVERRIDE, (boolean)false)) {
            List list;
            String method = (String)queries.getFirst((Object)METHOD_QUERY);
            if (method == null && (list = headers.getRequestHeader(METHOD_HEADER)) != null && list.size() == 1) {
                method = (String)list.get(0);
            }
            if (method != null) {
                m.put((Object)"org.apache.cxf.request.method", (Object)method);
            }
        }
    }

    private void handleTypeQuery(Message m, MultivaluedMap<String, String> queries) {
        String type = (String)queries.getFirst((Object)ACCEPT_QUERY);
        if (type != null) {
            if (MEDIA_TYPE_SHORTCUTS.containsKey(type)) {
                type = MEDIA_TYPE_SHORTCUTS.get(type);
            }
            this.updateAcceptTypeHeader(m, type);
        }
    }

    private void handleCType(Message m, MultivaluedMap<String, String> queries) {
        String type = (String)queries.getFirst((Object)CTYPE_QUERY);
        if (type != null) {
            if (MEDIA_TYPE_SHORTCUTS.containsKey(type)) {
                type = MEDIA_TYPE_SHORTCUTS.get(type);
            }
            m.put((Object)"Content-Type", (Object)type);
        }
    }

    private void updateAcceptTypeHeader(Message m, String acceptValue) {
        m.put((Object)"Accept", (Object)acceptValue);
        ((Map)m.get((Object)Message.PROTOCOL_HEADERS)).put("Accept", Collections.singletonList(acceptValue));
    }

    static {
        MEDIA_TYPE_SHORTCUTS = new HashMap<String, String>();
        MEDIA_TYPE_SHORTCUTS.put("json", "application/json");
        MEDIA_TYPE_SHORTCUTS.put("text", "text/*");
        MEDIA_TYPE_SHORTCUTS.put("xml", "application/xml");
        MEDIA_TYPE_SHORTCUTS.put("atom", "application/atom+xml");
        MEDIA_TYPE_SHORTCUTS.put("html", "text/html");
        MEDIA_TYPE_SHORTCUTS.put("wadl", "application/vnd.sun.wadl+xml");
        PATHS_TO_SKIP = new HashSet<String>();
        PATHS_TO_SKIP.add("swagger.json");
        PATHS_TO_SKIP.add("swagger.yaml");
        PATHS_TO_SKIP.add("openapi.json");
        PATHS_TO_SKIP.add("openapi.yaml");
    }
}

