/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.support;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.xml.ws.handler.MessageContext;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ContextPropertiesMapping {
    private static Map<String, String> cxf2jaxwsMap = new HashMap<String, String>();
    private static Map<String, String> jaxws2cxfMap = new HashMap<String, String>();

    private ContextPropertiesMapping() {
    }

    private static void mapContext(Map<String, Object> context, Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            Object o = context.get(entry.getKey());
            if (o == null) continue;
            context.put(entry.getValue(), o);
        }
    }

    public static void mapRequestfromJaxws2Cxf(Map<String, Object> context) {
        Object requestHeaders = context.get("javax.xml.ws.http.request.headers");
        if (null != requestHeaders) {
            context.put(Message.PROTOCOL_HEADERS, requestHeaders);
        }
        ContextPropertiesMapping.mapJaxws2Cxf(context);
    }

    public static void mapResponsefromCxf2Jaxws(Map<String, Object> context) {
        Object responseHeaders = context.get(Message.PROTOCOL_HEADERS);
        if (null != responseHeaders) {
            context.put("javax.xml.ws.http.response.headers", responseHeaders);
        }
        ContextPropertiesMapping.mapContext(context, cxf2jaxwsMap);
    }

    private static void mapJaxws2Cxf(Map<String, Object> context) {
        ContextPropertiesMapping.mapContext(context, jaxws2cxfMap);
        if (context.containsKey("javax.xml.ws.security.auth.username")) {
            AuthorizationPolicy authPolicy = new AuthorizationPolicy();
            authPolicy.setUserName((String)context.get("javax.xml.ws.security.auth.username"));
            authPolicy.setPassword((String)context.get("javax.xml.ws.security.auth.password"));
            context.put(AuthorizationPolicy.class.getName(), authPolicy);
        }
    }

    private static void mapCxf2Jaxws(WrappedMessageContext context) {
        for (Map.Entry<String, String> entry : cxf2jaxwsMap.entrySet()) {
            Object o = context.get(entry.getKey());
            if (o != null) {
                context.put(entry.getValue(), o, MessageContext.Scope.APPLICATION);
                continue;
            }
            if (!context.containsKey(entry.getValue())) continue;
            context.put(entry.getValue(), context.get(entry.getValue()), MessageContext.Scope.APPLICATION);
        }
        if (context.containsKey(AuthorizationPolicy.class.getName())) {
            AuthorizationPolicy authPolicy = (AuthorizationPolicy)context.get(AuthorizationPolicy.class.getName());
            context.put("javax.xml.ws.security.auth.username", authPolicy.getUserName(), MessageContext.Scope.APPLICATION);
            context.put("javax.xml.ws.security.auth.password", authPolicy.getPassword(), MessageContext.Scope.APPLICATION);
        }
    }

    public static MessageContext createWebServiceContext(Exchange exchange) {
        WrappedMessageContext ctx = new WrappedMessageContext(exchange.getInMessage(), MessageContext.Scope.APPLICATION);
        ContextPropertiesMapping.mapCxf2Jaxws(exchange, ctx, false);
        return ctx;
    }

    public static void mapCxf2Jaxws(Exchange exchange, WrappedMessageContext ctx, boolean requestor) {
        ctx.put("javax.xml.ws.wsdl.description", exchange.get((Object)"javax.xml.ws.wsdl.description"));
        ctx.put("javax.xml.ws.wsdl.interface", exchange.get((Object)"javax.xml.ws.wsdl.interface"));
        ctx.put("javax.xml.ws.wsdl.operation", exchange.get((Object)"javax.xml.ws.wsdl.operation"));
        ctx.put("javax.xml.ws.wsdl.port", exchange.get((Object)"javax.xml.ws.wsdl.port"));
        ctx.put("javax.xml.ws.wsdl.service", exchange.get((Object)"javax.xml.ws.wsdl.service"));
        ContextPropertiesMapping.mapCxf2Jaxws(ctx);
        Message inMessage = exchange.getInMessage();
        Message outMessage = exchange.getOutMessage();
        if (inMessage == null && Boolean.TRUE.equals(ctx.get("org.apache.cxf.message.inbound"))) {
            inMessage = ctx.getWrappedMessage();
        }
        if (inMessage != null) {
            ContextPropertiesMapping.addMessageAttachments(ctx, inMessage, "javax.xml.ws.binding.attachments.inbound");
            Object inHeaders = inMessage.get((Object)Message.PROTOCOL_HEADERS);
            if (null != inHeaders) {
                if (requestor) {
                    ctx.put("javax.xml.ws.http.response.headers", inHeaders, MessageContext.Scope.APPLICATION);
                } else {
                    ctx.put("javax.xml.ws.http.request.headers", inHeaders, MessageContext.Scope.APPLICATION);
                }
                outMessage = exchange.getOutMessage();
                if (outMessage == null) {
                    Endpoint ep = (Endpoint)exchange.get(Endpoint.class);
                    outMessage = ep.getBinding().createMessage();
                    exchange.setOutMessage(outMessage);
                }
            }
        }
        if (outMessage != null) {
            ContextPropertiesMapping.addMessageAttachments(ctx, outMessage, "javax.xml.ws.binding.attachments.outbound");
            Object outHeaders = outMessage.get((Object)Message.PROTOCOL_HEADERS);
            if (outHeaders != null && !requestor) {
                ctx.put("javax.xml.ws.http.request.headers", outHeaders, MessageContext.Scope.APPLICATION);
            }
        }
    }

    private static void addMessageAttachments(WrappedMessageContext ctx, Message message, String propertyName) {
        LinkedHashMap<String, DataHandler> dataHandlers = null;
        Collection attachments = message.getAttachments();
        if (attachments != null) {
            dataHandlers = new LinkedHashMap<String, DataHandler>();
            for (Attachment attachment : attachments) {
                dataHandlers.put(attachment.getId(), attachment.getDataHandler());
            }
        }
        ctx.put(propertyName, dataHandlers == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(dataHandlers), MessageContext.Scope.APPLICATION);
    }

    public static void updateWebServiceContext(Exchange exchange, MessageContext ctx) {
        if (ctx.containsKey((Object)"javax.xml.ws.http.response.code")) {
            exchange.getOutMessage().put((Object)Message.RESPONSE_CODE, ctx.get((Object)"javax.xml.ws.http.response.code"));
        }
        if (ctx.containsKey((Object)Header.HEADER_LIST) && ctx.get((Object)Header.HEADER_LIST) instanceof List && exchange.getOutMessage() instanceof SoapMessage) {
            SoapMessage sm = (SoapMessage)exchange.getOutMessage();
            Iterator iter = ((List)ctx.get((Object)Header.HEADER_LIST)).iterator();
            while (iter.hasNext()) {
                sm.getHeaders().add((Header)iter.next());
            }
        }
        if (ctx.containsKey((Object)"javax.xml.ws.http.response.headers")) {
            Map other = CastUtils.cast((Map)((Map)ctx.get((Object)"javax.xml.ws.http.response.headers")));
            Map heads = CastUtils.cast((Map)((Map)exchange.getOutMessage().get((Object)Message.PROTOCOL_HEADERS)));
            if (heads != null) {
                heads.putAll(other);
            } else if (!other.isEmpty()) {
                exchange.getOutMessage().put((Object)Message.PROTOCOL_HEADERS, ctx.get((Object)"javax.xml.ws.http.response.headers"));
            }
        }
    }

    static {
        cxf2jaxwsMap.put(Message.ENDPOINT_ADDRESS, "javax.xml.ws.service.endpoint.address");
        cxf2jaxwsMap.put(Message.MAINTAIN_SESSION, "javax.xml.ws.session.maintain");
        cxf2jaxwsMap.put(Message.HTTP_REQUEST_METHOD, "javax.xml.ws.http.request.method");
        cxf2jaxwsMap.put(Message.RESPONSE_CODE, "javax.xml.ws.http.response.code");
        cxf2jaxwsMap.put(Message.PATH_INFO, "javax.xml.ws.http.request.pathinfo");
        cxf2jaxwsMap.put(Message.QUERY_STRING, "javax.xml.ws.http.request.querystring");
        cxf2jaxwsMap.put("HTTP.REQUEST", "javax.xml.ws.servlet.request");
        cxf2jaxwsMap.put("HTTP.RESPONSE", "javax.xml.ws.servlet.response");
        cxf2jaxwsMap.put("HTTP.CONTEXT", "javax.xml.ws.servlet.context");
        jaxws2cxfMap.put("javax.xml.ws.service.endpoint.address", Message.ENDPOINT_ADDRESS);
        jaxws2cxfMap.put("javax.xml.ws.session.maintain", Message.MAINTAIN_SESSION);
        jaxws2cxfMap.put("javax.xml.ws.http.request.method", Message.HTTP_REQUEST_METHOD);
        jaxws2cxfMap.put("javax.xml.ws.http.response.code", Message.RESPONSE_CODE);
        jaxws2cxfMap.put("javax.xml.ws.http.request.pathinfo", Message.PATH_INFO);
        jaxws2cxfMap.put("javax.xml.ws.http.request.querystring", Message.QUERY_STRING);
        jaxws2cxfMap.put("javax.xml.ws.servlet.request", "HTTP.REQUEST");
        jaxws2cxfMap.put("javax.xml.ws.servlet.response", "HTTP.RESPONSE");
        jaxws2cxfMap.put("javax.xml.ws.servlet.context", "HTTP.CONTEXT");
        jaxws2cxfMap.put("javax.xml.ws.soap.http.soapaction.uri", "SOAPAction");
    }
}

