/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws;

import java.lang.reflect.Method;
import java.util.logging.Logger;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.frontend.SimpleMethodDispatcher;
import org.apache.cxf.jaxws.support.JaxWsImplementorInfo;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.OperationInfo;

public class JAXWSMethodDispatcher
extends SimpleMethodDispatcher {
    private static final Logger LOG = LogUtils.getL7dLogger(JAXWSMethodDispatcher.class);
    private JaxWsImplementorInfo implInfo;

    public JAXWSMethodDispatcher(JaxWsImplementorInfo implInfo) {
        this.implInfo = implInfo;
    }

    public void bind(OperationInfo o, Method ... methods) {
        Method[] newMethods = new Method[methods.length];
        int i = 0;
        for (Method m : methods) {
            try {
                newMethods[i++] = this.getImplementationMethod(m);
            }
            catch (NoSuchMethodException e) {
                Class<?> endpointClass = this.implInfo.getImplementorClass();
                Message msg = new Message("SEI_METHOD_NOT_FOUND", LOG, new Object[]{m.getName(), endpointClass.getName()});
                throw new ServiceConstructionException(msg, (Throwable)e);
            }
        }
        super.bind(o, newMethods);
    }

    public BindingOperationInfo getBindingOperation(Method method, Endpoint endpoint) {
        try {
            method = this.getImplementationMethod(method);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return super.getBindingOperation(method, endpoint);
    }

    public Method getImplementationMethod(Method method) throws NoSuchMethodException {
        Class<?> endpointClass = this.implInfo.getImplementorClass();
        if (!endpointClass.isAssignableFrom(method.getDeclaringClass())) {
            try {
                method = endpointClass.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (SecurityException e) {
                throw new ServiceConstructionException((Throwable)e);
            }
        }
        return method;
    }
}

