/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws;

import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.activation.DataSource;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Dispatch;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.Response;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.http.HTTPBinding;
import javax.xml.ws.http.HTTPException;
import javax.xml.ws.soap.SOAPBinding;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.binding.soap.saaj.SAAJInInterceptor;
import org.apache.cxf.binding.soap.saaj.SAAJOutInterceptor;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxws.EndpointReferenceBuilder;
import org.apache.cxf.jaxws.JaxWsClientProxy;
import org.apache.cxf.jaxws.JaxwsClientCallback;
import org.apache.cxf.jaxws.JaxwsResponseCallback;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.staxutils.OverlayW3CDOMStreamWriter;
import org.apache.cxf.staxutils.StaxSource;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.W3CDOMStreamReader;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DispatchImpl<T>
implements Dispatch<T>,
BindingProvider {
    private static final Logger LOG = LogUtils.getL7dLogger(DispatchImpl.class);
    private final Binding binding;
    private final EndpointReferenceBuilder builder;
    private final Client client;
    private final Class<T> cl;
    private final JAXBContext context;
    private Message error;

    DispatchImpl(Client client, Service.Mode m, JAXBContext ctx, Class<T> clazz) {
        this.binding = ((JaxWsEndpointImpl)client.getEndpoint()).getJaxwsBinding();
        this.builder = new EndpointReferenceBuilder((JaxWsEndpointImpl)client.getEndpoint());
        this.client = client;
        this.context = ctx;
        this.cl = clazz;
        this.setupEndpointAddressContext(client.getEndpoint());
        this.addInvokeOperation(false);
        this.addInvokeOperation(true);
        if (m == Service.Mode.MESSAGE && this.binding instanceof SOAPBinding) {
            if (DataSource.class.isAssignableFrom(clazz)) {
                this.error = new Message("DISPATCH_OBJECT_NOT_SUPPORTED", LOG, new Object[]{"DataSource", m, "SOAP/HTTP"});
            } else if (m == Service.Mode.MESSAGE) {
                SAAJOutInterceptor saajOut = new SAAJOutInterceptor();
                client.getOutInterceptors().add(saajOut);
                client.getOutInterceptors().add(new MessageModeOutInterceptor(saajOut));
                client.getInInterceptors().add(new SAAJInInterceptor());
                client.getInInterceptors().add(new MessageModeInInterceptor(clazz));
            }
        } else if (m == Service.Mode.PAYLOAD && this.binding instanceof SOAPBinding && SOAPMessage.class.isAssignableFrom(clazz)) {
            this.error = new Message("DISPATCH_OBJECT_NOT_SUPPORTED", LOG, new Object[]{"SOAPMessage", m, "SOAP/HTTP"});
        } else if (DataSource.class.isAssignableFrom(clazz) && this.binding instanceof HTTPBinding) {
            this.error = new Message("DISPATCH_OBJECT_NOT_SUPPORTED", LOG, new Object[]{"DataSource", m, "XML/HTTP"});
        }
    }

    DispatchImpl(Client cl, Service.Mode m, Class<T> clazz) {
        this(cl, m, null, clazz);
    }

    private void addInvokeOperation(boolean oneWay) {
        String name = oneWay ? "InvokeOneWay" : "Invoke";
        String ns = "http://cxf.apache.org/jaxws/dispatch";
        ServiceInfo info = this.client.getEndpoint().getEndpointInfo().getService();
        OperationInfo opInfo = info.getInterface().addOperation(new QName(ns, name));
        MessageInfo mInfo = opInfo.createMessage(new QName(ns, name + "Request"), MessageInfo.Type.INPUT);
        opInfo.setInput(name + "Request", mInfo);
        MessagePartInfo mpi = mInfo.addMessagePart("parameters");
        if (this.context == null) {
            mpi.setTypeClass(this.cl);
        }
        mpi.setElement(true);
        if (!oneWay) {
            mInfo = opInfo.createMessage(new QName(ns, name + "Response"), MessageInfo.Type.OUTPUT);
            opInfo.setOutput(name + "Response", mInfo);
            mpi = mInfo.addMessagePart("parameters");
            mpi.setElement(true);
            if (this.context == null) {
                mpi.setTypeClass(this.cl);
            }
        }
        for (BindingInfo bind : this.client.getEndpoint().getEndpointInfo().getService().getBindings()) {
            BindingOperationInfo bo = new BindingOperationInfo(bind, opInfo);
            bind.addOperation(bo);
        }
    }

    public Map<String, Object> getRequestContext() {
        return new WrappedMessageContext(this.client.getRequestContext(), null, MessageContext.Scope.APPLICATION);
    }

    public Map<String, Object> getResponseContext() {
        return new WrappedMessageContext(this.client.getResponseContext(), null, MessageContext.Scope.APPLICATION);
    }

    public Binding getBinding() {
        return this.binding;
    }

    public EndpointReference getEndpointReference() {
        return this.builder.getEndpointReference();
    }

    public <X extends EndpointReference> X getEndpointReference(Class<X> clazz) {
        return this.builder.getEndpointReference(clazz);
    }

    private void setupEndpointAddressContext(Endpoint endpoint) {
        if (null != endpoint && null != endpoint.getEndpointInfo().getAddress()) {
            WrappedMessageContext requestContext = new WrappedMessageContext(this.client.getRequestContext(), null, MessageContext.Scope.APPLICATION);
            requestContext.put("javax.xml.ws.service.endpoint.address", endpoint.getEndpointInfo().getAddress());
        }
    }

    public T invoke(T obj) {
        return this.invoke(obj, false);
    }

    private void checkError() {
        if (this.error != null) {
            if (this.getBinding() instanceof SOAPBinding) {
                SOAPFault soapFault = null;
                try {
                    soapFault = JaxWsClientProxy.createSoapFault((SOAPBinding)this.getBinding(), new Exception(this.error.toString()));
                }
                catch (SOAPException sOAPException) {
                    // empty catch block
                }
                if (soapFault != null) {
                    throw new SOAPFaultException(soapFault);
                }
            } else if (this.getBinding() instanceof HTTPBinding) {
                HTTPException exception = new HTTPException(500);
                exception.initCause((Throwable)new Exception(this.error.toString()));
                throw exception;
            }
            throw new WebServiceException(this.error.toString());
        }
    }

    private RuntimeException mapException(Exception ex) {
        if (this.getBinding() instanceof HTTPBinding) {
            HTTPException exception = new HTTPException(500);
            exception.initCause((Throwable)ex);
            return exception;
        }
        if (this.getBinding() instanceof SOAPBinding) {
            SOAPFault soapFault = null;
            try {
                soapFault = JaxWsClientProxy.createSoapFault((SOAPBinding)this.getBinding(), ex);
            }
            catch (SOAPException e) {
                // empty catch block
            }
            if (soapFault == null) {
                return new WebServiceException((Throwable)ex);
            }
            SOAPFaultException exception = new SOAPFaultException(soapFault);
            exception.initCause((Throwable)ex);
            return exception;
        }
        return new WebServiceException((Throwable)ex);
    }

    public T invoke(T obj, boolean isOneWay) {
        this.checkError();
        try {
            SOAPMessage msg;
            if (obj instanceof SOAPMessage && (msg = (SOAPMessage)obj).countAttachments() > 0) {
                this.client.getRequestContext().put("write.attachments", Boolean.TRUE);
            }
            Object[] ret = this.client.invokeWrapped(new QName("http://cxf.apache.org/jaxws/dispatch", "Invoke" + (isOneWay ? "OneWay" : "")), new Object[]{obj});
            if (isOneWay) {
                return null;
            }
            return (T)ret[0];
        }
        catch (Exception ex) {
            throw this.mapException(ex);
        }
    }

    public Future<?> invokeAsync(T obj, AsyncHandler<T> asyncHandler) {
        this.checkError();
        this.client.setExecutor(this.getClient().getEndpoint().getExecutor());
        JaxwsClientCallback<T> callback = new JaxwsClientCallback<T>(asyncHandler);
        JaxwsResponseCallback ret = new JaxwsResponseCallback(callback);
        try {
            this.client.invokeWrapped(callback, new QName("http://cxf.apache.org/jaxws/dispatch", "Invoke"), new Object[]{obj});
            return ret;
        }
        catch (Exception ex) {
            throw this.mapException(ex);
        }
    }

    public Response<T> invokeAsync(T obj) {
        return (Response)this.invokeAsync(obj, null);
    }

    public void invokeOneWay(T obj) {
        this.invoke(obj, true);
    }

    public Client getClient() {
        return this.client;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MessageModeInInterceptor
    extends AbstractSoapInterceptor {
        Class<?> type;

        public MessageModeInInterceptor(Class<?> c) {
            super("post-logical");
            this.type = c;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(SoapMessage message) throws Fault {
            Object o;
            MessageContentsList list;
            block10: {
                SOAPMessage m = (SOAPMessage)message.getContent(SOAPMessage.class);
                list = (MessageContentsList)message.getContent(List.class);
                if (list == null) {
                    list = new MessageContentsList();
                    message.setContent(List.class, (Object)list);
                }
                o = m;
                if (StreamSource.class.isAssignableFrom(this.type)) {
                    try {
                        CachedOutputStream out = new CachedOutputStream();
                        try {
                            XMLStreamWriter xsw = StaxUtils.createXMLStreamWriter((OutputStream)out);
                            StaxUtils.copy((Source)new DOMSource((Node)m.getSOAPPart()), (XMLStreamWriter)xsw);
                            xsw.close();
                            o = new StreamSource(out.getInputStream());
                            break block10;
                        }
                        finally {
                            out.close();
                        }
                    }
                    catch (Exception e) {
                        throw new Fault((Throwable)e);
                    }
                }
                if (SAXSource.class.isAssignableFrom(this.type)) {
                    o = new StaxSource((XMLStreamReader)new W3CDOMStreamReader((Document)m.getSOAPPart()));
                } else if (Source.class.isAssignableFrom(this.type)) {
                    o = new DOMSource((Node)m.getSOAPPart());
                }
            }
            list.set(0, o);
        }
    }

    static class MessageModeOutInterceptor
    extends AbstractSoapInterceptor {
        SAAJOutInterceptor saajOut;

        public MessageModeOutInterceptor(SAAJOutInterceptor saajOut) {
            super("pre-protocol");
            this.addBefore(SAAJOutInterceptor.class.getName());
            this.saajOut = saajOut;
        }

        public void handleMessage(SoapMessage message) throws Fault {
            MessageContentsList list = (MessageContentsList)message.getContent(List.class);
            Object o = list.get(0);
            SOAPMessage soapMessage = null;
            if (o instanceof SOAPMessage) {
                soapMessage = (SOAPMessage)o;
            } else {
                try {
                    MessageFactory factory = this.saajOut.getFactory(message);
                    soapMessage = factory.createMessage();
                    SOAPPart part = soapMessage.getSOAPPart();
                    if (o instanceof Source) {
                        StaxUtils.copy((Source)((Source)o), (XMLStreamWriter)new W3CDOMStreamWriter((Document)part));
                    }
                }
                catch (SOAPException e) {
                    throw new SoapFault("Error creating SOAPMessage", (Throwable)e, message.getVersion().getSender());
                }
                catch (XMLStreamException e) {
                    throw new SoapFault("Error creating SOAPMessage", (Throwable)e, message.getVersion().getSender());
                }
            }
            message.setContent(SOAPMessage.class, (Object)soapMessage);
            if (!message.containsKey((Object)SAAJOutInterceptor.ORIGINAL_XML_WRITER)) {
                XMLStreamWriter origWriter = (XMLStreamWriter)message.getContent(XMLStreamWriter.class);
                message.put(SAAJOutInterceptor.ORIGINAL_XML_WRITER, (Object)origWriter);
            }
            OverlayW3CDOMStreamWriter writer = new OverlayW3CDOMStreamWriter((Document)soapMessage.getSOAPPart());
            message.setContent(XMLStreamWriter.class, (Object)writer);
            message.setContent(SOAPMessage.class, (Object)soapMessage);
            DocumentFragment frag = soapMessage.getSOAPPart().createDocumentFragment();
            try {
                SOAPBody body = soapMessage.getSOAPBody();
                Node nd = body.getFirstChild();
                while (nd != null) {
                    body.removeChild(nd);
                    frag.appendChild(nd);
                    nd = soapMessage.getSOAPBody().getFirstChild();
                    list.set(0, (Object)frag);
                }
            }
            catch (Exception ex) {
                throw new Fault((Throwable)ex);
            }
            message.getInterceptorChain().add((Interceptor)SAAJOutInterceptor.SAAJOutEndingInterceptor.INSTANCE);
        }
    }
}

