/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.support;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Operation;
import javax.xml.bind.annotation.XmlNsForm;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.namespace.QName;
import javax.xml.ws.Action;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.BindingType;
import javax.xml.ws.FaultAction;
import javax.xml.ws.Service;
import javax.xml.ws.WebFault;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.Addressing;
import javax.xml.ws.soap.AddressingFeature;
import javax.xml.ws.soap.MTOM;
import javax.xml.ws.soap.MTOMFeature;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.util.XMLSchemaQNames;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.databinding.source.SourceDataBinding;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.frontend.MethodDispatcher;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxws.JAXWSMethodDispatcher;
import org.apache.cxf.jaxws.JAXWSProviderMethodDispatcher;
import org.apache.cxf.jaxws.WrapperClassGenerator;
import org.apache.cxf.jaxws.interceptors.WebFaultOutInterceptor;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.apache.cxf.jaxws.support.JaxWsImplementorInfo;
import org.apache.cxf.jaxws.support.JaxWsServiceConfiguration;
import org.apache.cxf.jaxws.support.WebServiceProviderConfiguration;
import org.apache.cxf.service.factory.AbstractServiceConfiguration;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.FaultInfo;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.ws.addressing.JAXWSAConstants;
import org.apache.cxf.wsdl11.WSDLServiceBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxWsServiceFactoryBean
extends ReflectionServiceFactoryBean {
    public static final String WS_FEATURES = "JAXWS-WS-FEATURES";
    private static final Logger LOG = LogUtils.getLogger(JaxWsServiceFactoryBean.class);
    private AbstractServiceConfiguration jaxWsConfiguration;
    private JaxWsImplementorInfo implInfo;
    private List<WebServiceFeature> setWsFeatures;
    private List<WebServiceFeature> wsFeatures;
    private boolean wrapperBeanGenerated;
    private Set<Class<?>> wrapperClasses;

    public JaxWsServiceFactoryBean() {
        this.getIgnoredClasses().add(Service.class.getName());
        this.setQualifyWrapperSchema(false);
        this.initSchemaLocations();
    }

    public JaxWsServiceFactoryBean(JaxWsImplementorInfo implInfo) {
        this();
        this.implInfo = implInfo;
        this.initConfiguration(implInfo);
        this.serviceClass = implInfo.getEndpointClass();
        this.serviceType = implInfo.getSEIType();
        this.loadWSFeatureAnnotation(implInfo.getSEIClass(), implInfo.getImplementorClass());
    }

    public void reset() {
        super.reset();
        this.wrapperBeanGenerated = false;
        this.wrapperClasses = null;
    }

    private void initSchemaLocations() {
        this.schemaLocationMapping.put("http://www.w3.org/2005/08/addressing", "http://www.w3.org/2006/03/addressing/ws-addr.xsd");
    }

    private void loadWSFeatureAnnotation(Class<?> serviceClass, Class<?> implementorClass) {
        ArrayList<WebServiceFeature> features = new ArrayList<WebServiceFeature>();
        MTOM mtom = this.implInfo.getImplementorClass().getAnnotation(MTOM.class);
        if (mtom == null && serviceClass != null) {
            mtom = serviceClass.getAnnotation(MTOM.class);
        }
        if (mtom != null) {
            features.add((WebServiceFeature)new MTOMFeature(mtom.enabled(), mtom.threshold()));
        } else {
            BindingType bt = this.implInfo.getImplementorClass().getAnnotation(BindingType.class);
            if (bt != null && ("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true".equals(bt.value()) || "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true".equals(bt.value()))) {
                features.add((WebServiceFeature)new MTOMFeature(true));
            }
        }
        Addressing addressing = null;
        if (implementorClass != null) {
            addressing = implementorClass.getAnnotation(Addressing.class);
        }
        if (addressing == null && serviceClass != null) {
            addressing = serviceClass.getAnnotation(Addressing.class);
        }
        if (addressing != null) {
            features.add((WebServiceFeature)new AddressingFeature(addressing.enabled(), addressing.required()));
        }
        if (features.size() > 0) {
            this.wsFeatures = features;
            if (this.setWsFeatures != null) {
                this.wsFeatures.addAll(this.setWsFeatures);
            }
        } else {
            this.wsFeatures = this.setWsFeatures;
        }
    }

    public org.apache.cxf.service.Service create() {
        org.apache.cxf.service.Service s = super.create();
        s.put((Object)"endpoint.class", this.implInfo.getEndpointClass());
        return s;
    }

    public void setServiceClass(Class<?> serviceClass) {
        if (serviceClass == null) {
            Message message = new Message("SERVICECLASS_MUST_BE_SET", LOG, new Object[0]);
            throw new ServiceConstructionException(message);
        }
        this.setJaxWsImplementorInfo(new JaxWsImplementorInfo(serviceClass));
        super.setServiceClass(this.getJaxWsImplementorInfo().getEndpointClass());
        super.setServiceType(this.getJaxWsImplementorInfo().getSEIType());
    }

    protected void checkServiceClassAnnotations(Class<?> sc) {
    }

    protected void initializeFaultInterceptors() {
        this.getService().getOutFaultInterceptors().add(new WebFaultOutInterceptor());
    }

    public Endpoint createEndpoint(EndpointInfo ei) throws EndpointException {
        return new JaxWsEndpointImpl(this.getBus(), this.getService(), ei, this.implInfo, this.wsFeatures, this.getFeatures(), this.isFromWsdl());
    }

    protected void initializeWSDLOperation(InterfaceInfo intf, OperationInfo o, Method method) {
        method = ((JaxWsServiceConfiguration)this.jaxWsConfiguration).getDeclaredMethod(method);
        o.setProperty(Method.class.getName(), (Object)method);
        o.setProperty("operation.method", (Object)method);
        this.initializeWrapping(o, method);
        Operation op = (Operation)o.getProperty(WSDLServiceBuilder.WSDL_OPERATION);
        this.initializeClassInfo(o, method, op == null ? null : CastUtils.cast((List)op.getParameterOrdering(), String.class));
        this.bindOperation(o, method);
    }

    protected void bindOperation(OperationInfo op, Method method) {
        try {
            Method responseMethod = method.getDeclaringClass().getDeclaredMethod(method.getName() + "Async", method.getParameterTypes());
            List<Class<?>> asyncHandlerParams = Arrays.asList(method.getParameterTypes());
            asyncHandlerParams = new ArrayList(asyncHandlerParams);
            asyncHandlerParams.add(AsyncHandler.class);
            Method futureMethod = method.getDeclaringClass().getDeclaredMethod(method.getName() + "Async", asyncHandlerParams.toArray(new Class[asyncHandlerParams.size()]));
            this.getMethodDispatcher().bind(op, new Method[]{method, responseMethod, futureMethod});
        }
        catch (SecurityException e) {
            throw new ServiceConstructionException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            this.getMethodDispatcher().bind(op, new Method[]{method});
        }
    }

    protected void initializeWSDLOperations() {
        if (this.implInfo.isWebServiceProvider()) {
            this.initializeWSDLOperationsForProvider();
        } else {
            super.initializeWSDLOperations();
        }
    }

    protected void initializeWSDLOperationsForProvider() {
        Type[] genericInterfaces = this.getServiceClass().getGenericInterfaces();
        ParameterizedType pt = (ParameterizedType)genericInterfaces[0];
        Class c = (Class)pt.getActualTypeArguments()[0];
        if (this.getEndpointInfo() == null && this.isFromWsdl()) {
            ArrayList<QName> enames = new ArrayList<QName>();
            for (ServiceInfo si : this.getService().getServiceInfos()) {
                for (EndpointInfo ep : si.getEndpoints()) {
                    enames.add(ep.getName());
                }
            }
            LOG.log(Level.WARNING, "COULD_NOT_FIND_ENDPOINT", new Object[]{this.getEndpointName(), enames});
        }
        try {
            Method invoke = this.getServiceClass().getMethod("invoke", c);
            QName catchAll = new QName("http://cxf.apache.org/jaxws/provider", "invoke");
            for (ServiceInfo si : this.getService().getServiceInfos()) {
                si.setProperty("soap.force.doclit.bare", (Object)Boolean.TRUE);
                for (BindingInfo bind : si.getBindings()) {
                    OperationInfo op;
                    for (BindingOperationInfo bop : bind.getOperations()) {
                        MessagePartInfo inf;
                        Iterator i$;
                        MessagePartInfo inf2;
                        OperationInfo o = bop.getOperationInfo();
                        if (o.getInput() != null) {
                            if (o.getInput().getMessageParts().isEmpty()) {
                                inf2 = o.getInput().addMessagePart(o.getName());
                                inf2.setConcreteName(o.getName());
                                bop.getInput().setMessageParts(o.getInput().getMessageParts());
                            }
                            if ((i$ = o.getInput().getMessageParts().iterator()).hasNext()) {
                                inf = (MessagePartInfo)i$.next();
                                inf.setTypeClass(c);
                            }
                        }
                        if (o.getOutput() != null) {
                            if (o.getOutput().getMessageParts().isEmpty()) {
                                inf2 = o.getOutput().addMessagePart(o.getName());
                                inf2.setConcreteName(new QName(o.getName().getNamespaceURI(), o.getName().getLocalPart() + "Response"));
                                bop.getOutput().setMessageParts(o.getOutput().getMessageParts());
                            }
                            if ((i$ = o.getOutput().getMessageParts().iterator()).hasNext()) {
                                inf = (MessagePartInfo)i$.next();
                                inf.setTypeClass(c);
                            }
                        }
                        this.getMethodDispatcher().bind(o, new Method[]{invoke});
                    }
                    BindingOperationInfo bop = bind.getOperation(catchAll);
                    if (bop != null || (op = bind.getInterface().getOperation(catchAll)) != null) continue;
                    op = bind.getInterface().addOperation(catchAll);
                    String name = catchAll.getLocalPart();
                    MessageInfo mInfo = op.createMessage(new QName(catchAll.getNamespaceURI(), name + "Request"), MessageInfo.Type.INPUT);
                    op.setInput(catchAll.getLocalPart() + "Request", mInfo);
                    MessagePartInfo mpi = mInfo.addMessagePart("parameters");
                    mpi.setElement(true);
                    mpi.setTypeClass(c);
                    mpi.setTypeQName(XMLSchemaQNames.XSD_ANY);
                    mInfo = op.createMessage(new QName(catchAll.getNamespaceURI(), name + "Response"), MessageInfo.Type.OUTPUT);
                    op.setOutput(name + "Response", mInfo);
                    mpi = mInfo.addMessagePart("parameters");
                    mpi.setElement(true);
                    mpi.setTypeClass(c);
                    mpi.setTypeQName(XMLSchemaQNames.XSD_ANY);
                    BindingOperationInfo bo = new BindingOperationInfo(bind, op);
                    op.setProperty("operation.is.synthetic", (Object)Boolean.TRUE);
                    bo.setProperty("operation.is.synthetic", (Object)Boolean.TRUE);
                    bind.addOperation(bo);
                }
            }
        }
        catch (SecurityException e) {
            throw new ServiceConstructionException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new ServiceConstructionException((Throwable)e);
        }
    }

    void initializeWrapping(OperationInfo o, Method selected) {
        Class requestWrapper;
        Class responseWrapper = this.getResponseWrapper(selected);
        if (responseWrapper != null) {
            ((MessagePartInfo)o.getOutput().getMessageParts().get(0)).setTypeClass(responseWrapper);
        }
        if (this.getResponseWrapperClassName(selected) != null) {
            ((MessagePartInfo)o.getOutput().getMessageParts().get(0)).setProperty("RESPONSE.WRAPPER.CLASSNAME", (Object)this.getResponseWrapperClassName(selected));
        }
        if ((requestWrapper = this.getRequestWrapper(selected)) != null) {
            ((MessagePartInfo)o.getInput().getMessageParts().get(0)).setTypeClass(requestWrapper);
        }
        if (this.getRequestWrapperClassName(selected) != null) {
            ((MessagePartInfo)o.getInput().getMessageParts().get(0)).setProperty("REQUEST.WRAPPER.CLASSNAME", (Object)this.getRequestWrapperClassName(selected));
        }
    }

    protected Class<?> getBeanClass(Class<?> exClass) {
        try {
            if (ServerException.class.isAssignableFrom(exClass) || RemoteException.class.isAssignableFrom(exClass) || "javax.xml.ws".equals(PackageUtils.getPackageName(exClass))) {
                return null;
            }
            Method getFaultInfo = exClass.getMethod("getFaultInfo", new Class[0]);
            return getFaultInfo.getReturnType();
        }
        catch (SecurityException e) {
            throw new ServiceConstructionException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            WebFault fault = exClass.getAnnotation(WebFault.class);
            if (fault != null && !StringUtils.isEmpty((String)fault.faultBean())) {
                try {
                    return ClassLoaderUtils.loadClass((String)fault.faultBean(), exClass);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return super.getBeanClass(exClass);
        }
    }

    public void setJaxWsConfiguration(JaxWsServiceConfiguration jaxWsConfiguration) {
        this.jaxWsConfiguration = jaxWsConfiguration;
    }

    public JaxWsImplementorInfo getJaxWsImplementorInfo() {
        return this.implInfo;
    }

    public void setJaxWsImplementorInfo(JaxWsImplementorInfo jaxWsImplementorInfo) {
        this.implInfo = jaxWsImplementorInfo;
        this.initConfiguration(jaxWsImplementorInfo);
    }

    protected final void initConfiguration(JaxWsImplementorInfo ii) {
        if (ii.isWebServiceProvider()) {
            this.jaxWsConfiguration = new WebServiceProviderConfiguration();
            this.jaxWsConfiguration.setServiceFactory((ReflectionServiceFactoryBean)this);
            this.getServiceConfigurations().add(0, this.jaxWsConfiguration);
            this.setWrapped(false);
            this.setDataBinding((DataBinding)new SourceDataBinding());
            this.setMethodDispatcher(new JAXWSProviderMethodDispatcher(this.implInfo));
        } else {
            XmlSchema schema;
            this.jaxWsConfiguration = new JaxWsServiceConfiguration();
            this.jaxWsConfiguration.setServiceFactory((ReflectionServiceFactoryBean)this);
            this.getServiceConfigurations().add(0, this.jaxWsConfiguration);
            Class<?> seiClass = ii.getEndpointClass();
            if (seiClass != null && seiClass.getPackage() != null && (schema = seiClass.getPackage().getAnnotation(XmlSchema.class)) != null && XmlNsForm.QUALIFIED.equals((Object)schema.elementFormDefault())) {
                this.setQualifyWrapperSchema(true);
            }
            this.setMethodDispatcher((MethodDispatcher)new JAXWSMethodDispatcher(this.implInfo));
        }
        this.loadWSFeatureAnnotation(ii.getSEIClass(), ii.getImplementorClass());
    }

    public List<WebServiceFeature> getWsFeatures() {
        return this.setWsFeatures;
    }

    public void setWsFeatures(List<WebServiceFeature> swsFeatures) {
        this.setWsFeatures = swsFeatures;
        if (this.wsFeatures == null) {
            this.wsFeatures = this.setWsFeatures;
        }
    }

    private FaultInfo getFaultInfo(OperationInfo operation, Class expClass) {
        for (FaultInfo fault : operation.getFaults()) {
            if (fault.getProperty(Class.class.getName()) != expClass && fault.getProperty(Class.class.getName()) != expClass) continue;
            return fault;
        }
        return null;
    }

    private void buildWSAActions(OperationInfo operation, Method method) {
        FaultAction[] faultActions;
        MessageInfo output;
        if (method == null) {
            return;
        }
        Action action = method.getAnnotation(Action.class);
        if (action == null) {
            return;
        }
        MessageInfo input = operation.getInput();
        if (!StringUtils.isEmpty((String)action.input())) {
            input.addExtensionAttribute(JAXWSAConstants.WSAW_ACTION_QNAME, (Object)action.input());
        }
        if ((output = operation.getOutput()) != null && !StringUtils.isEmpty((String)action.output())) {
            output.addExtensionAttribute(JAXWSAConstants.WSAW_ACTION_QNAME, (Object)action.output());
        }
        if ((faultActions = action.fault()) != null && faultActions.length > 0 && operation.getFaults() != null) {
            for (FaultAction faultAction : faultActions) {
                FaultInfo faultInfo = this.getFaultInfo(operation, faultAction.className());
                faultInfo.addExtensionAttribute(JAXWSAConstants.WSAW_ACTION_QNAME, (Object)faultAction.value());
                if (!operation.isUnwrappedCapable()) continue;
                faultInfo = this.getFaultInfo(operation.getUnwrappedOperation(), faultAction.className());
                faultInfo.addExtensionAttribute(JAXWSAConstants.WSAW_ACTION_QNAME, (Object)faultAction.value());
            }
        }
    }

    protected OperationInfo createOperation(ServiceInfo serviceInfo, InterfaceInfo intf, Method m) {
        OperationInfo op = super.createOperation(serviceInfo, intf, m);
        if (op.getUnwrappedOperation() != null) {
            op = op.getUnwrappedOperation();
        }
        this.buildWSAActions(op, m);
        return op;
    }

    protected Set<Class<?>> getExtraClass() {
        XmlSeeAlso xmlSeeAlsoAnno;
        HashSet classes = new HashSet();
        if (!this.wrapperBeanGenerated) {
            this.wrapperClasses = this.generatedWrapperBeanClass();
        }
        if (this.wrapperClasses != null) {
            classes.addAll(this.wrapperClasses);
        }
        if ((xmlSeeAlsoAnno = this.getServiceClass().getAnnotation(XmlSeeAlso.class)) != null && xmlSeeAlsoAnno.value() != null) {
            for (int i = 0; i < xmlSeeAlsoAnno.value().length; ++i) {
                classes.add(xmlSeeAlsoAnno.value()[i]);
            }
        }
        return classes;
    }

    private Set<Class<?>> generatedWrapperBeanClass() {
        if (this.getDataBinding() instanceof JAXBDataBinding) {
            ServiceInfo serviceInfo = (ServiceInfo)this.getService().getServiceInfos().get(0);
            WrapperClassGenerator wrapperGen = new WrapperClassGenerator(this, serviceInfo.getInterface(), this.getQualifyWrapperSchema());
            return wrapperGen.generate();
        }
        return Collections.emptySet();
    }

    protected void buildServiceFromClass() {
        super.buildServiceFromClass();
        this.getService().put((Object)WS_FEATURES, this.getWsFeatures());
    }

    protected void initializeParameter(MessagePartInfo part, Class rawClass, Type type) {
        if (this.implInfo.isWebServiceProvider()) {
            part.setTypeQName(XMLSchemaQNames.XSD_ANY);
            part.setTypeClass(rawClass);
            return;
        }
        super.initializeParameter(part, rawClass, type);
    }
}

