/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.frontend;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.binding.soap.interceptor.EndpointSelectionInterceptor;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.frontend.WSDLGetUtils;
import org.apache.cxf.frontend.WSDLQueryException;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.http.UrlUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLGetInterceptor
extends AbstractPhaseInterceptor<Message> {
    public static final WSDLGetInterceptor INSTANCE = new WSDLGetInterceptor();
    private static final Logger LOG = LogUtils.getL7dLogger(WSDLGetInterceptor.class);

    public WSDLGetInterceptor() {
        super("read");
        this.getAfter().add(EndpointSelectionInterceptor.class.getName());
    }

    public void doOutput(Message message, String base, Document doc, OutputStream out) throws WSDLQueryException {
        String enc = null;
        try {
            enc = doc.getXmlEncoding();
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (enc == null) {
            enc = "utf-8";
        }
        XMLStreamWriter writer = StaxUtils.createXMLStreamWriter((OutputStream)out, (String)enc);
        try {
            StaxUtils.writeNode((Node)doc, (XMLStreamWriter)writer, (boolean)true);
            writer.flush();
        }
        catch (XMLStreamException e) {
            throw new WSDLQueryException(new org.apache.cxf.common.i18n.Message("COULD_NOT_PROVIDE_WSDL", LOG, new Object[]{base}), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(Message message) throws Fault {
        String method = (String)message.get((Object)"org.apache.cxf.request.method");
        String query = (String)message.get((Object)Message.QUERY_STRING);
        if (!"GET".equals(method) || StringUtils.isEmpty((String)query)) {
            return;
        }
        String baseUri = (String)message.get((Object)"org.apache.cxf.request.url");
        String ctx = (String)message.get((Object)Message.PATH_INFO);
        Endpoint endpoint = message.getExchange().getEndpoint();
        synchronized (endpoint) {
            Map map = UrlUtilities.parseQueryString((String)query);
            if (this.isRecognizedQuery(map, baseUri, ctx, message.getExchange().getEndpoint().getEndpointInfo())) {
                try {
                    Conduit c = message.getExchange().getDestination().getBackChannel(message, null, null);
                    MessageImpl mout = new MessageImpl();
                    mout.setExchange(message.getExchange());
                    message.getExchange().setOutMessage((Message)mout);
                    mout.put((Object)"Content-Type", (Object)"text/xml");
                    c.prepare((Message)mout);
                    OutputStream os = (OutputStream)mout.getContent(OutputStream.class);
                    Document doc = this.getDocument(message, baseUri, map, ctx, message.getExchange().getEndpoint().getEndpointInfo());
                    String enc = null;
                    try {
                        enc = doc.getXmlEncoding();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    if (enc == null) {
                        enc = "utf-8";
                    }
                    XMLStreamWriter writer = StaxUtils.createXMLStreamWriter((OutputStream)os, (String)enc);
                    StaxUtils.writeNode((Node)doc, (XMLStreamWriter)writer, (boolean)true);
                    message.getInterceptorChain().abort();
                    try {
                        writer.flush();
                        writer.close();
                        os.flush();
                        os.close();
                    }
                    catch (IOException ex) {
                        LOG.log(Level.FINE, "Failure writing full wsdl to the stream", ex);
                    }
                }
                catch (IOException e) {
                    throw new Fault((Throwable)e);
                }
                catch (XMLStreamException e) {
                    throw new Fault((Throwable)e);
                }
                finally {
                    message.getExchange().setOutMessage(null);
                }
            }
        }
    }

    public Document getDocument(Message message, String base, Map<String, String> params, String ctxUri, EndpointInfo endpointInfo) {
        return new WSDLGetUtils().getDocument(message, base, params, ctxUri, endpointInfo);
    }

    public boolean isRecognizedQuery(Map<String, String> map, String baseUri, String ctx, EndpointInfo endpointInfo) {
        return map.containsKey("wsdl") || map.containsKey("xsd");
    }
}

