/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.web.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Date;
import java.util.UUID;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.cxf.management.web.logging.LogLevel;

@XmlRootElement(namespace="http://cxf.apache.org/log")
public class LogRecord {
    @XmlTransient
    private String id = "uuid:" + UUID.randomUUID().toString();
    private Date eventTimestamp = new Date();
    private LogLevel level = LogLevel.INFO;
    private String message = "";
    private String loggerName = "";
    private String threadName = "";
    private String throwable = "";

    public LogRecord() {
    }

    public LogRecord(String id) {
        this.id = id;
    }

    public LogRecord(LogRecord copy) {
        this.eventTimestamp = copy.getEventTimestamp();
        this.level = copy.getLevel();
        this.message = copy.getMessage();
        this.loggerName = copy.getLoggerName();
        this.threadName = copy.getThreadName();
        this.throwable = copy.getThrowable();
    }

    public static LogRecord fromJUL(java.util.logging.LogRecord julRecord) {
        Validate.notNull((Object)julRecord, (String)"julRecord is null");
        LogRecord record = new LogRecord();
        record.setEventTimestamp(new Date(julRecord.getMillis()));
        record.setLevel(LogLevel.fromJUL(julRecord.getLevel()));
        record.setLoggerName(julRecord.getLoggerName());
        if (julRecord.getThrown() != null) {
            record.setThrowable(julRecord.getThrown());
        }
        if (julRecord.getParameters() != null) {
            record.setMessage(MessageFormat.format(julRecord.getMessage(), julRecord.getParameters()));
        } else {
            record.setMessage(julRecord.getMessage());
        }
        record.setThreadName(Integer.toString(julRecord.getThreadID()));
        return record;
    }

    public String getId() {
        return this.id;
    }

    @XmlElement(namespace="http://cxf.apache.org/log")
    public Date getEventTimestamp() {
        return this.eventTimestamp;
    }

    public void setEventTimestamp(Date eventTimestamp) {
        Validate.notNull((Object)eventTimestamp, (String)"eventTimestamp is null");
        this.eventTimestamp = eventTimestamp;
    }

    @XmlElement(namespace="http://cxf.apache.org/log")
    public LogLevel getLevel() {
        return this.level;
    }

    public void setLevel(LogLevel level) {
        Validate.notNull((Object)((Object)level), (String)"level is null");
        this.level = level;
    }

    @XmlElement(namespace="http://cxf.apache.org/log")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String renderedMessage) {
        Validate.notNull((Object)((Object)this.level), (String)"message is null");
        this.message = renderedMessage;
    }

    @XmlElement(namespace="http://cxf.apache.org/log")
    public String getLoggerName() {
        return this.loggerName;
    }

    public void setLoggerName(String loggerName) {
        Validate.notNull((Object)((Object)this.level), (String)"loggerName is null");
        this.loggerName = loggerName;
    }

    @XmlElement(namespace="http://cxf.apache.org/log")
    public String getThreadName() {
        return this.threadName;
    }

    public void setThreadName(String threadName) {
        Validate.notNull((Object)((Object)this.level), (String)"threadName is null");
        this.threadName = threadName;
    }

    @XmlElement(namespace="http://cxf.apache.org/log")
    public String getThrowable() {
        return this.throwable;
    }

    public void setThrowable(String throwable) {
        Validate.notNull((Object)throwable, (String)"throwable is null");
        this.throwable = throwable;
    }

    public void setThrowable(Throwable thr) {
        Validate.notNull((Object)thr, (String)"throwable is null");
        StringWriter sw = new StringWriter();
        thr.printStackTrace(new PrintWriter(sw));
        this.throwable = sw.getBuffer().toString();
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)obj, (Object)this);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

