/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.web.logging.atom;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.WeakHashMap;
import java.util.logging.Handler;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriBuilder;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.cxf.Bus;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.ext.search.ConditionType;
import org.apache.cxf.jaxrs.ext.search.OrSearchCondition;
import org.apache.cxf.jaxrs.ext.search.PrimitiveStatement;
import org.apache.cxf.jaxrs.ext.search.SearchCondition;
import org.apache.cxf.management.web.logging.LogLevel;
import org.apache.cxf.management.web.logging.LogRecord;
import org.apache.cxf.management.web.logging.ReadWriteLogStorage;
import org.apache.cxf.management.web.logging.ReadableLogStorage;
import org.apache.cxf.management.web.logging.atom.AbstractAtomBean;
import org.apache.cxf.management.web.logging.atom.AtomPullHandler;
import org.apache.cxf.management.web.logging.atom.converter.StandardConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/logs")
public class AtomPullServer
extends AbstractAtomBean {
    private List<LogRecord> records = new LinkedList<LogRecord>();
    private WeakHashMap<Integer, Feed> feeds = new WeakHashMap();
    private ReadableLogStorage storage;
    private int pageSize = 40;
    private int maxInMemorySize = 500;
    private boolean useArchivedFeeds;
    private int recordsSize;
    private volatile boolean alreadyClosed;
    private SearchCondition<LogRecord> condition;
    @Context
    private MessageContext context;
    private List<String> endpointAddresses;
    private String serverAddress;

    public void setEndpointAddress(String address) {
        this.setEndpointAddresses(Collections.singletonList(address));
    }

    public void setEndpointAddresses(List<String> addresses) {
        this.endpointAddresses = addresses;
    }

    public void setServerAddress(String address) {
        this.serverAddress = address;
    }

    @Override
    public void init() {
        if (this.storage != null) {
            this.recordsSize = this.storage.getSize();
        }
        if (this.storage == null || this.storage instanceof ReadWriteLogStorage) {
            super.init();
        } else {
            LinkedList<SearchConditionImpl> list = new LinkedList<SearchConditionImpl>();
            for (AbstractAtomBean.LoggerLevel l : super.getLoggers()) {
                LogRecord r = new LogRecord();
                r.setLoggerName(l.getLogger());
                r.setLevel(LogLevel.valueOf(l.getLevel()));
                list.add(new SearchConditionImpl(r));
            }
            this.condition = new OrSearchCondition(list);
        }
        this.initBusProperty();
    }

    @Override
    protected Handler createHandler() {
        return new AtomPullHandler(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initBusProperty() {
        if (this.endpointAddresses != null && this.serverAddress != null && this.getBus() != null) {
            Bus bus;
            Bus bus2 = bus = this.getBus();
            synchronized (bus2) {
                HashMap<String, String> addresses = (HashMap<String, String>)bus.getProperty("org.apache.cxf.extensions.logging.atom.pull");
                if (addresses == null) {
                    addresses = new HashMap<String, String>();
                }
                for (String address : this.endpointAddresses) {
                    addresses.put(address, this.serverAddress + "/logs");
                }
                bus.setProperty("org.apache.cxf.extensions.logging.atom.pull", addresses);
            }
        }
    }

    @GET
    @Produces(value={"application/atom+xml"})
    public Feed getXmlFeed(@PathParam(value="id") int page) {
        return this.getXmlFeedWithPage(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/atom+xml"})
    @Path(value="{id}")
    public Feed getXmlFeedWithPage(@PathParam(value="id") int page) {
        WeakHashMap<Integer, Feed> weakHashMap = this.feeds;
        synchronized (weakHashMap) {
            Feed f = this.feeds.get(page);
            if (f != null) {
                return f;
            }
        }
        Feed feed = null;
        Object object = this.records;
        synchronized (object) {
            List<LogRecord> list = this.getSubList(page);
            Collections.sort(list, new LogRecordComparator());
            feed = (Feed)new CustomFeedConverter(page).convert(list).get(0);
            this.setFeedPageProperties(feed, page);
        }
        if (feed.getEntries().size() == this.pageSize) {
            object = this.feeds;
            synchronized (object) {
                this.feeds.put(page, feed);
            }
        }
        return feed;
    }

    @GET
    @Produces(value={"text/html", "application/xhtml+xml"})
    @Path(value="alternate/{id}")
    public String getAlternateFeed(@PathParam(value="id") int page) {
        List<LogRecord> list = this.getSubList(page);
        Collections.sort(list, new LogRecordComparator());
        return this.convertEntriesToHtml(list);
    }

    @GET
    @Path(value="entry/{id}")
    @Produces(value={"application/atom+xml;type=entry"})
    public Entry getEntry(@PathParam(value="id") int index) {
        List<LogRecord> list = this.getLogRecords(index);
        return (Entry)new CustomEntryConverter(index).convert(list).get(0);
    }

    @GET
    @Path(value="entry/alternate/{id}")
    @Produces(value={"text/html", "application/xhtml+xml"})
    public String getAlternateEntry(@PathParam(value="id") int index) {
        List<LogRecord> logRecords = this.getLogRecords(index);
        return this.convertEntryToHtml(logRecords.get(0));
    }

    @GET
    @Path(value="records")
    @Produces(value={"text/plain"})
    public int getNumberOfAvailableRecords() {
        return this.recordsSize;
    }

    private List<LogRecord> getLogRecords(int index) {
        LinkedList<LogRecord> list = new LinkedList<LogRecord>();
        if (this.storage != null) {
            int storageSize = this.storage.getSize();
            if (this.recordsSize == -1 || index < storageSize) {
                this.storage.load(list, this.condition, index, 1);
            } else if (index < this.recordsSize) {
                list.add(this.records.get(index - storageSize));
            }
        } else {
            list.add(this.records.get(index));
        }
        if (list.size() != 1) {
            throw new WebApplicationException(404);
        }
        return list;
    }

    protected List<LogRecord> getSubList(int page) {
        if (this.recordsSize == -1) {
            LinkedList<LogRecord> list = new LinkedList<LogRecord>();
            this.storage.load(list, this.condition, page == 1 ? 0 : (page - 1) * this.pageSize, this.pageSize);
            return list;
        }
        if (this.recordsSize == 0) {
            return this.records;
        }
        int fromIndex = 0;
        int toIndex = 0;
        if (!this.useArchivedFeeds) {
            int n = fromIndex = page == 1 ? 0 : (page - 1) * this.pageSize;
            if (fromIndex > this.recordsSize) {
                page = 1;
                fromIndex = 0;
            }
            int n2 = toIndex = page == 1 ? this.pageSize : fromIndex + this.pageSize;
            if (toIndex > this.recordsSize) {
                toIndex = this.recordsSize;
            }
        } else {
            fromIndex = this.recordsSize - this.pageSize * page;
            if (fromIndex < 0) {
                fromIndex = 0;
            }
            int n = toIndex = this.pageSize < this.recordsSize ? this.recordsSize : this.pageSize;
        }
        if (this.storage != null) {
            if (fromIndex < this.storage.getSize()) {
                int storageSize = this.storage.getSize();
                int maxQuantityToLoad = toIndex > storageSize ? toIndex - storageSize : toIndex - fromIndex;
                LinkedList<LogRecord> list = new LinkedList<LogRecord>();
                this.storage.load(list, this.condition, fromIndex, maxQuantityToLoad);
                int totalQuantity = toIndex - fromIndex;
                if (list.size() < totalQuantity) {
                    int remaining = totalQuantity - list.size();
                    if (remaining > this.records.size()) {
                        remaining = this.records.size();
                    }
                    list.addAll(this.records.subList(0, remaining));
                }
                return list;
            }
            fromIndex -= this.storage.getSize();
            toIndex -= this.storage.getSize();
        }
        return this.records.subList(fromIndex, toIndex);
    }

    protected void setFeedPageProperties(Feed feed, int page) {
        String self = this.context.getUriInfo().getAbsolutePath().toString();
        feed.addLink(self, "self");
        String uri = this.context.getUriInfo().getBaseUriBuilder().path("logs").build(new Object[0]).toString();
        feed.addLink(uri + "/alternate/" + page, "alternate");
        if (!this.useArchivedFeeds) {
            if (this.recordsSize != -1) {
                if (page > 2) {
                    feed.addLink(uri, "first");
                }
                if (page * this.pageSize < this.recordsSize) {
                    feed.addLink(uri + "/" + (page + 1), "next");
                }
                if (page * (this.pageSize + 1) < this.recordsSize) {
                    feed.addLink(uri + "/" + (this.recordsSize / this.pageSize + 1), "last");
                }
            } else if (feed.getEntries().size() == this.pageSize) {
                feed.addLink(uri + "/" + (page + 1), "next");
            }
            if (page > 1) {
                uri = page > 2 ? uri + "/" + (page - 1) : uri;
                feed.addLink(uri, "previous");
            }
        } else {
            feed.addLink(self, "current");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(LogRecord record) {
        if (this.alreadyClosed) {
            System.err.println("AtomPullServer has been closed, the following log record can not be saved : " + record.toString());
            return;
        }
        List<LogRecord> list = this.records;
        synchronized (list) {
            if (this.records.size() == this.maxInMemorySize) {
                if (this.storage instanceof ReadWriteLogStorage) {
                    ((ReadWriteLogStorage)this.storage).save(this.records);
                    this.records.clear();
                } else {
                    LogRecord oldRecord = this.records.remove(0);
                    System.err.println("The oldest log record is removed : " + oldRecord.toString());
                }
            }
            this.records.add(record);
            ++this.recordsSize;
        }
    }

    public void setPageSize(int size) {
        this.pageSize = size;
    }

    public void setMaxInMemorySize(int maxInMemorySize) {
        this.maxInMemorySize = maxInMemorySize;
    }

    public void setStorage(ReadableLogStorage storage) {
        this.storage = storage;
    }

    public void close() {
        if (this.alreadyClosed) {
            return;
        }
        this.alreadyClosed = true;
        if (this.storage instanceof ReadWriteLogStorage) {
            ((ReadWriteLogStorage)this.storage).save(this.records);
        }
    }

    private String convertEntriesToHtml(List<LogRecord> rs) {
        StringBuilder sb = new StringBuilder();
        this.startHtmlHeadAndBody(sb, "CXF Service Log Entries");
        this.addRecordToTable(sb, rs, true);
        sb.append("</body></html>");
        return sb.toString();
    }

    private String convertEntryToHtml(LogRecord r) {
        StringBuilder sb = new StringBuilder();
        this.startHtmlHeadAndBody(sb, r.getLevel().toString());
        this.addRecordToTable(sb, Collections.singletonList(r), false);
        sb.append("</body></html>");
        return sb.toString();
    }

    private void addRecordToTable(StringBuilder sb, List<LogRecord> list, boolean forFeed) {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yy HH:mm:ss");
        sb.append("<table border=\"1\">");
        sb.append("<tr><th>Date</th><th>Level</th><th>Logger</th><th>Message</th></tr>");
        for (LogRecord lr : list) {
            sb.append("<tr>");
            sb.append("<td>" + df.format(lr.getEventTimestamp()) + "</td>");
            sb.append("<td>" + lr.getLevel().toString() + "</td>");
            sb.append("<td>" + lr.getLoggerName() + "</td>");
            String message = null;
            message = lr.getMessage().length() > 0 ? (lr.getThrowable().length() > 0 ? lr.getMessage() + " : " + lr.getThrowable() : lr.getMessage()) : (lr.getThrowable().length() > 0 ? lr.getThrowable() : "&nbsp");
            if (forFeed && lr.getThrowable().length() > 0) {
                message = message.substring(0, message.length() / 2);
            }
            sb.append("<td>" + message + "</td>");
            sb.append("</tr>");
        }
        sb.append("</table><br/><br/>");
    }

    private void startHtmlHeadAndBody(StringBuilder sb, String title) {
        sb.append("<html xmlns=\"http://www.w3.org/1999/xhtml\">");
        sb.append("<head>");
        sb.append("<meta http-equiv=\"content-type\" content=\"text/html;charset=UTF-8\"/>");
        sb.append("<title>Log record with level " + title + "</title>");
        sb.append("</head>");
        sb.append("<body>");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CustomEntryConverter
    extends StandardConverter {
        private String selfFragment;
        private String altFragment;

        public CustomEntryConverter(int index) {
            super(StandardConverter.Output.ENTRY, StandardConverter.Multiplicity.ONE, StandardConverter.Format.CONTENT);
            this.selfFragment = "logs/entry/" + index;
            this.altFragment = "logs/alternate/entry/" + index;
        }

        @Override
        protected void setDefaultEntryProperties(Entry entry, List<LogRecord> rs, int entryIndex) {
            super.setDefaultEntryProperties(entry, rs, entryIndex);
            entry.addLink(AtomPullServer.this.context.getUriInfo().getBaseUriBuilder().path(this.selfFragment).build(new Object[0]).toString(), "self");
            entry.addLink(AtomPullServer.this.context.getUriInfo().getBaseUriBuilder().path(this.altFragment).build(new Object[0]).toString(), "alternate");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CustomFeedConverter
    extends StandardConverter {
        private int page;

        public CustomFeedConverter(int page) {
            super(StandardConverter.Output.FEED, StandardConverter.Multiplicity.MANY, StandardConverter.Format.CONTENT);
            this.page = page;
        }

        @Override
        protected void setDefaultEntryProperties(Entry entry, List<LogRecord> rs, int entryIndex) {
            super.setDefaultEntryProperties(entry, rs, entryIndex);
            UriBuilder builder = AtomPullServer.this.context.getUriInfo().getAbsolutePathBuilder().path("entry");
            Integer realIndex = this.page == 1 ? entryIndex : this.page * AtomPullServer.this.pageSize + entryIndex;
            entry.addLink(builder.clone().path(realIndex.toString()).build(new Object[0]).toString(), "self");
            entry.addLink(builder.path("alternate").path(realIndex.toString()).build(new Object[0]).toString(), "alternate");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LogRecordComparator
    implements Comparator<LogRecord> {
        private LogRecordComparator() {
        }

        @Override
        public int compare(LogRecord r1, LogRecord r2) {
            return r1.getEventTimestamp().compareTo(r2.getEventTimestamp()) * -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SearchConditionImpl
    implements SearchCondition<LogRecord> {
        private LogRecord template;

        public SearchConditionImpl(LogRecord l) {
            this.template = l;
        }

        public boolean isMet(LogRecord pojo) {
            return (this.template.getLevel() == LogLevel.ALL || pojo.getLevel().compareTo(this.template.getLevel()) <= 0) && this.template.getLoggerName().equals(pojo.getLoggerName());
        }

        public LogRecord getCondition() {
            return new LogRecord(this.template);
        }

        public ConditionType getConditionType() {
            return ConditionType.CUSTOM;
        }

        public List<SearchCondition<LogRecord>> getSearchConditions() {
            return null;
        }

        public List<LogRecord> findAll(Collection<LogRecord> pojos) {
            LinkedList<LogRecord> list = new LinkedList<LogRecord>();
            for (LogRecord r : pojos) {
                if (!this.isMet(r)) continue;
                list.add(r);
            }
            return list;
        }

        public PrimitiveStatement getStatement() {
            return null;
        }

        public String toSQL(String table, String ... columns) {
            return null;
        }
    }
}

