/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.web.logging.atom;

import java.util.logging.Handler;
import java.util.logging.LogManager;
import org.apache.cxf.management.web.logging.LogRecord;
import org.apache.cxf.management.web.logging.atom.AtomPushEngine;
import org.apache.cxf.management.web.logging.atom.AtomPushEngineConfigurator;
import org.apache.cxf.management.web.logging.atom.LoggingThread;
import org.apache.cxf.management.web.logging.atom.converter.Converter;
import org.apache.cxf.management.web.logging.atom.deliverer.Deliverer;

public final class AtomPushHandler
extends Handler {
    private AtomPushEngine engine;
    private boolean lazyConfig;

    public AtomPushHandler() {
        this.lazyConfig = true;
    }

    public AtomPushHandler(int batchSize, Converter converter, Deliverer deliverer) {
        this.engine = new AtomPushEngine();
        this.engine.setBatchSize(batchSize);
        this.engine.setConverter(converter);
        this.engine.setDeliverer(deliverer);
    }

    AtomPushHandler(AtomPushEngine engine) {
        this.engine = engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void publish(java.util.logging.LogRecord record) {
        if (LoggingThread.isSilent()) {
            return;
        }
        LoggingThread.markSilent(true);
        try {
            if (this.lazyConfig) {
                this.lazyConfig = false;
                this.configure();
            }
            LogRecord rec = LogRecord.fromJUL(record);
            this.engine.publish(rec);
        }
        finally {
            LoggingThread.markSilent(false);
        }
    }

    public synchronized void close() throws SecurityException {
        this.engine.shutdown();
    }

    public synchronized void flush() {
    }

    private void configure() {
        LogManager manager = LogManager.getLogManager();
        String cname = this.getClass().getName();
        AtomPushEngineConfigurator conf = new AtomPushEngineConfigurator();
        conf.setUrl(manager.getProperty(cname + ".url"));
        conf.setDelivererClass(manager.getProperty(cname + ".deliverer"));
        conf.setConverterClass(manager.getProperty(cname + ".converter"));
        conf.setBatchSize(manager.getProperty(cname + ".batchSize"));
        conf.setBatchCleanupTime(manager.getProperty(cname + ".batchCleanupTime"));
        conf.setRetryPause(manager.getProperty(cname + ".retry.pause"));
        conf.setRetryPauseTime(manager.getProperty(cname + ".retry.pause.time"));
        conf.setRetryTimeout(manager.getProperty(cname + ".retry.timeout"));
        conf.setOutput(manager.getProperty(cname + ".output"));
        conf.setMultiplicity(manager.getProperty(cname + ".multiplicity"));
        conf.setFormat(manager.getProperty(cname + ".format"));
        this.engine = conf.createEngine();
    }
}

