/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.web.logging.atom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.abdera.model.Element;
import org.apache.commons.lang.Validate;
import org.apache.cxf.management.web.logging.LogRecord;
import org.apache.cxf.management.web.logging.atom.LoggingThread;
import org.apache.cxf.management.web.logging.atom.converter.Converter;
import org.apache.cxf.management.web.logging.atom.deliverer.Deliverer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AtomPushEngine {
    private List<LogRecord> queue = new ArrayList<LogRecord>();
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    private int batchSize = 1;
    private int batchTime;
    private Converter converter;
    private Deliverer deliverer;
    private Timer timer;

    AtomPushEngine() {
    }

    public synchronized void publish(LogRecord record) {
        Validate.notNull((Object)record, (String)"record is null");
        if (this.isValid()) {
            if (this.batchSize > 1 && this.batchTime > 0 && this.timer == null) {
                this.createTimerTask(this.batchTime * 60 * 1000);
            }
            this.queue.add(record);
            if (this.queue.size() >= this.batchSize) {
                this.publishAndReset();
            }
        } else {
            this.handleUndeliveredRecords(Collections.singletonList(record), this.deliverer == null ? "" : this.deliverer.getEndpointAddress());
        }
    }

    protected synchronized void publishAndReset() {
        this.publishBatch(this.queue, this.deliverer, this.converter);
        this.queue = new ArrayList<LogRecord>();
    }

    public synchronized void shutdown() {
        this.cancelTimerTask();
        if (this.isValid() && this.queue.size() > 0) {
            this.publishAndReset();
        }
        this.executor.shutdown();
    }

    private boolean isValid() {
        if (this.deliverer == null) {
            return false;
        }
        if (this.converter == null) {
            return false;
        }
        return !this.executor.isShutdown();
    }

    private void publishBatch(final List<LogRecord> batch, final Deliverer d, final Converter c) {
        this.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    LoggingThread.markSilent(true);
                    List<? extends Element> elements = c.convert(batch);
                    for (int i = 0; i < elements.size(); ++i) {
                        Element element = elements.get(i);
                        if (d.deliver(element)) continue;
                        System.err.println("Delivery to " + d.getEndpointAddress() + " failed, shutting engine down");
                        List undelivered = null;
                        if (i == 0) {
                            undelivered = batch;
                        } else {
                            int index = batch.size() / elements.size() * i;
                            if (index < batch.size()) {
                                undelivered = batch.subList(index, batch.size());
                            }
                        }
                        AtomPushEngine.this.handleUndeliveredRecords(undelivered, d.getEndpointAddress());
                        AtomPushEngine.this.shutdown();
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    LoggingThread.markSilent(false);
                }
            }
        });
    }

    protected void handleUndeliveredRecords(List<LogRecord> records, String address) {
        System.err.println("The following records have been undelivered to " + address + " : ");
        for (LogRecord r : records) {
            System.err.println(r.toString());
        }
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        Validate.isTrue((batchSize > 0 ? 1 : 0) != 0, (String)"batch size is not greater than zero");
        this.batchSize = batchSize;
    }

    public void setBatchTime(int batchTime) {
        this.batchTime = batchTime;
    }

    protected void createTimerTask(long timeout) {
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            public void run() {
                AtomPushEngine.this.publishAndReset();
            }
        }, timeout);
    }

    protected void cancelTimerTask() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public synchronized Converter getConverter() {
        return this.converter;
    }

    public synchronized void setConverter(Converter converter) {
        Validate.notNull((Object)converter, (String)"converter is null");
        this.converter = converter;
    }

    public synchronized Deliverer getDeliverer() {
        return this.deliverer;
    }

    public synchronized void setDeliverer(Deliverer deliverer) {
        Validate.notNull((Object)deliverer, (String)"deliverer is null");
        this.deliverer = deliverer;
    }
}

