/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.web.browser.client.service.browser;

import com.google.gwt.xml.client.Document;
import com.google.gwt.xml.client.Node;
import com.google.gwt.xml.client.NodeList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Links {
    public static final Links EMPTY = new Links();
    @Nullable
    private String first;
    @Nullable
    private String previous;
    @Nullable
    private String self;
    @Nullable
    private String next;
    @Nullable
    private String last;

    private Links() {
    }

    public Links(@Nonnull Document document) {
        new XmlParser().parseLinks(document);
    }

    public boolean firstAvailable() {
        return this.available(this.first);
    }

    public boolean previousAvailable() {
        return this.available(this.previous);
    }

    public boolean selfAvailable() {
        return this.available(this.self);
    }

    public boolean nextAvailable() {
        return this.available(this.next);
    }

    public boolean lastAvailable() {
        return this.available(this.last);
    }

    @Nullable
    public String getFirst() {
        return this.first;
    }

    @Nullable
    public String getPrevious() {
        return this.previous;
    }

    @Nullable
    public String getSelf() {
        return this.self;
    }

    @Nullable
    public String getNext() {
        return this.next;
    }

    @Nullable
    public String getLast() {
        return this.last;
    }

    private boolean available(@Nullable String link) {
        return link != null && !"".equals(link);
    }

    private final class XmlParser {
        private static final String FEED_TAG = "feed";
        private static final String LINK_TAG = "link";
        private static final String TYPE_ATTRIBUTE = "rel";
        private static final String URL_ATTRIBUTE = "href";
        private static final String FIRST_LINK = "first";
        private static final String PREVIOUS_LINK = "previous";
        private static final String SELF_LINK = "self";
        private static final String NEXT_LINK = "next";
        private static final String LAST_LINK = "last";

        private XmlParser() {
        }

        private void parseLinks(@Nonnull Document document) {
            NodeList linkNodes = document.getElementsByTagName(LINK_TAG);
            if (linkNodes != null) {
                for (int i = 0; i < linkNodes.getLength(); ++i) {
                    Node linkNode = linkNodes.item(i);
                    if (!this.isLinkBelongToFeed(linkNode)) continue;
                    this.setLink(linkNode);
                }
            }
        }

        private boolean isLinkBelongToFeed(@Nonnull Node node) {
            return node.getParentNode() != null && FEED_TAG.equals(node.getParentNode().getNodeName());
        }

        private void setLink(@Nonnull Node node) {
            Node typeNode = node.getAttributes().getNamedItem(TYPE_ATTRIBUTE);
            Node urlNode = node.getAttributes().getNamedItem(URL_ATTRIBUTE);
            if (typeNode != null && urlNode != null) {
                String typeValue = typeNode.getNodeValue();
                String urlValue = urlNode.getNodeValue();
                if (FIRST_LINK.equals(typeValue)) {
                    Links.this.first = urlValue;
                } else if (PREVIOUS_LINK.equals(typeValue)) {
                    Links.this.previous = urlValue;
                } else if (SELF_LINK.equals(typeValue)) {
                    Links.this.self = urlValue;
                } else if (NEXT_LINK.equals(typeValue)) {
                    Links.this.next = urlValue;
                } else if (LAST_LINK.equals(typeValue)) {
                    Links.this.last = urlValue;
                }
            }
        }
    }
}

