/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.web.logging;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cxf.jaxrs.ext.search.SearchCondition;
import org.apache.cxf.management.web.logging.LogLevel;
import org.apache.cxf.management.web.logging.LogRecord;
import org.apache.cxf.management.web.logging.ReadableLogStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadOnlyFileStorage
implements ReadableLogStorage {
    public static final String LEVEL_PROPERTY = "level";
    public static final String DATE_PROPERTY = "date";
    public static final String MESSAGE_PROPERTY = "message";
    public static final String CATEGORY_PROPERTY = "category";
    public static final String THREAD_PROPERTY = "thread";
    public static final String DATE_ONLY_FORMAT = "yyyy-MM-dd";
    private static final String LINE_SEP = System.getProperty("line.separator");
    private static final String DEFAULT_COLUMN_SEP = "|";
    private String columnSep = "|";
    private int numberOfColumns;
    private boolean startsFromSeparator;
    private boolean endsWithSeparator;
    private SimpleDateFormat recordDateFormat;
    private boolean useFileModifiedDate;
    private Pattern fileNameDatePattern;
    private String fileNameDateFormat;
    private File logDirectory;
    private Comparator<String> fileNameComparator;
    private Map<Integer, String> columnsMap;
    private List<FileInfo> logFiles = new LinkedList<FileInfo>();
    private Map<String, String> levelsMap;
    private Map<Integer, PageInfo> pagesMap = new HashMap<Integer, PageInfo>();

    @Override
    public int getSize() {
        return -1;
    }

    @Override
    public synchronized int load(List<LogRecord> list, SearchCondition<LogRecord> condition, int pageNumber, int pageSize) {
        FileInfo logFileInfo = this.getLogFileInfo(pageNumber);
        if (logFileInfo == null) {
            return pageNumber;
        }
        int recordCount = 0;
        int currentIndex = 0;
        while (true) {
            LogRecord record;
            if ((record = this.readRecord(logFileInfo)) == null) {
                if ((logFileInfo = this.getNextLogFileInfo(logFileInfo, true)) != null) continue;
                return pageNumber;
            }
            if (condition == null || condition.isMet((Object)record)) {
                list.add(record);
                if (++recordCount == pageSize) break;
            }
            if (++currentIndex != pageSize) continue;
            ++pageNumber;
            recordCount = 0;
            currentIndex = 0;
        }
        this.saveNextPagePosition(pageNumber + 1, logFileInfo);
        return pageNumber;
    }

    private FileInfo getNextLogFileInfo(FileInfo logFileInfo, boolean firstTry) {
        for (int i = 0; i < this.logFiles.size(); ++i) {
            FileInfo fileInfo = this.logFiles.get(i);
            if (fileInfo != logFileInfo) continue;
            if (i + 1 >= this.logFiles.size()) break;
            return this.setFilePosition(this.logFiles.get(i + 1), this.logFiles.get(i + 1).getStartPosition());
        }
        if (firstTry && this.logDirectory != null && this.scanLogDirectory()) {
            return this.getNextLogFileInfo(logFileInfo, false);
        }
        return null;
    }

    private FileInfo setFilePosition(FileInfo fileInfo, long pos) {
        try {
            fileInfo.getFile().seek(pos);
            return fileInfo;
        }
        catch (IOException ex) {
            System.err.println("Problem setting a page position in " + fileInfo.getFileName());
            return null;
        }
    }

    private FileInfo getLogFileInfo(int pageNumber) {
        PageInfo pageInfo = this.pagesMap.get(pageNumber);
        if (pageInfo != null) {
            return this.setFilePosition(pageInfo.getFileInfo(), pageInfo.getPosition());
        }
        int oldSize = this.logFiles.size();
        if (this.logDirectory != null && this.scanLogDirectory()) {
            FileInfo fileInfo = this.logFiles.get(oldSize);
            this.saveNextPagePosition(pageNumber, fileInfo);
            return fileInfo;
        }
        return null;
    }

    private void saveNextPagePosition(int pageNumber, FileInfo fileInfo) {
        try {
            long pos = fileInfo.getFile().getFilePointer();
            if (pos < fileInfo.getFile().length()) {
                this.pagesMap.put(pageNumber, new PageInfo(fileInfo, pos));
            } else {
                FileInfo nextFileInfo = this.getNextLogFileInfo(fileInfo, false);
                if (nextFileInfo != null) {
                    this.pagesMap.put(pageNumber, new PageInfo(nextFileInfo, nextFileInfo.getFile().getFilePointer()));
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected LogRecord readRecord(FileInfo logFileInfo) {
        try {
            HashMap<Integer, String> map = new HashMap<Integer, String>(this.numberOfColumns);
            this.readTheLine(logFileInfo.getFile(), map, 1);
            return this.createRecord(map, logFileInfo);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected LogRecord createRecord(Map<Integer, String> map, FileInfo logFileInfo) {
        if (map.isEmpty()) {
            return null;
        }
        LogRecord record = new LogRecord();
        for (Map.Entry<Integer, String> entry : map.entrySet()) {
            String propertyName = this.columnsMap.get(entry.getKey());
            if (LEVEL_PROPERTY.equals(propertyName)) {
                this.setLogRecordLevel(record, entry.getValue());
                continue;
            }
            if (DATE_PROPERTY.equals(propertyName)) {
                this.setLogRecordDate(record, entry.getValue(), logFileInfo);
                continue;
            }
            if (MESSAGE_PROPERTY.equals(propertyName)) {
                record.setMessage(entry.getValue());
                continue;
            }
            if (CATEGORY_PROPERTY.equals(propertyName)) {
                record.setLoggerName(entry.getValue());
                continue;
            }
            if (!THREAD_PROPERTY.equals(propertyName)) continue;
            record.setThreadName(entry.getValue());
        }
        return record;
    }

    protected void setLogRecordLevel(LogRecord record, String logLevel) {
        if (this.levelsMap != null) {
            logLevel = this.levelsMap.get(logLevel);
        }
        if (logLevel != null) {
            record.setLevel(LogLevel.valueOf(logLevel));
        }
    }

    protected void setLogRecordDate(LogRecord record, String logDate, FileInfo logFileInfo) {
        if (this.recordDateFormat != null) {
            try {
                String fileModifiedDate = logFileInfo.getFileModified();
                logDate = fileModifiedDate != null ? fileModifiedDate + " " + logDate : logDate;
                Date date = this.recordDateFormat.parse(logDate);
                record.setDate(date);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    protected void readTheLine(RandomAccessFile logFile, Map<Integer, String> map, int columnIndex) throws IOException {
        long nextPos = logFile.getFilePointer();
        if (nextPos >= logFile.length()) {
            return;
        }
        String line = logFile.readLine();
        int lastIndex = 0;
        if (columnIndex == 1 && this.startsFromSeparator) {
            lastIndex = 1;
        }
        Set<Integer> requestedColumns = this.columnsMap.keySet();
        int startingColumn = columnIndex;
        while (lastIndex < line.length()) {
            int actualIndex;
            int sepIndex = line.indexOf(this.columnSep, lastIndex);
            if (sepIndex != -1 && startingColumn == this.numberOfColumns && !this.endsWithSeparator) {
                logFile.seek(nextPos);
                return;
            }
            int n = actualIndex = sepIndex == -1 ? line.length() : sepIndex;
            if (requestedColumns.contains(columnIndex)) {
                String value = line.substring(lastIndex, actualIndex).trim();
                String existingValue = map.get(columnIndex);
                map.put(columnIndex, existingValue == null ? value : existingValue + LINE_SEP + value);
            }
            lastIndex = actualIndex + 1;
            if (sepIndex == -1 || columnIndex == this.numberOfColumns) continue;
            ++columnIndex;
        }
        if (columnIndex == this.numberOfColumns) {
            this.readTheLine(logFile, map, columnIndex);
        }
    }

    public void setColumnSep(String columnSep) {
        this.columnSep = columnSep;
    }

    public void setNumberOfColumns(String number) {
        this.numberOfColumns = Integer.parseInt(number);
    }

    public void setColumnsMap(Map<Integer, String> columnsMap) {
        this.columnsMap = columnsMap;
    }

    public void setLogLocations(List<String> locations) {
        this.logFiles = new LinkedList<FileInfo>();
        for (int i = 0; i < locations.size(); ++i) {
            String realPath = this.getRealLocation(locations.get(i));
            try {
                this.processNewLogFile(new File(realPath));
                continue;
            }
            catch (IOException ex) {
                throw new RuntimeException("The log file " + realPath + " can not be opened: " + ex.getMessage());
            }
        }
    }

    private void processNewLogFile(File file) throws IOException {
        RandomAccessFile logFile = new RandomAccessFile(file, "r");
        String fileModifiedDate = null;
        if (this.useFileModifiedDate) {
            if (this.fileNameDatePattern != null) {
                fileModifiedDate = this.getDateFromFileName(file.getName());
            }
            if (fileModifiedDate == null) {
                Date fileDate = new Date(file.lastModified());
                fileModifiedDate = this.getLogDateFormat().format(fileDate);
            }
        }
        this.skipIgnorableRecords(logFile);
        FileInfo fileInfo = new FileInfo(logFile, file.getName(), fileModifiedDate, logFile.getFilePointer());
        if (this.logFiles.size() == 0) {
            this.pagesMap.put(1, new PageInfo(fileInfo, fileInfo.getStartPosition()));
        }
        this.logFiles.add(fileInfo);
    }

    private String getDateFromFileName(String name) {
        Matcher m = this.fileNameDatePattern.matcher(name);
        if (m.matches() && m.groupCount() > 0) {
            return m.group(1);
        }
        return null;
    }

    private SimpleDateFormat getLogDateFormat() {
        String format = this.fileNameDateFormat == null ? DATE_ONLY_FORMAT : this.fileNameDateFormat;
        return new SimpleDateFormat(format);
    }

    private String getRealLocation(String location) {
        int indexOpen = location.indexOf("{");
        int indexClose = location.indexOf("}");
        String realPath = null;
        if (indexOpen == 0 && indexClose != -1) {
            String property = location.substring(1, indexClose);
            String resolvedPath = System.getProperty(property);
            if (resolvedPath == null) {
                throw new IllegalArgumentException("System property " + property + " can not be resolved");
            }
            realPath = resolvedPath + location.substring(indexClose + 1);
        } else {
            realPath = location;
        }
        return realPath;
    }

    public void setLogLocation(String location) {
        String realPath = this.getRealLocation(location);
        File file = new File(realPath);
        if (file.isDirectory()) {
            this.logDirectory = file;
        } else {
            this.setLogLocations(Collections.singletonList(realPath));
        }
    }

    private void skipIgnorableRecords(RandomAccessFile file) throws IOException {
        long nextPos = file.getFilePointer();
        if (nextPos == file.length()) {
            return;
        }
        String line = file.readLine();
        if (line.contains(this.columnSep)) {
            file.seek(nextPos);
        } else {
            this.skipIgnorableRecords(file);
        }
    }

    public void setRecordDateFormat(String format) {
        this.recordDateFormat = new SimpleDateFormat(format);
    }

    public void setLevelsMap(Map<String, String> map) {
        this.levelsMap = map;
    }

    public void setFileNameComparator(Comparator<String> comp) {
        this.fileNameComparator = comp;
    }

    @Override
    public void close() {
        for (FileInfo fileInfo : this.logFiles) {
            try {
                fileInfo.getFile().close();
            }
            catch (IOException iOException) {}
        }
    }

    public void setUseFileModifiedDate(boolean useFileModifiedDate) {
        this.useFileModifiedDate = useFileModifiedDate;
    }

    private boolean scanLogDirectory() {
        int oldSize = this.logFiles.size();
        for (File file : this.logDirectory.listFiles()) {
            if (file.isDirectory() || file.isHidden() || this.fileNameDatePattern != null && this.getDateFromFileName(file.getName()) == null) continue;
            boolean isNew = true;
            for (FileInfo fInfo : this.logFiles) {
                if (!fInfo.getFileName().equalsIgnoreCase(file.getName())) continue;
                isNew = false;
                break;
            }
            if (!isNew) continue;
            try {
                this.processNewLogFile(file);
            }
            catch (IOException ex) {
                System.out.println("Log file " + file.getName() + " can not be opened");
            }
        }
        if (this.logFiles.size() > oldSize) {
            Collections.sort(this.logFiles, new FileInfoComparator());
            return true;
        }
        return false;
    }

    public void setFileNameDatePattern(String fileNameDatePattern) {
        this.fileNameDatePattern = Pattern.compile(fileNameDatePattern);
    }

    public void setFileNameDateFormat(String fileNameDateFormat) {
        this.fileNameDateFormat = fileNameDateFormat;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class FileInfoComparator
    implements Comparator<FileInfo> {
        protected FileInfoComparator() {
        }

        @Override
        public int compare(FileInfo info1, FileInfo info2) {
            if (ReadOnlyFileStorage.this.useFileModifiedDate && ReadOnlyFileStorage.this.fileNameDatePattern != null) {
                SimpleDateFormat dateFormat = ReadOnlyFileStorage.this.getLogDateFormat();
                try {
                    Date date1 = dateFormat.parse(info1.getFileModified());
                    Date date2 = dateFormat.parse(info2.getFileModified());
                    return date1.compareTo(date2);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            String name1 = info1.getFileName();
            String name2 = info2.getFileName();
            if (ReadOnlyFileStorage.this.fileNameComparator != null) {
                return ReadOnlyFileStorage.this.fileNameComparator.compare(name1, name2);
            }
            Integer logIndex1 = this.getLogIndex(name1);
            Integer logIndex2 = this.getLogIndex(name2);
            return logIndex1.compareTo(logIndex2) * -1;
        }

        private int getLogIndex(String name) {
            int index = name.lastIndexOf(46);
            try {
                return Integer.valueOf(name.substring(index + 1));
            }
            catch (Exception ex) {
                return 0;
            }
        }
    }

    protected static class FileInfo {
        private RandomAccessFile file;
        private String fileModified;
        private String fileName;
        private long startPosition;

        public FileInfo(RandomAccessFile file, String fileName, String fileModified, long startPos) {
            this.file = file;
            this.fileModified = fileModified;
            this.fileName = fileName;
            this.startPosition = startPos;
        }

        public RandomAccessFile getFile() {
            return this.file;
        }

        public String getFileModified() {
            return this.fileModified;
        }

        public String getFileName() {
            return this.fileName;
        }

        public long getStartPosition() {
            return this.startPosition;
        }
    }

    protected static class PageInfo {
        private FileInfo fileInfo;
        private long pos;

        public PageInfo(FileInfo fileInfo, long pos) {
            this.fileInfo = fileInfo;
            this.pos = pos;
        }

        public FileInfo getFileInfo() {
            return this.fileInfo;
        }

        public long getPosition() {
            return this.pos;
        }
    }
}

