/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.web.logging.atom;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Handler;
import java.util.logging.Logger;
import org.apache.commons.lang.Validate;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.management.web.logging.LogLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAtomBean {
    private List<LoggerLevel> loggers = new ArrayList<LoggerLevel>();
    private boolean initialized;
    private Bus bus;

    public AbstractAtomBean() {
        this.initSingleLogger();
    }

    private void initSingleLogger() {
        this.loggers = new ArrayList<LoggerLevel>();
        this.loggers.add(new LoggerLevel("", "INFO"));
    }

    public void setBus(Bus bus) {
        this.bus = bus;
    }

    public Bus getBus() {
        return this.bus;
    }

    public void setLoggers(String loggers) {
        this.checkInit();
        Validate.notNull((Object)loggers, (String)"loggers is null");
        this.parseLoggers(loggers);
    }

    public void setLogger(String logger) {
        this.checkInit();
        Validate.notNull((Object)logger, (String)"logger is null");
        if (this.loggers.size() != 1) {
            this.initSingleLogger();
        }
        this.loggers.get(0).setLogger(logger);
    }

    public void setLevel(String level) {
        this.checkInit();
        Validate.notNull((Object)level, (String)"level is null");
        if (this.loggers.size() != 1) {
            this.initSingleLogger();
        }
        this.loggers.get(0).setLevel(level);
    }

    public void init() {
        this.checkInit();
        this.initialized = true;
        Handler h = this.createHandler();
        for (int i = 0; i < this.loggers.size(); ++i) {
            Logger l = LogUtils.getL7dLogger(AbstractAtomBean.class, null, (String)this.loggers.get(i).getLogger());
            l.addHandler(h);
            l.setLevel(LogLevel.toJUL(LogLevel.valueOf(this.loggers.get(i).getLevel())));
        }
    }

    protected abstract Handler createHandler();

    protected void checkInit() {
        if (this.initialized) {
            throw new IllegalStateException("Bean is already initialized");
        }
    }

    private void parseLoggers(String param) {
        this.loggers = new ArrayList<LoggerLevel>();
        StringTokenizer st1 = new StringTokenizer(param, ", \t\n\r\f");
        while (st1.hasMoreTokens()) {
            String tok = st1.nextToken();
            int idx = tok.indexOf(":");
            if (idx != -1) {
                this.loggers.add(new LoggerLevel(tok.substring(0, idx), tok.substring(idx + 1, tok.length())));
                continue;
            }
            this.loggers.add(new LoggerLevel(tok, "INFO"));
        }
    }

    protected List<LoggerLevel> getLoggers() {
        return this.loggers;
    }

    protected static class LoggerLevel {
        private String logger;
        private String level;

        public LoggerLevel(String logger, String level) {
            this.logger = logger;
            this.level = level;
        }

        public String getLogger() {
            return this.logger;
        }

        public void setLogger(String logger) {
            this.logger = logger;
        }

        public String getLevel() {
            return this.level;
        }

        public void setLevel(String level) {
            this.level = level;
        }
    }
}

