/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.web.browser.client.service.browser;

import com.google.gwt.xml.client.Document;
import com.google.gwt.xml.client.Node;
import com.google.gwt.xml.client.NodeList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.cxf.management.web.browser.client.service.browser.Entry;
import org.apache.cxf.management.web.browser.client.service.browser.Links;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Feed {
    public static final Feed EMPTY = new Feed();
    @Nonnull
    private final List<Entry> entries = new ArrayList<Entry>();
    @Nonnull
    private final Links links;

    private Feed() {
        this.links = Links.EMPTY;
    }

    public Feed(@Nonnull Document document) {
        new XmlParser().parseEntries(document);
        this.links = new Links(document);
    }

    @Nonnull
    public List<Entry> getEntries() {
        return this.entries;
    }

    @Nonnull
    public Links getLinks() {
        return this.links;
    }

    private final class XmlParser {
        private static final String ENTRY_TAG = "entry";

        private XmlParser() {
        }

        private void parseEntries(@Nonnull Document document) {
            NodeList entryNodes = document.getElementsByTagName(ENTRY_TAG);
            if (entryNodes != null) {
                for (int i = 0; i < entryNodes.getLength(); ++i) {
                    Node entryNode = entryNodes.item(i);
                    assert (entryNode != null);
                    if (entryNode.getNodeType() != 1) continue;
                    Feed.this.entries.add(new Entry(entryNodes.item(i)));
                }
                Collections.reverse(Feed.this.entries);
            }
        }
    }
}

