/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.web.browser.bootstrapping;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang.Validate;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.provider.json.JSONProvider;
import org.apache.cxf.management.web.browser.bootstrapping.Settings;
import org.apache.cxf.management.web.browser.bootstrapping.SettingsStorage;

@Path(value="/browser")
public class BootstrapStorage {
    private static final Logger LOGGER = LogUtils.getL7dLogger(BootstrapStorage.class);
    private final SettingsStorage storage;

    public BootstrapStorage(SettingsStorage storage) {
        Validate.notNull((Object)storage, (String)"provider is null");
        this.storage = storage;
    }

    @GET
    @Path(value="/settings")
    @Produces(value={"application/json"})
    public Settings getSettings() {
        String username = "admin";
        Validate.notNull((Object)username, (String)"username is null");
        Validate.notEmpty((String)username, (String)"username is empty");
        LOGGER.fine(String.format("Retrieve settings, user='%s'", username));
        return this.storage.getSettings(username);
    }

    @PUT
    @Path(value="/settings")
    @Consumes(value={"application/json"})
    public Response setSettings(Settings settings) {
        String username = "admin";
        Validate.notNull((Object)username, (String)"username is null");
        Validate.notEmpty((String)username, (String)"username is empty");
        Validate.notNull((Object)settings, (String)"settings is null");
        LOGGER.fine(String.format("Save settings, user='%s'; settings='%s'", username, settings));
        this.storage.setSettings(username, settings);
        return Response.ok().build();
    }

    @GET
    @Path(value="{resource:.*}")
    public Response getResource(@Context MessageContext mc, @PathParam(value="resource") String resource) {
        if (this.isLastModifiedRequest(mc)) {
            return Response.notModified().build();
        }
        try {
            URL jar = this.getClass().getProtectionDomain().getCodeSource().getLocation();
            URL url = new URL(String.format("jar:%s!/static-content/logbrowser/%s", jar, resource));
            JarURLConnection connection = (JarURLConnection)url.openConnection();
            if (connection.getContentLength() == -1 || connection.getJarEntry() == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (connection.getJarEntry().isDirectory()) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            MediaType mime = this.getMimeType(mc, resource);
            StaticFile staticFile = new StaticFile(url, this.acceptsGzip(mc), mime);
            Response.ResponseBuilder builder = Response.ok((Object)staticFile);
            builder.variant(new Variant(mime, (Locale)null, staticFile.isGzipEnabled() ? "gzip" : null));
            return builder.build();
        }
        catch (MalformedURLException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Error occur while retrieve static file", e);
            return Response.serverError().build();
        }
    }

    private boolean isLastModifiedRequest(MessageContext mc) {
        return mc.getHttpServletRequest().getHeader("Last-Modified") != null;
    }

    private MediaType getMimeType(MessageContext mc, String resource) {
        return MediaType.valueOf((String)mc.getServletContext().getMimeType(resource));
    }

    private boolean acceptsGzip(MessageContext mc) {
        String ae = mc.getHttpServletRequest().getHeader("Accept-Encoding");
        return ae != null && ae.contains("gzip");
    }

    @Provider
    public static class SettingsProvider
    extends JSONProvider<Object> {
        private static final String LOGGING_NAMESPACE = "http://cxf.apache.org/log";
        private static final String SUBSCRIPTIONS_ARRAY = "subscriptions";

        public SettingsProvider() {
            this.setIgnoreNamespaces(true);
            this.setSerializeAsArray(true);
            this.setArrayKeys(Arrays.asList(SUBSCRIPTIONS_ARRAY));
            this.setOutTransformElements(new HashMap<String, String>(){
                private static final long serialVersionUID = -1341932955817405356L;
                {
                    this.put("{http://cxf.apache.org/log}*", "*");
                }
            });
            this.setInTransformElements(new HashMap<String, String>(){
                private static final long serialVersionUID = -1509522821399368946L;
                {
                    this.put("*", "{http://cxf.apache.org/log}*");
                }
            });
        }
    }

    @Provider
    public static class StaticFileProvider
    implements MessageBodyWriter<StaticFile> {
        public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return StaticFile.class.isAssignableFrom(type);
        }

        public long getSize(StaticFile staticFile, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return -1L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeTo(StaticFile staticFile, Class<?> clazz, Type genericType, Annotation[] annotations, MediaType type, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException {
            if (staticFile.isGzipEnabled()) {
                GZIPOutputStream gzip = new GZIPOutputStream(os);
                try {
                    IOUtils.copyAndCloseInput((InputStream)staticFile.getUrl().openStream(), (OutputStream)gzip);
                }
                finally {
                    gzip.finish();
                }
            } else {
                IOUtils.copyAndCloseInput((InputStream)staticFile.getUrl().openStream(), (OutputStream)os);
            }
        }
    }

    private final class StaticFile {
        private URL url;
        private boolean isGzipEnabled;

        private StaticFile(URL url, boolean acceptsGzip, MediaType mime) {
            assert (url != null);
            assert (mime != null);
            this.url = url;
            this.isGzipEnabled = acceptsGzip && "text".equals(mime.getType());
        }

        public URL getUrl() {
            return this.url;
        }

        public boolean isGzipEnabled() {
            return this.isGzipEnabled;
        }
    }
}

