/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.web.logging.atom;

import java.lang.reflect.Constructor;
import org.apache.cxf.management.web.logging.atom.AtomPushEngine;
import org.apache.cxf.management.web.logging.atom.converter.Converter;
import org.apache.cxf.management.web.logging.atom.converter.StandardConverter;
import org.apache.cxf.management.web.logging.atom.deliverer.Deliverer;
import org.apache.cxf.management.web.logging.atom.deliverer.RetryingDeliverer;
import org.apache.cxf.management.web.logging.atom.deliverer.WebClientDeliverer;

final class AtomPushEngineConfigurator {
    private Deliverer deliverer;
    private Converter converter;
    private String delivererClass;
    private String converterClass;
    private String batchSize;
    private String batchCleanupTime;
    private String delivererUrl;
    private String retryTimeout;
    private String retryPause;
    private String retryPauseTime;
    private String output;
    private String multiplicity;
    private String format;

    AtomPushEngineConfigurator() {
    }

    public void setUrl(String url) {
        this.delivererUrl = url;
    }

    public void setRetryTimeout(String retryTimeout) {
        this.retryTimeout = retryTimeout;
    }

    public void setRetryPause(String retryPause) {
        this.retryPause = retryPause;
    }

    public void setRetryPauseTime(String retryPauseTime) {
        this.retryPauseTime = retryPauseTime;
    }

    public void setBatchCleanupTime(String cleanupTime) {
        this.batchCleanupTime = cleanupTime;
    }

    public void setBatchSize(String batchSize) {
        this.batchSize = batchSize;
    }

    public void setDeliverer(Deliverer deliverer) {
        this.deliverer = deliverer;
    }

    public void setConverter(Converter converter) {
        this.converter = converter;
    }

    public void setDelivererClass(String delivererClass) {
        this.delivererClass = delivererClass;
    }

    public void setConverterClass(String converterClass) {
        this.converterClass = converterClass;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public void setMultiplicity(String multiplicity) {
        this.multiplicity = multiplicity;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public AtomPushEngine createEngine() {
        Deliverer d = this.deliverer;
        Converter c = this.converter;
        int batch = this.parseInt(this.batchSize, 1, 1);
        int batchTime = this.parseInt(this.batchCleanupTime, 0);
        if (d == null) {
            if (this.delivererUrl != null) {
                d = this.delivererClass != null ? this.createDeliverer(this.delivererClass, this.delivererUrl) : new WebClientDeliverer(this.delivererUrl);
            } else {
                throw new IllegalStateException("Either url, deliverer or deliverer class with url must be setup");
            }
        }
        if (c == null) {
            if (this.converterClass != null) {
                c = this.createConverter(this.converterClass);
            } else {
                StandardConverter.Output out = this.parseEnum(this.output, StandardConverter.Output.FEED, StandardConverter.Output.class);
                StandardConverter.Multiplicity defaultMul = out == StandardConverter.Output.FEED ? StandardConverter.Multiplicity.MANY : (batch > 1 ? StandardConverter.Multiplicity.MANY : StandardConverter.Multiplicity.ONE);
                StandardConverter.Multiplicity mul = this.parseEnum(this.multiplicity, defaultMul, StandardConverter.Multiplicity.class);
                StandardConverter.Format form = this.parseEnum(this.format, StandardConverter.Format.CONTENT, StandardConverter.Format.class);
                c = out == StandardConverter.Output.FEED ? new StandardConverter(out, mul, form) : new StandardConverter(out, mul, form);
                if (this.retryPause != null) {
                    int timeout = this.parseInt(this.retryTimeout, 0, 0);
                    int pause = this.parseInt(this.retryPauseTime, 1, 30);
                    boolean linear = !this.retryPause.equalsIgnoreCase("exponential");
                    d = new RetryingDeliverer(d, timeout, pause, linear);
                }
            }
        }
        AtomPushEngine engine = new AtomPushEngine();
        engine.setDeliverer(d);
        engine.setConverter(c);
        engine.setBatchSize(batch);
        engine.setBatchTime(batchTime);
        return engine;
    }

    private Deliverer createDeliverer(String clazz, String url) {
        try {
            Constructor<Deliverer> ctor = this.loadClass(clazz, Deliverer.class).getConstructor(String.class);
            return ctor.newInstance(url);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private Converter createConverter(String clazz) {
        try {
            Constructor<Converter> ctor = this.loadClass(clazz, Converter.class).getConstructor(new Class[0]);
            return ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private <T> Class<T> loadClass(String clazz, Class<T> ifaceClass) throws ClassNotFoundException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            return cl.loadClass(clazz);
        }
        catch (ClassNotFoundException e) {
            try {
                String pkg = ifaceClass.getPackage().getName();
                String clazz2 = pkg + "." + clazz;
                return cl.loadClass(clazz2);
            }
            catch (Exception e1) {
                throw new ClassNotFoundException(e.getMessage() + " or " + e1.getMessage());
            }
        }
    }

    private int parseInt(String property, int defaultValue) {
        try {
            return Integer.parseInt(property);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private int parseInt(String property, int lessThan, int defaultValue) {
        int ret = this.parseInt(property, defaultValue);
        if (ret < lessThan) {
            ret = defaultValue;
        }
        return ret;
    }

    private <T extends Enum<T>> T parseEnum(String value, T defaultValue, Class<T> enumClass) {
        if (value == null | "".equals(value)) {
            return defaultValue;
        }
        try {
            return Enum.valueOf(enumClass, value.toUpperCase());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }
}

