/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.web.browser.client.ui.browser;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.http.client.Request;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import javax.annotation.Nonnull;
import org.apache.cxf.management.web.browser.client.event.SelectedSubscriptionEvent;
import org.apache.cxf.management.web.browser.client.event.SelectedSubscriptionEventHandler;
import org.apache.cxf.management.web.browser.client.service.browser.Feed;
import org.apache.cxf.management.web.browser.client.service.browser.FeedProxyImpl;
import org.apache.cxf.management.web.browser.client.ui.BasePresenter;
import org.apache.cxf.management.web.browser.client.ui.BindStrategy;
import org.apache.cxf.management.web.browser.client.ui.browser.ViewerView;
import org.apache.cxf.management.web.browser.client.ui.resources.LogBrowserConstans;
import org.apache.cxf.management.web.browser.client.ui.resources.LogBrowserResources;

@Singleton
public class ViewerPresenter
extends BasePresenter
implements ViewerView.Presenter {
    @Nonnull
    private final FeedProxyImpl proxy;
    @Nonnull
    private Feed feed;
    @Nonnull
    private final ViewerView view;
    @Nonnull
    private final LogBrowserConstans constans;
    @Nonnull
    private final LogBrowserResources resources;

    @Inject
    public ViewerPresenter(@Nonnull EventBus eventBus, @Nonnull ViewerView view, @Nonnull @Named(value="BindStrategyForViewer") BindStrategy bindStrategy, @Nonnull FeedProxyImpl proxy, @Nonnull LogBrowserConstans constans, @Nonnull LogBrowserResources resources) {
        super(eventBus, view, bindStrategy);
        this.view = view;
        this.view.setPresenter(this);
        this.proxy = proxy;
        this.constans = constans;
        this.resources = resources;
        this.setFeed(Feed.EMPTY);
        this.bind();
    }

    private void bind() {
        this.eventBus.addHandler(SelectedSubscriptionEvent.TYPE, (EventHandler)new SelectedSubscriptionEventHandler(){

            @Override
            public void onSelectedSubscription(SelectedSubscriptionEvent event) {
                ViewerPresenter.this.getFeed(event.getUrl());
            }
        });
    }

    @Override
    public void onEntryItemClicked(int row) {
        assert (row >= 0 && row < this.feed.getEntries().size());
        this.view.setEntryDetails(this.feed.getEntries().get(row));
    }

    @Override
    public void onNewerButtonClicked() {
        this.getFeed(this.feed.getLinks().getNext());
    }

    @Override
    public void onLastButtonClicked() {
        this.getFeed(this.feed.getLinks().getLast());
    }

    @Override
    public void onFirstButtonClicked() {
        this.getFeed(this.feed.getLinks().getFirst());
    }

    @Override
    public void onRefreshButtonClicked() {
        this.getFeed(this.feed.getLinks().getSelf());
    }

    @Override
    public void onOlderButtonClicked() {
        this.getFeed(this.feed.getLinks().getPrevious());
    }

    private void setFeed(@Nonnull Feed newFeed) {
        this.feed = newFeed;
        this.view.setEntryDetails(null);
        this.view.setLinks(this.feed.getLinks());
        if (this.feed.getEntries().isEmpty()) {
            this.setNoEntriesMessage();
        } else {
            this.view.setEntries(this.feed.getEntries());
        }
    }

    private void setNoEntriesMessage() {
        this.view.setMessageInsteadOfEntries(this.constans.browserTabNoEntries(), this.resources.css().browserTabNoEntriesMessage());
    }

    private void setLoadingMessage() {
        this.view.setMessageInsteadOfEntries(this.constans.browserTabLoading(), this.resources.css().browserTabLoadingMessage());
    }

    private void getFeed(@Nonnull String url) {
        this.setLoadingMessage();
        this.proxy.getFeed(url, new FeedProxyImpl.Callback(){

            @Override
            public void onSuccess(@Nonnull Feed newFeed) {
                ViewerPresenter.this.setFeed(newFeed);
            }

            @Override
            public void onError(@Nonnull Request request, @Nonnull Throwable ex) {
                ViewerPresenter.this.setFeed(Feed.EMPTY);
                super.onError(request, ex);
            }
        });
    }
}

