/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.web.browser.bootstrapping;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang.Validate;
import org.apache.cxf.management.web.browser.bootstrapping.Settings;
import org.apache.cxf.management.web.browser.bootstrapping.SettingsStorage;
import org.apache.cxf.management.web.browser.bootstrapping.Subscription;

public class SimpleXMLSettingsStorage
implements SettingsStorage {
    private static final String DEFAULT_FILENAME = "logbrowser-settings.xml";
    private static final Settings DEFAULT_SETTINGS = new Settings();
    private final String filename;
    private final Marshaller marshaller;
    private Entries entries;

    public SimpleXMLSettingsStorage() {
        this(DEFAULT_FILENAME);
    }

    public SimpleXMLSettingsStorage(String filename) {
        Validate.notNull((Object)filename, (String)"filename is null");
        Validate.notEmpty((String)filename, (String)"filename is empty");
        this.filename = filename;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Entries.class, Entry.class, Settings.class, Subscription.class});
            this.marshaller = context.createMarshaller();
            this.marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            File file = new File(filename);
            if (file.exists()) {
                Unmarshaller unmarshaller = context.createUnmarshaller();
                this.entries = (Entries)unmarshaller.unmarshal(file);
            }
            if (this.entries == null) {
                this.entries = new Entries();
            }
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized Settings getSettings(String username) {
        Validate.notNull((Object)username, (String)"username is null");
        Validate.notEmpty((String)username, (String)"username is empty");
        Entry entry = this.getCachedEntry(username);
        return entry != null ? entry.getSettings() : DEFAULT_SETTINGS;
    }

    @Override
    public synchronized void setSettings(String username, Settings settings) {
        Validate.notNull((Object)username, (String)"username is null");
        Validate.notEmpty((String)username, (String)"username is empty");
        Entry entry = this.getCachedEntry(username);
        if (entry != null) {
            entry.setSettings(settings);
            entry.setModified(this.getCurrentTime());
        } else {
            this.entries.getEntries().add(new Entry(username, this.getCurrentTime(), settings));
        }
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(this.filename);
            this.marshaller.marshal((Object)this.entries, (OutputStream)outputStream);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private Entry getCachedEntry(String username) {
        assert (username != null);
        assert (!"".equals(username));
        for (Entry entry : this.entries.getEntries()) {
            if (!username.equals(entry.getUsername())) continue;
            return entry;
        }
        return null;
    }

    private XMLGregorianCalendar getCurrentTime() {
        try {
            return DatatypeFactory.newInstance().newXMLGregorianCalendar((GregorianCalendar)GregorianCalendar.getInstance());
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    @XmlRootElement(namespace="http://cxf.apache.org/log")
    private static class Entry {
        private Settings settings;
        private String username;
        private XMLGregorianCalendar modified;

        private Entry() {
        }

        Entry(String username, XMLGregorianCalendar modified, Settings settings) {
            this.settings = settings;
            this.username = username;
            this.modified = modified;
        }

        @XmlElement(required=true, namespace="http://cxf.apache.org/log")
        public Settings getSettings() {
            return this.settings;
        }

        public void setSettings(Settings value) {
            this.settings = value;
        }

        @XmlAttribute(name="username", namespace="http://cxf.apache.org/log")
        public String getUsername() {
            return this.username;
        }

        public void setUsername(String value) {
            this.username = value;
        }

        @XmlAttribute(name="modified", namespace="http://cxf.apache.org/log")
        @XmlSchemaType(name="date")
        public XMLGregorianCalendar getModified() {
            return this.modified;
        }

        public void setModified(XMLGregorianCalendar value) {
            this.modified = value;
        }
    }

    @XmlRootElement(namespace="http://cxf.apache.org/log")
    private static class Entries {
        private List<Entry> entries;

        private Entries() {
        }

        @XmlElement(name="entry", namespace="http://cxf.apache.org/log")
        public List<Entry> getEntries() {
            if (this.entries == null) {
                this.entries = new ArrayList<Entry>();
            }
            return this.entries;
        }
    }
}

