/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.web.browser.client.ui.settings;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.uibinder.client.UiTemplate;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DecoratedTabPanel;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.google.inject.Singleton;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.cxf.management.web.browser.client.service.settings.Subscription;
import org.apache.cxf.management.web.browser.client.ui.settings.SettingsView;

@Singleton
public class SettingsViewImpl
extends Composite
implements SettingsView {
    private static final SettingsViewUiBinder UI_BINDER = (SettingsViewUiBinder)GWT.create(SettingsViewUiBinder.class);
    @UiField
    @Nonnull
    DecoratedTabPanel tabPanel;
    @UiField
    @Nonnull
    FlowPanel navigationHeaderSlot;
    @UiField
    @Nonnull
    FlexTable subscriptionsTable;
    @Nullable
    private SettingsView.Presenter presenter;

    public SettingsViewImpl() {
        this.initWidget((Widget)UI_BINDER.createAndBindUi(this));
        this.tabPanel.selectTab(0);
    }

    @Override
    public HasWidgets getNaviagationHeaderSlot() {
        return this.navigationHeaderSlot;
    }

    @Override
    public void setData(@Nonnull List<Subscription> subscriptions) {
        this.subscriptionsTable.clear();
        int row = 0;
        for (final Subscription subscription : subscriptions) {
            SubscriptionEntry subscriptionEntry = new SubscriptionEntry();
            subscriptionEntry.nameLabel.setText(subscription.getName());
            subscriptionEntry.urlLabel.setText(subscription.getUrl());
            subscriptionEntry.editButton.addClickHandler(new ClickHandler(){

                public void onClick(@Nonnull ClickEvent event) {
                    assert (SettingsViewImpl.this.presenter != null);
                    SettingsViewImpl.this.presenter.onEditSubscriptionButtonClicked(subscription);
                }
            });
            subscriptionEntry.removeButton.addClickHandler(new ClickHandler(){

                public void onClick(@Nonnull ClickEvent event) {
                    assert (SettingsViewImpl.this.presenter != null);
                    SettingsViewImpl.this.presenter.onRemoveSubscriptionButtonClicked(subscription);
                }
            });
            this.subscriptionsTable.setWidget(row, 0, (Widget)subscriptionEntry);
            ++row;
        }
    }

    @UiHandler(value={"backHyperlink"})
    void onBackHyperlinkClicked(@Nonnull ClickEvent event) {
        assert (this.presenter != null);
        this.presenter.onBackHyperlinkClicked();
    }

    @UiHandler(value={"addSubscriptionButton"})
    void onAddSubscriptionButtonClicked(@Nonnull ClickEvent event) {
        assert (this.presenter != null);
        this.presenter.onAddSubscriptionButtonClicked();
    }

    @Override
    public void setPresenter(@Nonnull SettingsView.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    @Nonnull
    public Widget asWidget() {
        return this;
    }

    protected static class SubscriptionEntry
    extends Composite {
        private static final SubscriptionEntryUiBinder UI_BINDER = (SubscriptionEntryUiBinder)GWT.create(SubscriptionEntryUiBinder.class);
        @UiField
        @Nonnull
        Label nameLabel;
        @UiField
        @Nonnull
        Label urlLabel;
        @UiField
        @Nonnull
        Button editButton;
        @UiField
        @Nonnull
        Button removeButton;

        public SubscriptionEntry() {
            this.initWidget((Widget)UI_BINDER.createAndBindUi((Object)this));
        }

        @UiTemplate(value="SubscriptionEntry.ui.xml")
        static interface SubscriptionEntryUiBinder
        extends UiBinder<Widget, SubscriptionEntry> {
        }
    }

    @UiTemplate(value="SettingsView.ui.xml")
    static interface SettingsViewUiBinder
    extends UiBinder<Widget, SettingsViewImpl> {
    }
}

