/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.web.logging.atom;

import java.util.logging.Handler;
import org.apache.cxf.management.web.logging.LogRecord;
import org.apache.cxf.management.web.logging.atom.AtomPullServer;
import org.apache.cxf.management.web.logging.atom.LoggingThread;

public final class AtomPullHandler
extends Handler {
    private AtomPullServer engine;

    AtomPullHandler(AtomPullServer engine) {
        this.engine = engine;
    }

    @Override
    public void publish(java.util.logging.LogRecord record) {
        if (LoggingThread.isSilent()) {
            return;
        }
        LoggingThread.markSilent(true);
        try {
            LogRecord rec = LogRecord.fromJUL(record);
            this.engine.publish(rec);
        }
        finally {
            LoggingThread.markSilent(false);
        }
    }

    @Override
    public synchronized void close() throws SecurityException {
        this.engine.close();
    }

    @Override
    public synchronized void flush() {
    }
}

